/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRTextAlignment;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.DocxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxParagraphHelper;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class XlsxStyleInfo {
    protected int formatIndex;
    protected int fontIndex;
    protected int borderIndex;
    protected String backcolor;
    protected String horizontalAlign;
    protected String verticalAlign;
    protected boolean isWrapText = true;
    protected boolean isHidden;
    protected boolean isLocked;
    protected boolean isShrinkToFit;
    protected boolean isIgnoreTextFormatting;

    public XlsxStyleInfo(int formatIndex, int fontIndex, int borderIndex, JRExporterGridCell gridCell, boolean isWrapText, boolean isHidden, boolean isLocked, boolean isShrinkToFit, boolean isIgnoreTextFormatting) {
        JRTextAlignment align;
        this.formatIndex = formatIndex;
        this.fontIndex = isIgnoreTextFormatting ? -1 : fontIndex;
        this.borderIndex = isIgnoreTextFormatting ? -1 : borderIndex;
        JRPrintElement element = gridCell.getElement();
        if (!isIgnoreTextFormatting) {
            if (element != null && element.getModeValue() == ModeEnum.OPAQUE) {
                this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
            } else if (gridCell.getBackcolor() != null) {
                this.backcolor = JRColorUtil.getColorHexa(gridCell.getBackcolor());
            }
        }
        JRTextAlignment jRTextAlignment = align = element instanceof JRTextAlignment ? (JRTextAlignment)((Object)element) : null;
        if (align != null) {
            this.horizontalAlign = XlsxParagraphHelper.getHorizontalAlignment(align.getHorizontalTextAlign());
            this.verticalAlign = DocxCellHelper.getVerticalAlignment(align.getVerticalTextAlign());
        }
        this.isWrapText = isShrinkToFit ? false : isWrapText;
        this.isHidden = isHidden;
        this.isLocked = isLocked;
        this.isShrinkToFit = isShrinkToFit;
    }

    public String getId() {
        return this.formatIndex + "|" + this.fontIndex + "|" + this.borderIndex + "|" + this.backcolor + "|" + this.horizontalAlign + "|" + this.verticalAlign + "|" + this.isWrapText + "|" + this.isHidden + "|" + this.isLocked + "|" + this.isShrinkToFit;
    }
}

