/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRQueryChunkHandler;

public class JRQueryParser {
    public static final String EXCEPTION_MESSAGE_KEY_TOKEN_SEPARATORS_NOT_CONFIGURED = "util.query.token.separators.not.configured";
    private static final JRQueryParser singleton = new JRQueryParser();

    public static JRQueryParser instance() {
        return singleton;
    }

    public void parse(String text, JRQueryChunkHandler chunkHandler) {
        if (text != null) {
            StringBuffer textChunk = new StringBuffer();
            StringTokenizer tkzer = new StringTokenizer(text, "$", true);
            boolean wasDelim = false;
            while (tkzer.hasMoreTokens()) {
                int end;
                String token = tkzer.nextToken();
                if (token.equals("$")) {
                    if (wasDelim) {
                        textChunk.append("$");
                    }
                    wasDelim = true;
                    continue;
                }
                if (token.startsWith("P{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            chunkHandler.handleTextChunk(textChunk.toString());
                        }
                        String parameterChunk = token.substring(2, end);
                        chunkHandler.handleParameterChunk(parameterChunk);
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else if (token.startsWith("P!{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            chunkHandler.handleTextChunk(textChunk.toString());
                        }
                        String parameterClauseChunk = token.substring(3, end);
                        chunkHandler.handleParameterClauseChunk(parameterClauseChunk);
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else if (token.startsWith("X{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            chunkHandler.handleTextChunk(textChunk.toString());
                        }
                        String clauseChunk = token.substring(2, end);
                        this.parseClause(chunkHandler, clauseChunk);
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else {
                    if (wasDelim) {
                        textChunk.append("$");
                    }
                    textChunk.append(token);
                }
                wasDelim = false;
            }
            if (wasDelim) {
                textChunk.append("$");
            }
            if (textChunk.length() > 0) {
                chunkHandler.handleTextChunk(textChunk.toString());
            }
        }
    }

    protected void parseClause(JRQueryChunkHandler chunkHandler, String clauseChunk) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean wasClauseToken = false;
        char separator = this.determineClauseTokenSeparator(clauseChunk);
        String separatorString = String.valueOf(separator);
        StringTokenizer tokenizer = new StringTokenizer(clauseChunk, separatorString, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(separatorString)) {
                if (!wasClauseToken) {
                    tokens.add("");
                }
                wasClauseToken = false;
                continue;
            }
            tokens.add(token);
            wasClauseToken = true;
        }
        if (!wasClauseToken) {
            tokens.add("");
        }
        String[] tokensArray = tokens.toArray(new String[tokens.size()]);
        chunkHandler.handleClauseChunk(tokensArray, separator);
    }

    protected char determineClauseTokenSeparator(String clauseChunk) {
        String allSeparators = this.getTokenSeparators();
        if (allSeparators == null || allSeparators.length() == 0) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_TOKEN_SEPARATORS_NOT_CONFIGURED, (Object[])null);
        }
        int firstSepIdx = 0;
        int clauseLenght = clauseChunk.length();
        for (int idx = 0; idx < clauseLenght; ++idx) {
            int sepIdx = allSeparators.indexOf(clauseChunk.charAt(idx));
            if (sepIdx < 0) continue;
            firstSepIdx = sepIdx;
            break;
        }
        return allSeparators.charAt(firstSepIdx);
    }

    protected String getTokenSeparators() {
        return JRProperties.getProperty("net.sf.jasperreports.query.chunk.token.separators");
    }

    public String asText(JRQueryChunk[] chunks) {
        String text = "";
        if (chunks != null && chunks.length > 0) {
            StringBuffer sbuffer = new StringBuffer();
            block5: for (int i = 0; i < chunks.length; ++i) {
                JRQueryChunk queryChunk = chunks[i];
                switch (queryChunk.getType()) {
                    case 2: {
                        sbuffer.append("$P{");
                        sbuffer.append(queryChunk.getText());
                        sbuffer.append("}");
                        continue block5;
                    }
                    case 3: {
                        sbuffer.append("$P!{");
                        sbuffer.append(queryChunk.getText());
                        sbuffer.append("}");
                        continue block5;
                    }
                    case 4: {
                        sbuffer.append("$X{");
                        sbuffer.append(queryChunk.getText());
                        sbuffer.append("}");
                        continue block5;
                    }
                    default: {
                        sbuffer.append(queryChunk.getText());
                    }
                }
            }
            text = sbuffer.toString();
        }
        return text;
    }

    public String asClauseText(String[] tokens) {
        return this.asClauseText(tokens, null);
    }

    public String asClauseText(String[] tokens, Character separator) {
        if (separator == null) {
            separator = Character.valueOf(this.defaultTokenSeparator());
        }
        StringBuffer sb = new StringBuffer();
        if (tokens != null && tokens.length > 0) {
            for (int i = 0; i < tokens.length; ++i) {
                String token;
                if (i > 0) {
                    sb.append(separator);
                }
                if ((token = tokens[i]) == null) continue;
                sb.append(token);
            }
        }
        return sb.toString();
    }

    protected char defaultTokenSeparator() {
        String tokenSeparators = this.getTokenSeparators();
        return tokenSeparators == null || tokenSeparators.isEmpty() ? (char)',' : tokenSeparators.charAt(0);
    }
}

