<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\bootstrap\Modal;
use yii\helpers\Url;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $searchModel app\models\ClientesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Clientes');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="clientes-index">

    <h1><?= Html::encode($this->title) ?></h1>

	<?php Pjax::begin(['id' => 'ClientesSearchGV-pjax', 'timeout' => false, 'enablePushState' => false]) ?>
	
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'id' => 'ClientesSearchGV',
        'columns' => [
            //['class' => 'yii\grid\SerialColumn'],
            [
    		'header'=>'Selecciona',
    		'value'=> function($data)
              { 
                   return  Html::a( Yii::t('app', '{modelClass}', [
                          				'modelClass' => 'Selecciona',
                          				]
						  			), 
						  Url::to("#"),
						  ['onclick'=>"$('input#remisiones-clientes_id').attr('value','$data->id');
						  $('input#remisiones-numero_identificacion_cliente').attr('value', '$data->id');
						  $('#modalClientesPicker').modal('hide');",
						  'id' => 'ClientesPickerButton']
						  //['#','clientes_picker_id'=>$data->id,
						  //],
						);      
              },
     		'format' => 'raw'
			],
			'id',
            'razon_social',
            'persona',
            'rfc',
            'contacto',
            // 'calle',
            // 'numero',
            // 'interior',
            // 'colonia',
            // 'ciudad',
            // 'estados_id',
            // 'codigo_postal',
            // 'paises_id',
            // 'oficina_alta',
            // 'estatus',
            // 'cuenta_contable',
            // 'dias_credito',
            // 'dias_pago',
            // 'poliza_seguro',
            // 'factor_seguro',
            // 'telefono',
            // 'radio',
            // 'cuenta_pago',
            // 'metodo_pago',
            // 'forma_pago',
            // 'cuenta_extranjera',
            // 'usuario',
            // 'contrasena',
            // 'correo_principal',
            // 'correo_facturas',
            // 'correo_cobranza',
            // 'correo_trafico',
            // 'correo_almacen',
            // 'correo_evidencias',
            // 'destinos',
            // 'tarifas',
            // 'ubicacion',

            //['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
<?php Pjax::end() ?>


</div>
