/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.design;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.sf.jasperreports.crosstabs.CrosstabColumnCell;
import net.sf.jasperreports.crosstabs.CrosstabDeepVisitor;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstab;
import net.sf.jasperreports.crosstabs.design.DesignCrosstabColumnCell;
import net.sf.jasperreports.crosstabs.design.JRCrosstabOrigin;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.HorizontalPosition;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.collections.map.LinkedMap;

public class JRDesignCrosstab
extends JRDesignElement
implements JRCrosstab {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_COLUMN_GROUP_DOES_NOT_EXIST = "crosstabs.design.column.group.does.not.exist";
    public static final String EXCEPTION_MESSAGE_KEY_DUPLICATE_CELL = "crosstabs.design.duplicate.cell";
    public static final String EXCEPTION_MESSAGE_KEY_DUPLICATE_GROUP_OR_MEASURE = "crosstabs.design.duplicate.group.or.measure";
    public static final String EXCEPTION_MESSAGE_KEY_DUPLICATE_PARAMETER = "crosstabs.design.duplicate.parameter";
    public static final String EXCEPTION_MESSAGE_KEY_ROW_GROUP_DOES_NOT_EXIST = "crosstabs.design.row.group.does.not.exist";
    public static final String PROPERTY_COLUMN_BREAK_OFFSET = "columnBreakOffset";
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_TITLE_CELL = "titleCell";
    public static final String PROPERTY_HEADER_CELL = "headerCell";
    public static final String PROPERTY_PARAMETERS_MAP_EXPRESSION = "parametersMapExpression";
    public static final String PROPERTY_REPEAT_COLUMN_HEADERS = "isRepeatColumnHeaders";
    public static final String PROPERTY_REPEAT_ROW_HEADERS = "isRepeatRowHeaders";
    public static final String PROPERTY_WHEN_NO_DATA_CELL = "whenNoDataCell";
    public static final String PROPERTY_CELLS = "cells";
    public static final String PROPERTY_ROW_GROUPS = "rowGroups";
    public static final String PROPERTY_COLUMN_GROUPS = "columnGroups";
    public static final String PROPERTY_MEASURES = "measures";
    public static final String PROPERTY_PARAMETERS = "parameters";
    public static final String PROPERTY_IGNORE_WIDTH = "ignoreWidth";
    protected List<JRCrosstabParameter> parametersList;
    protected Map<String, JRCrosstabParameter> parametersMap;
    protected Map<String, JRVariable> variablesList;
    protected JRExpression parametersMapExpression;
    protected JRDesignCrosstabDataset dataset;
    protected List<JRCrosstabRowGroup> rowGroups;
    protected List<JRCrosstabColumnGroup> columnGroups;
    protected List<JRCrosstabMeasure> measures;
    protected Map<String, Integer> rowGroupsMap;
    protected Map<String, Integer> columnGroupsMap;
    protected Map<String, Integer> measuresMap;
    protected int columnBreakOffset = 10;
    protected boolean repeatColumnHeaders = true;
    protected boolean repeatRowHeaders = true;
    protected RunDirectionEnum runDirectionValue;
    protected HorizontalPosition horizontalPosition;
    protected List<JRCrosstabCell> cellsList;
    protected Map<Pair<String, String>, JRCrosstabCell> cellsMap;
    protected JRDesignCrosstabCell[][] crossCells;
    protected JRDesignCellContents whenNoDataCell;
    protected DesignCrosstabColumnCell titleCell;
    protected JRDesignCellContents headerCell;
    protected Boolean ignoreWidth;
    protected JRLineBox lineBox;
    private PropertyChangeListener measureClassChangeListener = new MeasureClassChangeListener();
    private static final Object[] BUILT_IN_PARAMETERS = new Object[]{"REPORT_CONTEXT", ReportContext.class, "REPORT_PARAMETERS_MAP", Map.class, "REPORT_LOCALE", Locale.class, "REPORT_RESOURCE_BUNDLE", ResourceBundle.class, "REPORT_TIME_ZONE", TimeZone.class, "REPORT_FORMAT_FACTORY", FormatFactory.class, "REPORT_CLASS_LOADER", ClassLoader.class, "REPORT_URL_HANDLER_FACTORY", URLStreamHandlerFactory.class, "REPORT_FILE_RESOLVER", FileResolver.class};
    private static final Object[] BUILT_IN_VARIABLES = new Object[]{"ROW_COUNT", Integer.class, "COLUMN_COUNT", Integer.class};
    private int PSEUDO_SERIAL_VERSION_UID = 60002;
    private byte runDirection;

    public JRDesignCrosstab(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
        this.parametersList = new ArrayList<JRCrosstabParameter>();
        this.parametersMap = new HashMap<String, JRCrosstabParameter>();
        this.rowGroupsMap = new HashMap<String, Integer>();
        this.rowGroups = new ArrayList<JRCrosstabRowGroup>();
        this.columnGroupsMap = new HashMap<String, Integer>();
        this.columnGroups = new ArrayList<JRCrosstabColumnGroup>();
        this.measuresMap = new HashMap<String, Integer>();
        this.measures = new ArrayList<JRCrosstabMeasure>();
        this.cellsMap = new HashMap<Pair<String, String>, JRCrosstabCell>();
        this.cellsList = new ArrayList<JRCrosstabCell>();
        this.addBuiltinParameters();
        this.variablesList = new LinkedMap();
        this.addBuiltinVariables();
        this.dataset = new JRDesignCrosstabDataset();
        this.lineBox = new JRBaseLineBox(this);
    }

    private void addBuiltinParameters() {
        for (int i = 0; i < BUILT_IN_PARAMETERS.length; ++i) {
            JRDesignCrosstabParameter parameter = new JRDesignCrosstabParameter();
            parameter.setName((String)BUILT_IN_PARAMETERS[i++]);
            parameter.setValueClass((Class)BUILT_IN_PARAMETERS[i]);
            parameter.setSystemDefined(true);
            try {
                this.addParameter(parameter);
                continue;
            }
            catch (JRException jRException) {
                // empty catch block
            }
        }
    }

    private void addBuiltinVariables() {
        for (int i = 0; i < BUILT_IN_VARIABLES.length; ++i) {
            JRDesignVariable variable = new JRDesignVariable();
            variable.setName((String)BUILT_IN_VARIABLES[i]);
            variable.setValueClass((Class)BUILT_IN_VARIABLES[++i]);
            variable.setCalculation(CalculationEnum.SYSTEM);
            variable.setSystemDefined(true);
            this.addVariable(variable);
        }
    }

    public JRDesignCrosstab() {
        this(null);
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    public JRDesignCrosstabDataset getDesignDataset() {
        return this.dataset;
    }

    @Override
    public JRCrosstabRowGroup[] getRowGroups() {
        JRCrosstabRowGroup[] groups = new JRCrosstabRowGroup[this.rowGroups.size()];
        this.rowGroups.toArray(groups);
        return groups;
    }

    @Override
    public JRCrosstabColumnGroup[] getColumnGroups() {
        JRCrosstabColumnGroup[] groups = new JRCrosstabColumnGroup[this.columnGroups.size()];
        this.columnGroups.toArray(groups);
        return groups;
    }

    @Override
    public JRCrosstabMeasure[] getMeasures() {
        JRCrosstabMeasure[] measureArray = new JRCrosstabMeasure[this.measures.size()];
        this.measures.toArray(measureArray);
        return measureArray;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitCrosstab(this);
        if (ElementsVisitorUtils.visitDeepElements(visitor)) {
            new CrosstabDeepVisitor(visitor).deepVisitCrosstab(this);
        }
    }

    public void setDataset(JRDesignCrosstabDataset dataset) {
        JRDesignCrosstabDataset old = this.dataset;
        this.dataset = dataset;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET, old, this.dataset);
    }

    public void addRowGroup(JRDesignCrosstabRowGroup group) throws JRException {
        String groupName = group.getName();
        if (this.rowGroupsMap.containsKey(groupName) || this.columnGroupsMap.containsKey(groupName) || this.measuresMap.containsKey(groupName)) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DUPLICATE_GROUP_OR_MEASURE, (Object[])null);
        }
        this.rowGroupsMap.put(groupName, this.rowGroups.size());
        this.rowGroups.add(group);
        this.addRowGroupVars(group);
        this.setParent(group);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_ROW_GROUPS, group, this.rowGroups.size() - 1);
    }

    public void addRowGroup(int index, JRDesignCrosstabRowGroup group) throws JRException {
        String groupName = group.getName();
        if (this.rowGroupsMap.containsKey(groupName) || this.columnGroupsMap.containsKey(groupName) || this.measuresMap.containsKey(groupName)) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DUPLICATE_GROUP_OR_MEASURE, (Object[])null);
        }
        this.rowGroupsMap.put(groupName, this.rowGroups.size());
        this.rowGroups.add(index, group);
        this.addRowGroupVars(group);
        this.setParent(group);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_ROW_GROUPS, group, index);
    }

    protected void addRowGroupVars(JRDesignCrosstabRowGroup rowGroup) {
        this.addVariable(rowGroup.getVariable());
        for (JRCrosstabMeasure measure : this.measures) {
            this.addTotalVar(measure, rowGroup, null);
            for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
                this.addTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public void addColumnGroup(JRDesignCrosstabColumnGroup group) throws JRException {
        String groupName = group.getName();
        if (this.rowGroupsMap.containsKey(groupName) || this.columnGroupsMap.containsKey(groupName) || this.measuresMap.containsKey(groupName)) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DUPLICATE_GROUP_OR_MEASURE, (Object[])null);
        }
        this.columnGroupsMap.put(groupName, this.columnGroups.size());
        this.columnGroups.add(group);
        this.addColGroupVars(group);
        this.setParent(group);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_COLUMN_GROUPS, group, this.columnGroups.size() - 1);
    }

    public void addColumnGroup(int index, JRDesignCrosstabColumnGroup group) throws JRException {
        String groupName = group.getName();
        if (this.rowGroupsMap.containsKey(groupName) || this.columnGroupsMap.containsKey(groupName) || this.measuresMap.containsKey(groupName)) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DUPLICATE_GROUP_OR_MEASURE, (Object[])null);
        }
        this.columnGroupsMap.put(groupName, this.columnGroups.size());
        this.columnGroups.add(index, group);
        this.addColGroupVars(group);
        this.setParent(group);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_COLUMN_GROUPS, group, index);
    }

    protected void addColGroupVars(JRDesignCrosstabColumnGroup colGroup) {
        this.addVariable(colGroup.getVariable());
        for (JRCrosstabMeasure measure : this.measures) {
            this.addTotalVar(measure, null, colGroup);
            for (JRCrosstabRowGroup rowGroup : this.rowGroups) {
                this.addTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public void addMeasure(JRDesignCrosstabMeasure measure) throws JRException {
        String measureName = measure.getName();
        if (this.rowGroupsMap.containsKey(measureName) || this.columnGroupsMap.containsKey(measureName) || this.measuresMap.containsKey(measureName)) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DUPLICATE_GROUP_OR_MEASURE, (Object[])null);
        }
        measure.addPropertyChangeListener("valueClassName", this.measureClassChangeListener);
        this.measuresMap.put(measureName, this.measures.size());
        this.measures.add(measure);
        this.addMeasureVars(measure);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MEASURES, measure, this.measures.size() - 1);
    }

    public void addMeasure(int index, JRDesignCrosstabMeasure measure) throws JRException {
        String measureName = measure.getName();
        if (this.rowGroupsMap.containsKey(measureName) || this.columnGroupsMap.containsKey(measureName) || this.measuresMap.containsKey(measureName)) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DUPLICATE_GROUP_OR_MEASURE, (Object[])null);
        }
        measure.addPropertyChangeListener("valueClassName", this.measureClassChangeListener);
        this.measuresMap.put(measureName, this.measures.size());
        this.measures.add(index, measure);
        this.addMeasureVars(measure);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MEASURES, measure, index);
    }

    protected void addMeasureVars(JRDesignCrosstabMeasure measure) {
        this.addVariable(measure.getVariable());
        for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
            this.addTotalVar(measure, null, colGroup);
        }
        for (JRCrosstabRowGroup rowGroup : this.rowGroups) {
            this.addTotalVar(measure, rowGroup, null);
            for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
                this.addTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    protected void addTotalVar(JRCrosstabMeasure measure, JRCrosstabRowGroup rowGroup, JRCrosstabColumnGroup colGroup) {
        JRDesignVariable var = new JRDesignVariable();
        var.setCalculation(CalculationEnum.SYSTEM);
        var.setSystemDefined(true);
        var.setName(JRDesignCrosstab.getTotalVariableName(measure, rowGroup, colGroup));
        var.setValueClassName(measure.getValueClassName());
        this.addVariable(var);
    }

    protected void removeTotalVar(JRCrosstabMeasure measure, JRCrosstabRowGroup rowGroup, JRCrosstabColumnGroup colGroup) {
        String varName = JRDesignCrosstab.getTotalVariableName(measure, rowGroup, colGroup);
        this.removeVariable(varName);
    }

    public static String getTotalVariableName(JRCrosstabMeasure measure, JRCrosstabRowGroup rowGroup, JRCrosstabColumnGroup colGroup) {
        StringBuffer name = new StringBuffer();
        name.append(measure.getName());
        if (rowGroup != null) {
            name.append('_');
            name.append(rowGroup.getName());
        }
        if (colGroup != null) {
            name.append('_');
            name.append(colGroup.getName());
        }
        name.append("_ALL");
        return name.toString();
    }

    public JRCrosstabRowGroup removeRowGroup(String groupName) {
        JRCrosstabRowGroup removed = null;
        Integer idx = this.rowGroupsMap.remove(groupName);
        if (idx != null) {
            removed = this.rowGroups.remove(idx);
            Iterator<JRCloneable> it = this.rowGroups.listIterator(idx);
            while (it.hasNext()) {
                JRCrosstabRowGroup group = it.next();
                this.rowGroupsMap.put(group.getName(), it.previousIndex());
            }
            it = this.cellsList.iterator();
            while (it.hasNext()) {
                JRCrosstabCell cell = (JRCrosstabCell)it.next();
                String rowTotalGroup = cell.getRowTotalGroup();
                if (rowTotalGroup == null || !rowTotalGroup.equals(groupName)) continue;
                it.remove();
                this.cellsMap.remove(new Pair<String, String>(rowTotalGroup, cell.getColumnTotalGroup()));
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CELLS, cell, -1);
            }
            this.removeRowGroupVars(removed);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_ROW_GROUPS, removed, idx);
        }
        return removed;
    }

    protected void removeRowGroupVars(JRCrosstabRowGroup rowGroup) {
        this.removeVariable(rowGroup.getVariable());
        for (JRCrosstabMeasure measure : this.measures) {
            this.removeTotalVar(measure, rowGroup, null);
            for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
                this.removeTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public JRCrosstabRowGroup removeRowGroup(JRCrosstabRowGroup group) {
        return this.removeRowGroup(group.getName());
    }

    public JRCrosstabColumnGroup removeColumnGroup(String groupName) {
        JRCrosstabColumnGroup removed = null;
        Integer idx = this.columnGroupsMap.remove(groupName);
        if (idx != null) {
            removed = this.columnGroups.remove(idx);
            Iterator<JRCloneable> it = this.columnGroups.listIterator(idx);
            while (it.hasNext()) {
                JRCrosstabColumnGroup group = it.next();
                this.columnGroupsMap.put(group.getName(), it.previousIndex());
            }
            it = this.cellsList.iterator();
            while (it.hasNext()) {
                JRCrosstabCell cell = (JRCrosstabCell)it.next();
                String columnTotalGroup = cell.getColumnTotalGroup();
                if (columnTotalGroup == null || !columnTotalGroup.equals(groupName)) continue;
                it.remove();
                this.cellsMap.remove(new Pair<String, String>(cell.getRowTotalGroup(), columnTotalGroup));
                this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CELLS, cell, -1);
            }
            this.removeColGroupVars(removed);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_COLUMN_GROUPS, removed, idx);
        }
        return removed;
    }

    protected void removeColGroupVars(JRCrosstabColumnGroup colGroup) {
        this.removeVariable(colGroup.getVariable());
        for (JRCrosstabMeasure measure : this.measures) {
            this.removeTotalVar(measure, null, colGroup);
            for (JRCrosstabRowGroup rowGroup : this.rowGroups) {
                this.removeTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public JRCrosstabColumnGroup removeColumnGroup(JRCrosstabColumnGroup group) {
        return this.removeColumnGroup(group.getName());
    }

    public JRCrosstabMeasure removeMeasure(String measureName) {
        JRDesignCrosstabMeasure removed = null;
        Integer idx = this.measuresMap.remove(measureName);
        if (idx != null) {
            removed = (JRDesignCrosstabMeasure)this.measures.remove(idx);
            ListIterator<JRCrosstabMeasure> it = this.measures.listIterator(idx);
            while (it.hasNext()) {
                JRCrosstabMeasure group = it.next();
                this.measuresMap.put(group.getName(), it.previousIndex());
            }
            this.removeMeasureVars(removed);
            removed.removePropertyChangeListener("valueClassName", this.measureClassChangeListener);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_MEASURES, removed, idx);
        }
        return removed;
    }

    protected void removeMeasureVars(JRDesignCrosstabMeasure measure) {
        this.removeVariable(measure.getVariable());
        for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
            this.removeTotalVar(measure, null, colGroup);
        }
        for (JRCrosstabRowGroup rowGroup : this.rowGroups) {
            this.removeTotalVar(measure, rowGroup, null);
            for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
                this.removeTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public JRCrosstabMeasure removeMeasure(JRCrosstabMeasure measure) {
        return this.removeMeasure(measure.getName());
    }

    @Override
    public boolean isRepeatColumnHeaders() {
        return this.repeatColumnHeaders;
    }

    public void setRepeatColumnHeaders(boolean repeatColumnHeaders) {
        boolean old = this.repeatColumnHeaders;
        this.repeatColumnHeaders = repeatColumnHeaders;
        this.getEventSupport().firePropertyChange(PROPERTY_REPEAT_COLUMN_HEADERS, old, this.repeatColumnHeaders);
    }

    @Override
    public boolean isRepeatRowHeaders() {
        return this.repeatRowHeaders;
    }

    public void setRepeatRowHeaders(boolean repeatRowHeaders) {
        boolean old = this.repeatRowHeaders;
        this.repeatRowHeaders = repeatRowHeaders;
        this.getEventSupport().firePropertyChange(PROPERTY_REPEAT_ROW_HEADERS, old, this.repeatRowHeaders);
    }

    @Override
    public JRCrosstabCell[][] getCells() {
        return this.crossCells;
    }

    public List<JRCrosstabCell> getCellsList() {
        return this.cellsList;
    }

    public Map<Pair<String, String>, JRCrosstabCell> getCellsMap() {
        return this.cellsMap;
    }

    public void addCell(JRDesignCrosstabCell cell) throws JRException {
        String rowTotalGroup = cell.getRowTotalGroup();
        if (rowTotalGroup != null && !this.rowGroupsMap.containsKey(rowTotalGroup)) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_ROW_GROUP_DOES_NOT_EXIST, new Object[]{rowTotalGroup});
        }
        String columnTotalGroup = cell.getColumnTotalGroup();
        if (columnTotalGroup != null && !this.columnGroupsMap.containsKey(columnTotalGroup)) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_ROW_GROUP_DOES_NOT_EXIST, new Object[]{columnTotalGroup});
        }
        Pair<String, String> cellKey = new Pair<String, String>(rowTotalGroup, columnTotalGroup);
        if (this.cellsMap.containsKey(cellKey)) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DUPLICATE_CELL, (Object[])null);
        }
        this.cellsMap.put(cellKey, cell);
        this.cellsList.add(cell);
        this.setCellOrigin(cell.getContents(), new JRCrosstabOrigin(this, 7, rowTotalGroup, columnTotalGroup));
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CELLS, cell, this.cellsList.size() - 1);
    }

    public JRCrosstabCell removeCell(String rowTotalGroup, String columnTotalGroup) {
        Pair<String, String> cellKey = new Pair<String, String>(rowTotalGroup, columnTotalGroup);
        JRCrosstabCell cell = this.cellsMap.remove(cellKey);
        if (cell != null) {
            this.cellsList.remove(cell);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CELLS, cell, -1);
        }
        return cell;
    }

    public JRCrosstabCell removeCell(JRCrosstabCell cell) {
        return this.removeCell(cell.getRowTotalGroup(), cell.getColumnTotalGroup());
    }

    @Override
    public JRCrosstabParameter[] getParameters() {
        JRCrosstabParameter[] parameters = new JRCrosstabParameter[this.parametersList.size()];
        this.parametersList.toArray(parameters);
        return parameters;
    }

    public List<JRCrosstabParameter> getParametersList() {
        return this.parametersList;
    }

    public Map<String, JRCrosstabParameter> getParametersMap() {
        return this.parametersMap;
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public void addParameter(JRCrosstabParameter parameter) throws JRException {
        if (this.parametersMap.containsKey(parameter.getName()) && this.parametersMap.containsKey(parameter.getName())) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DUPLICATE_PARAMETER, new Object[]{parameter.getName()});
        }
        this.parametersMap.put(parameter.getName(), parameter);
        this.parametersList.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, parameter, this.parametersList.size() - 1);
    }

    public void addParameter(int index, JRCrosstabParameter parameter) throws JRException {
        if (this.parametersMap.containsKey(parameter.getName()) && this.parametersMap.containsKey(parameter.getName())) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DUPLICATE_PARAMETER, new Object[]{parameter.getName()});
        }
        this.parametersMap.put(parameter.getName(), parameter);
        this.parametersList.add(index, parameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, parameter, index);
    }

    public JRCrosstabParameter removeParameter(String parameterName) {
        JRCrosstabParameter param = this.parametersMap.remove(parameterName);
        if (param != null) {
            int idx = this.parametersList.indexOf(param);
            if (idx >= 0) {
                this.parametersList.remove(idx);
            }
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, param, idx);
        }
        return param;
    }

    public JRCrosstabParameter removeParameter(JRCrosstabParameter parameter) {
        return this.removeParameter(parameter.getName());
    }

    public void setParametersMapExpression(JRExpression expression) {
        JRExpression old = this.parametersMapExpression;
        this.parametersMapExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_PARAMETERS_MAP_EXPRESSION, old, this.parametersMapExpression);
    }

    public Map<String, JRVariable> getVariablesMap() {
        JRVariable[] variables = this.getVariables();
        HashMap<String, JRVariable> variablesMap = new HashMap<String, JRVariable>();
        for (int i = 0; i < variables.length; ++i) {
            variablesMap.put(variables[i].getName(), variables[i]);
        }
        return variablesMap;
    }

    @Override
    public JRVariable[] getVariables() {
        JRVariable[] variables = new JRVariable[this.variablesList.size()];
        this.variablesList.values().toArray(variables);
        return variables;
    }

    @Override
    public int getColumnBreakOffset() {
        return this.columnBreakOffset;
    }

    public void setColumnBreakOffset(int columnBreakOffset) {
        int old = this.columnBreakOffset;
        this.columnBreakOffset = columnBreakOffset;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMN_BREAK_OFFSET, old, this.columnBreakOffset);
    }

    public void preprocess() {
        this.setGroupVariablesClass(this.rowGroups);
        this.setGroupVariablesClass(this.columnGroups);
        this.calculateSizes();
    }

    protected <T> void setGroupVariablesClass(List<T> groups) {
        for (JRDesignCrosstabGroup group : groups) {
            JRExpression expression;
            JRCrosstabBucket bucket = group.getBucket();
            if (bucket == null || (expression = bucket.getExpression()) == null) continue;
            group.designVariable.setValueClassName(bucket.getValueClassName());
        }
    }

    protected void calculateSizes() {
        this.setWhenNoDataCellSize();
        this.createCellMatrix();
        int rowHeadersWidth = this.calculateRowHeadersSizes();
        int colHeadersHeight = this.calculateColumnHeadersSizes(rowHeadersWidth);
        if (this.headerCell != null) {
            this.headerCell.setWidth(rowHeadersWidth);
            this.headerCell.setHeight(colHeadersHeight);
        }
        this.setTitleSize(rowHeadersWidth);
    }

    protected void setWhenNoDataCellSize() {
        if (this.whenNoDataCell != null) {
            this.whenNoDataCell.setWidth(this.getWidth());
            this.whenNoDataCell.setHeight(this.getHeight());
        }
    }

    protected void createCellMatrix() {
        this.crossCells = new JRDesignCrosstabCell[this.rowGroups.size() + 1][this.columnGroups.size() + 1];
        for (JRDesignCrosstabCell jRDesignCrosstabCell : this.cellsList) {
            String columnTotalGroup;
            JRDesignCellContents contents = (JRDesignCellContents)jRDesignCrosstabCell.getContents();
            String rowTotalGroup = jRDesignCrosstabCell.getRowTotalGroup();
            int rowGroupIndex = rowTotalGroup == null ? this.rowGroups.size() : this.rowGroupsMap.get(rowTotalGroup).intValue();
            Integer cellWidth = jRDesignCrosstabCell.getWidth();
            if (cellWidth != null) {
                contents.setWidth(cellWidth);
            }
            int columnGroupIndex = (columnTotalGroup = jRDesignCrosstabCell.getColumnTotalGroup()) == null ? this.columnGroups.size() : this.columnGroupsMap.get(columnTotalGroup).intValue();
            Integer cellHeight = jRDesignCrosstabCell.getHeight();
            if (cellHeight != null) {
                contents.setHeight(cellHeight);
            }
            this.crossCells[rowGroupIndex][columnGroupIndex] = jRDesignCrosstabCell;
        }
        this.inheritCells();
    }

    protected JRDesignCrosstabRowGroup getRowGroup(int rowGroupIndex) {
        return (JRDesignCrosstabRowGroup)this.rowGroups.get(rowGroupIndex);
    }

    protected JRDesignCrosstabColumnGroup getColumnGroup(int columnGroupIndex) {
        return (JRDesignCrosstabColumnGroup)this.columnGroups.get(columnGroupIndex);
    }

    protected void inheritCells() {
        for (int i = this.rowGroups.size(); i >= 0; --i) {
            for (int j = this.columnGroups.size(); j >= 0; --j) {
                boolean used;
                boolean bl = used = !(i != this.rowGroups.size() && !this.getRowGroup(i).hasTotal() || j != this.columnGroups.size() && !this.getColumnGroup(j).hasTotal());
                if (used) {
                    if (this.crossCells[i][j] == null) {
                        this.inheritCell(i, j);
                        if (this.crossCells[i][j] != null) continue;
                        this.crossCells[i][j] = this.emptyCell(i, j);
                        this.inheritCellSize(i, j);
                        continue;
                    }
                    this.inheritCellSize(i, j);
                    continue;
                }
                this.crossCells[i][j] = null;
            }
        }
    }

    private JRDesignCrosstabCell emptyCell(int i, int j) {
        JRDesignCrosstabCell emptyCell = new JRDesignCrosstabCell();
        if (i < this.rowGroups.size()) {
            emptyCell.setRowTotalGroup(this.rowGroups.get(i).getName());
        }
        if (j < this.columnGroups.size()) {
            emptyCell.setColumnTotalGroup(this.columnGroups.get(j).getName());
        }
        return emptyCell;
    }

    protected void inheritCellSize(int i, int j) {
        JRDesignCellContents contents;
        block6: {
            block7: {
                JRDesignCrosstabCell cell = this.crossCells[i][j];
                contents = (JRDesignCellContents)cell.getContents();
                if (contents.getWidth() != Integer.MIN_VALUE) break block6;
                if (i >= this.rowGroups.size()) break block7;
                JRDesignCrosstabCell rowCell = this.crossCells[this.rowGroups.size()][j];
                if (rowCell == null) break block6;
                contents.setWidth(rowCell.getContents().getWidth());
                break block6;
            }
            for (int k = j + 1; k <= this.columnGroups.size(); ++k) {
                if (this.crossCells[i][k] == null) continue;
                contents.setWidth(this.crossCells[i][k].getContents().getWidth());
                break;
            }
        }
        if (contents.getHeight() == Integer.MIN_VALUE) {
            if (j < this.columnGroups.size()) {
                JRDesignCrosstabCell colCell = this.crossCells[i][this.columnGroups.size()];
                if (colCell != null) {
                    contents.setHeight(colCell.getContents().getHeight());
                }
            } else {
                for (int k = i + 1; k <= this.rowGroups.size(); ++k) {
                    if (this.crossCells[k][j] == null) continue;
                    contents.setHeight(this.crossCells[k][j].getContents().getHeight());
                }
            }
        }
    }

    protected void inheritCell(int i, int j) {
        JRDesignCellContents contents;
        JRDesignCrosstabCell cell;
        int k;
        JRDesignCrosstabCell inheritedCell = null;
        if (j < this.columnGroups.size()) {
            JRDesignCrosstabCell colCell = this.crossCells[this.rowGroups.size()][j];
            JRDesignCellContents colContents = colCell == null ? null : (JRDesignCellContents)colCell.getContents();
            for (k = j + 1; inheritedCell == null && k <= this.columnGroups.size(); ++k) {
                cell = this.crossCells[i][k];
                if (cell == null) continue;
                contents = (JRDesignCellContents)cell.getContents();
                if (colContents != null && contents.getWidth() != colContents.getWidth()) continue;
                inheritedCell = cell;
            }
        }
        if (inheritedCell == null && i < this.rowGroups.size()) {
            JRDesignCrosstabCell rowCell = this.crossCells[i][this.columnGroups.size()];
            JRDesignCellContents rowContents = rowCell == null ? null : (JRDesignCellContents)rowCell.getContents();
            for (k = i + 1; inheritedCell == null && k <= this.rowGroups.size(); ++k) {
                cell = this.crossCells[k][j];
                if (cell == null) continue;
                contents = (JRDesignCellContents)cell.getContents();
                if (rowContents != null && contents.getHeight() != rowContents.getHeight()) continue;
                inheritedCell = cell;
            }
        }
        this.crossCells[i][j] = inheritedCell;
    }

    protected int calculateRowHeadersSizes() {
        int widthSum = 0;
        int heightSum = 0;
        for (int i = this.rowGroups.size() - 1; i >= 0; --i) {
            JRDesignCrosstabRowGroup group = (JRDesignCrosstabRowGroup)this.rowGroups.get(i);
            widthSum += group.getWidth();
            JRDesignCrosstabCell cell = this.crossCells[i + 1][this.columnGroups.size()];
            if (cell != null) {
                heightSum += cell.getContents().getHeight();
            }
            JRDesignCellContents header = (JRDesignCellContents)group.getHeader();
            header.setHeight(heightSum);
            header.setWidth(group.getWidth());
            if (!group.hasTotal()) continue;
            JRDesignCellContents totalHeader = (JRDesignCellContents)group.getTotalHeader();
            totalHeader.setWidth(widthSum);
            JRDesignCrosstabCell totalCell = this.crossCells[i][this.columnGroups.size()];
            if (totalCell == null) continue;
            totalHeader.setHeight(totalCell.getContents().getHeight());
        }
        return widthSum;
    }

    protected int calculateColumnHeadersSizes(int rowHeadersWidth) {
        int heightSum = 0;
        int widthSum = 0;
        for (int i = this.columnGroups.size() - 1; i >= 0; --i) {
            JRDesignCellContents crosstabHeader;
            JRDesignCrosstabColumnGroup group = (JRDesignCrosstabColumnGroup)this.columnGroups.get(i);
            heightSum += group.getHeight();
            JRDesignCrosstabCell cell = this.crossCells[this.rowGroups.size()][i + 1];
            if (cell != null) {
                widthSum += cell.getContents().getWidth();
            }
            if ((crosstabHeader = (JRDesignCellContents)group.getCrosstabHeader()) != null) {
                crosstabHeader.setWidth(rowHeadersWidth);
                crosstabHeader.setHeight(group.getHeight());
            }
            JRDesignCellContents header = (JRDesignCellContents)group.getHeader();
            header.setHeight(group.getHeight());
            header.setWidth(widthSum);
            if (!group.hasTotal()) continue;
            JRDesignCellContents totalHeader = (JRDesignCellContents)group.getTotalHeader();
            totalHeader.setHeight(heightSum);
            JRDesignCrosstabCell totalCell = this.crossCells[this.rowGroups.size()][i];
            if (totalCell == null) continue;
            totalHeader.setWidth(totalCell.getContents().getWidth());
        }
        return heightSum;
    }

    protected void setTitleSize(int rowHeadersWidth) {
        if (this.titleCell != null && this.titleCell.getDesignCellContents() != null) {
            JRDesignCellContents titleContents = this.titleCell.getDesignCellContents();
            titleContents.setHeight(this.titleCell.getHeight());
            int titleWidth = rowHeadersWidth;
            if (!this.columnGroups.isEmpty()) {
                JRCrosstabColumnGroup firstGroup = this.columnGroups.get(0);
                titleWidth += firstGroup.getHeader().getWidth();
                if (firstGroup.hasTotal()) {
                    titleWidth += firstGroup.getTotalHeader().getWidth();
                }
            }
            titleContents.setWidth(titleWidth);
        }
    }

    @Override
    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public void setWhenNoDataCell(JRDesignCellContents whenNoDataCell) {
        JRDesignCellContents old = this.whenNoDataCell;
        this.whenNoDataCell = whenNoDataCell;
        this.setCellOrigin(this.whenNoDataCell, new JRCrosstabOrigin(this, 2));
        this.getEventSupport().firePropertyChange(PROPERTY_WHEN_NO_DATA_CELL, old, this.whenNoDataCell);
    }

    @Override
    public JRElement getElementByKey(String elementKey) {
        return JRBaseCrosstab.getElementByKey(this, elementKey);
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public CrosstabColumnCell getTitleCell() {
        return this.titleCell;
    }

    public void setTitleCell(DesignCrosstabColumnCell titleCell) {
        DesignCrosstabColumnCell old = this.titleCell;
        this.titleCell = titleCell;
        if (this.titleCell != null) {
            this.setCellOrigin(this.titleCell.getCellContents(), new JRCrosstabOrigin(this, 9));
        }
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_CELL, old, this.titleCell);
    }

    @Override
    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    public void setHeaderCell(JRDesignCellContents headerCell) {
        JRDesignCellContents old = this.headerCell;
        this.headerCell = headerCell;
        this.setCellOrigin(this.headerCell, new JRCrosstabOrigin(this, 1));
        this.getEventSupport().firePropertyChange(PROPERTY_HEADER_CELL, old, this.headerCell);
    }

    protected void measureClassChanged(JRDesignCrosstabMeasure measure, String valueClassName) {
        for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
            this.setTotalVarClass(measure, null, colGroup, valueClassName);
        }
        for (JRCrosstabRowGroup rowGroup : this.rowGroups) {
            this.setTotalVarClass(measure, rowGroup, null, valueClassName);
            for (JRCrosstabColumnGroup colGroup : this.columnGroups) {
                this.setTotalVarClass(measure, rowGroup, colGroup, valueClassName);
            }
        }
    }

    protected void setTotalVarClass(JRCrosstabMeasure measure, JRCrosstabRowGroup rowGroup, JRCrosstabColumnGroup colGroup, String valueClassName) {
        JRDesignVariable variable = this.getVariable(JRDesignCrosstab.getTotalVariableName(measure, rowGroup, colGroup));
        variable.setValueClassName(valueClassName);
    }

    private void addVariable(JRVariable variable) {
        this.variablesList.put(variable.getName(), variable);
    }

    private void removeVariable(JRVariable variable) {
        this.removeVariable(variable.getName());
    }

    private void removeVariable(String varName) {
        this.variablesList.remove(varName);
    }

    private JRDesignVariable getVariable(String varName) {
        return (JRDesignVariable)this.variablesList.get(varName);
    }

    @Override
    public RunDirectionEnum getRunDirectionValue() {
        return this.runDirectionValue;
    }

    @Override
    public void setRunDirection(RunDirectionEnum runDirectionValue) {
        RunDirectionEnum old = this.runDirectionValue;
        this.runDirectionValue = runDirectionValue;
        this.getEventSupport().firePropertyChange("runDirection", old, this.runDirectionValue);
    }

    @Override
    public HorizontalPosition getHorizontalPosition() {
        return this.horizontalPosition;
    }

    @Override
    public void setHorizontalPosition(HorizontalPosition horizontalPosition) {
        HorizontalPosition old = this.horizontalPosition;
        this.horizontalPosition = horizontalPosition;
        this.getEventSupport().firePropertyChange("horizontalPosition", old, this.horizontalPosition);
    }

    protected void setCellOrigin(JRCellContents cell, JRCrosstabOrigin origin) {
        if (cell instanceof JRDesignCellContents) {
            this.setCellOrigin((JRDesignCellContents)cell, origin);
        }
    }

    protected void setCellOrigin(JRDesignCellContents cell, JRCrosstabOrigin origin) {
        if (cell != null) {
            cell.setOrigin(origin);
        }
    }

    protected void setParent(JRDesignCrosstabGroup group) {
        if (group != null) {
            group.setParent(this);
        }
    }

    @Override
    public Object clone() {
        JRDesignCrosstabGroup groupClone;
        JRDesignCrosstabGroup group;
        JRDesignCrosstab clone = (JRDesignCrosstab)super.clone();
        if (this.parametersList != null) {
            clone.parametersList = new ArrayList<JRCrosstabParameter>(this.parametersList.size());
            clone.parametersMap = new HashMap<String, JRCrosstabParameter>(this.parametersList.size());
            for (int i = 0; i < this.parametersList.size(); ++i) {
                JRCrosstabParameter parameter = (JRCrosstabParameter)JRCloneUtils.nullSafeClone((JRCloneable)this.parametersList.get(i));
                clone.parametersList.add(parameter);
                clone.parametersMap.put(parameter.getName(), parameter);
            }
        }
        clone.parametersMapExpression = JRCloneUtils.nullSafeClone(this.parametersMapExpression);
        clone.dataset = JRCloneUtils.nullSafeClone(this.dataset);
        clone.lineBox = this.lineBox.clone(clone);
        HashMap<JRDesignVariable, JRDesignVariable> clonedVariables = new HashMap<JRDesignVariable, JRDesignVariable>();
        if (this.rowGroups != null) {
            clone.rowGroups = new ArrayList<JRCrosstabRowGroup>(this.rowGroups.size());
            clone.rowGroupsMap = new HashMap<String, Integer>(this.rowGroups.size());
            for (int i = 0; i < this.rowGroups.size(); ++i) {
                group = (JRDesignCrosstabRowGroup)this.rowGroups.get(i);
                groupClone = (JRDesignCrosstabRowGroup)group.clone(clone);
                clone.rowGroups.add((JRCrosstabRowGroup)((Object)groupClone));
                clone.rowGroupsMap.put(groupClone.getName(), i);
                this.adjustCrosstabReference(clone, (JRDesignCellContents)groupClone.getTotalHeader());
                this.adjustCrosstabReference(clone, (JRDesignCellContents)groupClone.getHeader());
                if (((JRDesignCrosstabRowGroup)group).designVariable == null) continue;
                clonedVariables.put(((JRDesignCrosstabRowGroup)group).designVariable, ((JRDesignCrosstabRowGroup)groupClone).designVariable);
            }
        }
        if (this.columnGroups != null) {
            clone.columnGroups = new ArrayList<JRCrosstabColumnGroup>(this.columnGroups.size());
            clone.columnGroupsMap = new HashMap<String, Integer>(this.columnGroups.size());
            for (int i = 0; i < this.columnGroups.size(); ++i) {
                group = (JRDesignCrosstabColumnGroup)this.columnGroups.get(i);
                groupClone = (JRDesignCrosstabColumnGroup)group.clone(clone);
                clone.columnGroups.add((JRCrosstabColumnGroup)((Object)groupClone));
                clone.columnGroupsMap.put(groupClone.getName(), i);
                this.adjustCrosstabReference(clone, (JRDesignCellContents)((JRDesignCrosstabColumnGroup)groupClone).getCrosstabHeader());
                this.adjustCrosstabReference(clone, (JRDesignCellContents)groupClone.getTotalHeader());
                this.adjustCrosstabReference(clone, (JRDesignCellContents)groupClone.getHeader());
                if (((JRDesignCrosstabColumnGroup)group).designVariable == null) continue;
                clonedVariables.put(((JRDesignCrosstabColumnGroup)group).designVariable, ((JRDesignCrosstabColumnGroup)groupClone).designVariable);
            }
        }
        if (this.measures != null) {
            clone.measures = new ArrayList<JRCrosstabMeasure>(this.measures.size());
            clone.measuresMap = new HashMap<String, Integer>(this.measures.size());
            for (int i = 0; i < this.measures.size(); ++i) {
                JRDesignCrosstabMeasure measure = (JRDesignCrosstabMeasure)this.measures.get(i);
                JRDesignCrosstabMeasure clonedMeasure = JRCloneUtils.nullSafeClone(measure);
                clone.measures.add(clonedMeasure);
                clone.measuresMap.put(clonedMeasure.getName(), i);
                if (clonedMeasure.designVariable == null) continue;
                clonedVariables.put(measure.designVariable, clonedMeasure.designVariable);
            }
        }
        if (this.variablesList != null) {
            clone.variablesList = new LinkedMap(this.variablesList.size());
            for (JRVariable variable : this.variablesList.values()) {
                JRVariable variableClone = (JRVariable)clonedVariables.get(variable);
                variableClone = JRCloneUtils.nullSafeClone(variable);
                clone.variablesList.put(variableClone.getName(), variableClone);
            }
        }
        if (this.cellsList != null) {
            clone.cellsList = new ArrayList<JRCrosstabCell>(this.cellsList.size());
            clone.cellsMap = new HashMap<Pair<String, String>, JRCrosstabCell>(this.cellsList.size());
            for (int i = 0; i < this.cellsList.size(); ++i) {
                JRCrosstabCell cell = (JRCrosstabCell)JRCloneUtils.nullSafeClone((JRCloneable)this.cellsList.get(i));
                this.adjustCrosstabReference(clone, (JRDesignCellContents)cell.getContents());
                clone.cellsList.add(cell);
                clone.cellsMap.put(new Pair<String, String>(cell.getRowTotalGroup(), cell.getColumnTotalGroup()), cell);
            }
        }
        clone.crossCells = null;
        clone.whenNoDataCell = JRCloneUtils.nullSafeClone(this.whenNoDataCell);
        this.adjustCrosstabReference(clone, clone.whenNoDataCell);
        clone.titleCell = JRCloneUtils.nullSafeClone(this.titleCell);
        if (clone.titleCell != null) {
            this.adjustCrosstabReference(clone, clone.titleCell.getDesignCellContents());
        }
        clone.headerCell = JRCloneUtils.nullSafeClone(this.headerCell);
        this.adjustCrosstabReference(clone, clone.headerCell);
        return clone;
    }

    private void adjustCrosstabReference(JRDesignCrosstab clone, JRDesignCellContents contents) {
        if (contents == null) {
            return;
        }
        contents.setOrigin(new JRCrosstabOrigin(clone, contents.getOrigin().getType(), contents.getOrigin().getRowGroupName(), contents.getOrigin().getColumnGroupName()));
    }

    public List<JRCrosstabRowGroup> getRowGroupsList() {
        return this.rowGroups;
    }

    public Map<String, Integer> getRowGroupIndicesMap() {
        return this.rowGroupsMap;
    }

    public List<JRCrosstabColumnGroup> getColumnGroupsList() {
        return this.columnGroups;
    }

    public Map<String, Integer> getColumnGroupIndicesMap() {
        return this.columnGroupsMap;
    }

    public List<JRCrosstabMeasure> getMesuresList() {
        return this.measures;
    }

    public Map<String, Integer> getMeasureIndicesMap() {
        return this.measuresMap;
    }

    @Override
    public Boolean getIgnoreWidth() {
        return this.ignoreWidth;
    }

    @Override
    public void setIgnoreWidth(Boolean ignoreWidth) {
        Boolean old = this.ignoreWidth;
        this.ignoreWidth = ignoreWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_IGNORE_WIDTH, old, this.ignoreWidth);
    }

    @Override
    public void setIgnoreWidth(boolean ignoreWidth) {
        this.setIgnoreWidth((Boolean)ignoreWidth);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.runDirectionValue = RunDirectionEnum.getByValue(this.runDirection);
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
        }
        if (this.variablesList instanceof SequencedHashMap) {
            this.variablesList = new LinkedMap(this.variablesList);
        }
    }

    private class MeasureClassChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 10200L;

        private MeasureClassChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JRDesignCrosstab.this.measureClassChanged((JRDesignCrosstabMeasure)evt.getSource(), (String)evt.getNewValue());
        }
    }
}

