/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.fill.JRPercentageCalculator;
import net.sf.jasperreports.crosstabs.fill.JRPercentageCalculatorFactory;
import net.sf.jasperreports.crosstabs.type.CrosstabPercentageEnum;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReturnValue;
import net.sf.jasperreports.engine.analytics.dataset.MultiAxisData;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory;
import net.sf.jasperreports.engine.part.PartComponent;
import net.sf.jasperreports.engine.part.PartComponentCompiler;
import net.sf.jasperreports.engine.part.PartComponentManager;
import net.sf.jasperreports.engine.part.PartComponentsEnvironment;
import net.sf.jasperreports.engine.part.PartEvaluationTime;
import net.sf.jasperreports.engine.query.QueryExecuterFactory;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.PartEvaluationTimeType;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.type.SectionTypeEnum;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRVerifier {
    private static final Log log = LogFactory.getLog(JRVerifier.class);
    public static final String PROPERTY_ALLOW_ELEMENT_OVERLAP = "net.sf.jasperreports.allow.element.overlap";
    public static final String PROPERTY_ALLOW_ELEMENT_NEGATIVE_WIDTH = "net.sf.jasperreports.allow.element.negative.width";
    public static final String PROPERTY_ALLOW_ELEMENT_NEGATIVE_Y = "net.sf.jasperreports.allow.element.negative.y";
    private static Class<?>[] templateTypes = new Class[]{String.class, File.class, URL.class, InputStream.class, JRTemplate.class};
    private JasperReportsContext jasperReportsContext;
    private JasperDesign jasperDesign;
    private SectionTypeEnum sectionType;
    private Collection<JRValidationFault> brokenRules;
    private JRExpressionCollector expressionCollector;
    private LinkedList<JRComponentElement> currentComponentElementStack = new LinkedList();
    private boolean allowElementNegativeWidth;
    private final boolean allowElementNegativeY;

    protected JRVerifier(JasperDesign jasperDesign) {
        this(DefaultJasperReportsContext.getInstance(), jasperDesign, null);
    }

    protected JRVerifier(JasperDesign jasperDesign, JRExpressionCollector expressionCollector) {
        this(DefaultJasperReportsContext.getInstance(), jasperDesign, expressionCollector);
    }

    protected JRVerifier(JasperReportsContext jasperReportsContext, JasperDesign jasperDesign, JRExpressionCollector expressionCollector) {
        this.jasperReportsContext = jasperReportsContext;
        this.jasperDesign = jasperDesign;
        this.sectionType = jasperDesign.getSectionType() == null ? SectionTypeEnum.BAND : jasperDesign.getSectionType();
        this.brokenRules = new ArrayList<JRValidationFault>();
        this.expressionCollector = expressionCollector != null ? expressionCollector : JRExpressionCollector.collector(jasperReportsContext, jasperDesign);
        this.allowElementNegativeWidth = JRPropertiesUtil.getInstance(jasperReportsContext).getBooleanProperty(jasperDesign, PROPERTY_ALLOW_ELEMENT_NEGATIVE_WIDTH, false);
        this.allowElementNegativeY = JRPropertiesUtil.getInstance(jasperReportsContext).getBooleanProperty(jasperDesign, PROPERTY_ALLOW_ELEMENT_NEGATIVE_Y, true);
    }

    public JasperDesign getReportDesign() {
        return this.jasperDesign;
    }

    public void addBrokenRule(String message, Object source) {
        JRVerifier.addBrokenRule(this.brokenRules, message, source);
    }

    protected static void addBrokenRule(Collection<JRValidationFault> brokenRules, String message, Object source) {
        JRValidationFault fault = new JRValidationFault();
        fault.setMessage(message);
        fault.setSource(source);
        brokenRules.add(fault);
    }

    public void addBrokenRule(Exception e, Object source) {
        JRValidationFault fault = new JRValidationFault();
        fault.setMessage(e.getMessage());
        fault.setSource(source);
        this.brokenRules.add(fault);
    }

    public static Collection<JRValidationFault> verifyDesign(JasperDesign jasperDesign, JRExpressionCollector expressionCollector) {
        return JRVerifier.verifyDesign(DefaultJasperReportsContext.getInstance(), jasperDesign, expressionCollector);
    }

    public static Collection<JRValidationFault> verifyDesign(JasperReportsContext jasperReportsContext, JasperDesign jasperDesign, JRExpressionCollector expressionCollector) {
        JRVerifier verifier = new JRVerifier(jasperReportsContext, jasperDesign, expressionCollector);
        return verifier.verifyDesign();
    }

    public static Collection<JRValidationFault> verifyDesign(JasperDesign jasperDesign) {
        return JRVerifier.verifyDesign(jasperDesign, null);
    }

    protected Collection<JRValidationFault> verifyDesign() {
        this.jasperDesign.preprocess();
        this.verifyDesignAttributes();
        this.verifyReportTemplates();
        this.verifyDataset(this.jasperDesign.getMainDesignDataset());
        this.verifyDatasets();
        this.verifyStyles();
        if (this.toVerifyElementOverlap()) {
            this.verifyEmptyBackground();
        }
        this.verifyBand(this.jasperDesign.getBackground());
        this.verifyBand(this.jasperDesign.getTitle());
        this.verifyBand(this.jasperDesign.getPageHeader());
        this.verifyBand(this.jasperDesign.getColumnHeader());
        this.verifySection(this.jasperDesign.getDetailSection());
        this.verifyBand(this.jasperDesign.getColumnFooter());
        this.verifyBand(this.jasperDesign.getPageFooter());
        this.verifyBand(this.jasperDesign.getLastPageFooter());
        this.verifyBand(this.jasperDesign.getSummary());
        this.verifyBand(this.jasperDesign.getNoData());
        return this.brokenRules;
    }

    protected void verifyEmptyBackground() {
        JRElement[] elements;
        JRBand background = this.jasperDesign.getBackground();
        if (background != null && background.getHeight() > 0 && (elements = background.getElements()) != null && elements.length > 0) {
            boolean foundContent = false;
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i].getWidth() <= 0 || elements[i].getHeight() <= 0) continue;
                foundContent = true;
                break;
            }
            if (foundContent) {
                this.addBrokenRule("Use of the background section is not recommended for reports that are supposed to be exported using grid exporters such as HTML and XLS because the background content would likely be overlapped by other sections resulting in it not showing up.", (Object)background);
            }
        }
    }

    private void verifyDesignAttributes() {
        if (this.jasperDesign.getName() == null || this.jasperDesign.getName().trim().length() == 0) {
            this.addBrokenRule("Report name is missing.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getColumnCount() <= 0) {
            this.addBrokenRule("Column count must be greater than zero.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getPageWidth() < 0) {
            this.addBrokenRule("Page width must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getPageHeight() < 0) {
            this.addBrokenRule("Page height must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getColumnWidth() < 0) {
            this.addBrokenRule("Column width must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getColumnSpacing() < 0) {
            this.addBrokenRule("Column spacing must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getLeftMargin() < 0) {
            this.addBrokenRule("Left margin must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getRightMargin() < 0) {
            this.addBrokenRule("Right margin must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getTopMargin() < 0) {
            this.addBrokenRule("Top margin must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getBottomMargin() < 0) {
            this.addBrokenRule("Bottom margin must be positive.", (Object)this.jasperDesign);
        }
        if (this.jasperDesign.getLeftMargin() + this.jasperDesign.getColumnCount() * this.jasperDesign.getColumnWidth() + (this.jasperDesign.getColumnCount() - 1) * this.jasperDesign.getColumnSpacing() + this.jasperDesign.getRightMargin() > this.jasperDesign.getPageWidth()) {
            this.addBrokenRule("The columns and the margins do not fit the page width.", (Object)this.jasperDesign);
        }
        JRVerifier.verifyBandHeights(this.brokenRules, this.jasperDesign, this.jasperDesign.getPageHeight(), this.jasperDesign.getTopMargin(), this.jasperDesign.getBottomMargin());
        this.verifyFormatFactoryClass();
    }

    public static void verifyBandHeights(Collection<JRValidationFault> brokenRules, JRReport report, int pageHeight, int topMargin, int bottomMargin) {
        JRBand[] detailBands;
        JRSection detailSection;
        if (topMargin + (report.getBackground() != null ? report.getBackground().getHeight() : 0) + bottomMargin > pageHeight) {
            JRVerifier.addBrokenRule(brokenRules, "The background section and the margins do not fit the page height.", report);
        }
        if (report.isTitleNewPage()) {
            if (topMargin + JRVerifier.getBreakHeight(report.getTitle()) + bottomMargin > pageHeight) {
                JRVerifier.addBrokenRule(brokenRules, "The title section and the margins do not fit the page height.", report);
            }
        } else if (topMargin + JRVerifier.getBreakHeight(report.getTitle()) + (report.getPageHeader() != null ? report.getPageHeader().getHeight() : 0) + (report.getColumnHeader() != null ? report.getColumnHeader().getHeight() : 0) + (report.getColumnFooter() != null ? report.getColumnFooter().getHeight() : 0) + (report.getPageFooter() != null ? report.getPageFooter().getHeight() : 0) + bottomMargin > pageHeight) {
            JRVerifier.addBrokenRule(brokenRules, "The title section, the page and column headers and footers and the margins do not fit the page height.", report);
        }
        if (topMargin + (report.getPageHeader() != null ? report.getPageHeader().getHeight() : 0) + (report.getColumnHeader() != null ? report.getColumnHeader().getHeight() : 0) + (report.getColumnFooter() != null ? report.getColumnFooter().getHeight() : 0) + (report.getPageFooter() != null ? report.getPageFooter().getHeight() : 0) + bottomMargin > pageHeight) {
            JRVerifier.addBrokenRule(brokenRules, "The page and column headers and footers and the margins do not fit the page height.", report);
        }
        if (topMargin + (report.getPageHeader() != null ? report.getPageHeader().getHeight() : 0) + (report.getColumnHeader() != null ? report.getColumnHeader().getHeight() : 0) + (report.getColumnFooter() != null ? report.getColumnFooter().getHeight() : 0) + (report.getLastPageFooter() != null ? report.getLastPageFooter().getHeight() : 0) + bottomMargin > pageHeight) {
            JRVerifier.addBrokenRule(brokenRules, "The page and column headers and footers and the margins do not fit the last page height.", report);
        }
        if (topMargin + JRVerifier.getBreakHeight(report.getSummary()) + bottomMargin > pageHeight) {
            JRVerifier.addBrokenRule(brokenRules, "The summary section and the margins do not fit the page height.", report);
        }
        if ((detailSection = report.getDetailSection()) != null && (detailBands = detailSection.getBands()) != null && detailBands.length > 0) {
            for (int i = 0; i < detailBands.length; ++i) {
                JRBand detailBand = detailBands[i];
                if (topMargin + (report.getPageHeader() != null ? report.getPageHeader().getHeight() : 0) + (report.getColumnHeader() != null ? report.getColumnHeader().getHeight() : 0) + JRVerifier.getBreakHeight(detailBand) + (report.getColumnFooter() != null ? report.getColumnFooter().getHeight() : 0) + (report.getPageFooter() != null ? report.getPageFooter().getHeight() : 0) + bottomMargin <= pageHeight) continue;
                JRVerifier.addBrokenRule(brokenRules, "The detail section, the page and column headers and footers and the margins do not fit the page height.", report);
            }
        }
        if (topMargin + JRVerifier.getBreakHeight(report.getNoData()) + bottomMargin > pageHeight) {
            JRVerifier.addBrokenRule(brokenRules, "The noData section and the margins do not fit the page height.", report);
        }
    }

    protected void verifyFormatFactoryClass() {
        String formatFactoryClassName = this.jasperDesign.getFormatFactoryClass();
        if (formatFactoryClassName != null) {
            try {
                Class<?> formatFactoryClass = JRClassLoader.loadClassForName(formatFactoryClassName);
                if (!FormatFactory.class.isAssignableFrom(formatFactoryClass)) {
                    this.addBrokenRule("The report format factory class is not compatible with " + FormatFactory.class.getName(), (Object)this.jasperDesign);
                }
            }
            catch (ClassNotFoundException e) {
                this.addBrokenRule(e.toString(), (Object)this.jasperDesign);
            }
        }
    }

    private void verifyQuery(JRDesignDataset dataset) {
        JRQuery query = dataset.getQuery();
        if (query != null) {
            String language = query.getLanguage();
            QueryExecuterFactory queryExecuterFactory = null;
            if (language == null || language.length() == 0) {
                this.addBrokenRule("Query language not set.", (Object)query);
            } else {
                try {
                    queryExecuterFactory = JRQueryExecuterUtils.getInstance(this.jasperReportsContext).getExecuterFactory(query.getLanguage());
                }
                catch (JRException e1) {
                    this.addBrokenRule("Query executer factory for " + language + " cannot be created.", (Object)query);
                }
            }
            JRQueryChunk[] chunks = query.getChunks();
            if (chunks != null && chunks.length > 0) {
                Map<String, JRParameter> parametersMap = dataset.getParametersMap();
                block8: for (int j = 0; j < chunks.length; ++j) {
                    JRQueryChunk queryChunk = chunks[j];
                    switch (queryChunk.getType()) {
                        case 2: {
                            JRParameter parameter = parametersMap.get(queryChunk.getText());
                            if (parameter == null) {
                                this.addBrokenRule("Query parameter not found : " + queryChunk.getText(), (Object)query);
                                continue block8;
                            }
                            if (queryExecuterFactory == null) continue block8;
                            String parameterType = null;
                            try {
                                parameterType = parameter.getValueClassName();
                            }
                            catch (JRRuntimeException e) {
                                // empty catch block
                            }
                            if (parameterType == null || queryExecuterFactory.supportsQueryParameterType(parameterType)) continue block8;
                            this.addBrokenRule("Parameter type not supported in query : " + queryChunk.getText() + " class " + parameterType, (Object)query);
                            continue block8;
                        }
                        case 3: {
                            if (parametersMap.containsKey(queryChunk.getText())) continue block8;
                            this.addBrokenRule("Query parameter not found : " + queryChunk.getText(), (Object)query);
                            continue block8;
                        }
                    }
                }
            }
        }
    }

    private void verifyExpressions(List<JRExpression> expressions, Map<String, ? extends JRParameter> parametersMap, Map<String, JRField> fieldsMap, Map<String, JRVariable> variablesMap) {
        if (expressions != null && expressions.size() > 0) {
            for (JRExpression expression : expressions) {
                JRExpressionChunk[] chunks = expression.getChunks();
                if (chunks == null || chunks.length <= 0) continue;
                block6: for (int j = 0; j < chunks.length; ++j) {
                    JRExpressionChunk expressionChunk = chunks[j];
                    switch (expressionChunk.getType()) {
                        case 4: {
                            if (variablesMap.containsKey(expressionChunk.getText())) continue block6;
                            this.addBrokenRule("Variable not found : " + expressionChunk.getText(), (Object)expression);
                            continue block6;
                        }
                        case 3: {
                            if (fieldsMap.containsKey(expressionChunk.getText())) continue block6;
                            this.addBrokenRule("Field not found : " + expressionChunk.getText(), (Object)expression);
                            continue block6;
                        }
                        case 2: {
                            if (parametersMap.containsKey(expressionChunk.getText())) continue block6;
                            this.addBrokenRule("Parameter not found : " + expressionChunk.getText(), (Object)expression);
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    private void verifyExpressions(JRDesignDataset dataset) {
        this.verifyExpressions(this.expressionCollector.getExpressions(dataset), dataset.getParametersMap(), dataset.getFieldsMap(), dataset.getVariablesMap());
    }

    protected void verifyReportTemplates() {
        JRReportTemplate[] templates = this.jasperDesign.getTemplates();
        if (templates != null) {
            for (int i = 0; i < templates.length; ++i) {
                JRReportTemplate template = templates[i];
                this.verifyTemplate(template);
            }
        }
    }

    protected void verifyTemplate(JRReportTemplate template) {
        JRExpression sourceExpression = template.getSourceExpression();
        if (sourceExpression == null) {
            this.addBrokenRule("Template source expression missing.", (Object)template);
        }
    }

    protected boolean verifyTemplateSourceType(Class<?> valueClass) {
        boolean valid = false;
        for (int i = 0; i < templateTypes.length; ++i) {
            Class<?> type = templateTypes[i];
            if (!type.isAssignableFrom(valueClass)) continue;
            valid = true;
            break;
        }
        return valid;
    }

    private void verifyStyles() {
        JRStyle[] styles = this.jasperDesign.getStyles();
        if (styles != null && styles.length > 0) {
            for (int index = 0; index < styles.length; ++index) {
                JRStyle style = styles[index];
                if (style.getName() == null || style.getName().trim().length() == 0) {
                    this.addBrokenRule("Report style name missing.", (Object)style);
                }
                this.verifyConditionalStyles(style);
            }
        }
    }

    private void verifyConditionalStyles(JRStyle style) {
        JRConditionalStyle[] condStyles = style.getConditionalStyles();
        if (condStyles != null && condStyles.length > 0) {
            for (int index = 0; index < condStyles.length; ++index) {
                JRConditionalStyle condStyle = condStyles[index];
                if (!log.isWarnEnabled()) continue;
                if (condStyle.getName() != null) {
                    log.warn((Object)"Conditional style should not have a name.");
                }
                if (!condStyle.isDefault()) continue;
                log.warn((Object)"Conditional style can't be the default style.");
            }
        }
    }

    private void verifyParameters(JRDesignDataset dataset) {
        JRParameter[] parameters = dataset.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int index = 0; index < parameters.length; ++index) {
                JRParameter parameter;
                JRPropertiesHolder errorSource = parameter = parameters[index];
                if (parameter.isSystemDefined()) {
                    errorSource = this.jasperDesign;
                }
                if (parameter.getName() == null || parameter.getName().trim().length() == 0) {
                    this.addBrokenRule("Parameter name missing.", (Object)errorSource);
                }
                if (parameter.getValueClassName() != null) continue;
                this.addBrokenRule("Class not set for parameter : " + parameter.getName(), (Object)errorSource);
            }
        }
    }

    private void verifyFields(JRDesignDataset dataset) {
        JRField[] fields = dataset.getFields();
        if (fields != null && fields.length > 0) {
            for (int index = 0; index < fields.length; ++index) {
                JRField field = fields[index];
                if (field.getName() == null || field.getName().trim().length() == 0) {
                    this.addBrokenRule("Field name missing.", (Object)field);
                }
                try {
                    Class<?> fieldType = field.getValueClass();
                    if (fieldType != null) continue;
                    this.addBrokenRule("Class not set for field : " + field.getName(), (Object)field);
                    continue;
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)field);
                }
            }
        }
    }

    private void verifySortFields(JRDesignDataset dataset) {
        JRField[] fields = dataset.getFields();
        JRVariable[] variables = dataset.getVariables();
        JRSortField[] sortFields = dataset.getSortFields();
        if (sortFields != null && sortFields.length > 0) {
            for (int index = 0; index < sortFields.length; ++index) {
                int j;
                JRSortField sortField = sortFields[index];
                String sortFieldName = sortField.getName();
                if (sortFieldName == null || sortFieldName.trim().length() == 0) {
                    this.addBrokenRule("Sort field name missing.", (Object)sortField);
                    continue;
                }
                boolean isFound = false;
                if (sortField.getType() == SortFieldTypeEnum.VARIABLE) {
                    if (variables != null) {
                        for (j = 0; !isFound && j < variables.length; ++j) {
                            isFound = sortFieldName.equals(variables[j].getName());
                        }
                    }
                } else if (fields != null) {
                    for (j = 0; !isFound && j < fields.length; ++j) {
                        isFound = sortFieldName.equals(fields[j].getName());
                    }
                }
                if (isFound) continue;
                this.addBrokenRule("Sort " + sortField.getType().getName().toLowerCase() + " '" + sortFieldName + "' not found in dataset.", (Object)sortField);
            }
        }
    }

    private void verifyVariables(JRDesignDataset dataset) throws JRRuntimeException {
        JRVariable[] variables = dataset.getVariables();
        if (variables != null && variables.length > 0) {
            boolean isMainDataset = dataset.isMainDataset();
            for (int index = 0; index < variables.length; ++index) {
                IncrementTypeEnum incrementType;
                JRVariable variable = variables[index];
                if (variable.getName() == null || variable.getName().trim().length() == 0) {
                    this.addBrokenRule("Variable name missing.", (Object)variable);
                }
                try {
                    Class<?> valueClass = variable.getValueClass();
                    if (valueClass == null) {
                        this.addBrokenRule("Class not set for variable : " + variable.getName(), (Object)variable);
                    }
                }
                catch (JRRuntimeException e) {
                    this.addBrokenRule(e, (Object)variable);
                }
                ResetTypeEnum resetType = variable.getResetTypeValue();
                if (resetType == ResetTypeEnum.GROUP) {
                    if (variable.getResetGroup() == null) {
                        this.addBrokenRule("Reset group missing for variable : " + variable.getName(), (Object)variable);
                    } else {
                        Map<String, JRGroup> groupsMap = dataset.getGroupsMap();
                        if (!groupsMap.containsKey(variable.getResetGroup().getName())) {
                            this.addBrokenRule("Reset group \"" + variable.getResetGroup().getName() + "\" not found for variable : " + variable.getName(), (Object)variable);
                        }
                    }
                }
                if ((incrementType = variable.getIncrementTypeValue()) == IncrementTypeEnum.GROUP) {
                    if (variable.getIncrementGroup() == null) {
                        this.addBrokenRule("Increment group missing for variable : " + variable.getName(), (Object)variable);
                    } else {
                        Map<String, JRGroup> groupsMap = dataset.getGroupsMap();
                        if (!groupsMap.containsKey(variable.getIncrementGroup().getName())) {
                            this.addBrokenRule("Increment group \"" + variable.getIncrementGroup().getName() + "\" not found for variable : " + variable.getName(), (Object)variable);
                        }
                    }
                }
                if (isMainDataset || variable.isSystemDefined()) continue;
                if (resetType == ResetTypeEnum.COLUMN || resetType == ResetTypeEnum.PAGE) {
                    this.addBrokenRule("Variable " + variable.getName() + " of dataset " + dataset.getName() + " cannot have Column or Page reset type.", (Object)variable);
                }
                if (incrementType != IncrementTypeEnum.COLUMN && incrementType != IncrementTypeEnum.PAGE) continue;
                this.addBrokenRule("Variable " + variable.getName() + " of dataset " + dataset.getName() + " cannot have Column or Page increment type.", (Object)variable);
            }
        }
    }

    private void verifyGroups(JRDesignDataset dataset) {
        JRGroup[] groups = dataset.getGroups();
        if (groups != null && groups.length > 0) {
            boolean isMainDataset = dataset.isMainDataset();
            for (int index = 0; index < groups.length; ++index) {
                JRGroup group = groups[index];
                if (group.getName() == null || group.getName().trim().length() == 0) {
                    this.addBrokenRule("Group name missing.", (Object)group);
                }
                if (isMainDataset) {
                    this.verifyGroupHeaderAndFooter(group);
                } else if (group.getGroupHeaderSection() != null && group.getGroupHeaderSection().getBands() != null && group.getGroupHeaderSection().getBands().length > 0 || group.getGroupFooterSection() != null && group.getGroupFooterSection().getBands() != null && group.getGroupFooterSection().getBands().length > 0) {
                    this.addBrokenRule("Group " + group.getName() + " cannot have header or footer sections.", (Object)group);
                }
                if (!isMainDataset) continue;
                this.verifySection(group.getGroupHeaderSection());
                this.verifySection(group.getGroupFooterSection());
            }
        }
    }

    private void verifyGroupHeaderAndFooter(JRGroup group) {
        block8: {
            JRBand[] groupFooterBands;
            JRSection groupFooterSection;
            JRBand[] groupHeaderBands;
            block7: {
                JRBand[] groupFooterBands2;
                JRSection groupFooterSection2;
                JRBand[] groupHeaderBands2;
                if (!this.jasperDesign.isTitleNewPage()) break block7;
                JRSection groupHeaderSection = group.getGroupHeaderSection();
                if (groupHeaderSection != null && (groupHeaderBands2 = groupHeaderSection.getBands()) != null && groupHeaderBands2.length > 0) {
                    for (int i = 0; i < groupHeaderBands2.length; ++i) {
                        JRBand groupHeaderBand = groupHeaderBands2[i];
                        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + JRVerifier.getBreakHeight(groupHeaderBand) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() <= this.jasperDesign.getPageHeight()) continue;
                        this.addBrokenRule("The '" + group.getName() + "' group header section, the page and column headers and footers and the margins do not fit the page height.", (Object)groupHeaderBand);
                    }
                }
                if ((groupFooterSection2 = group.getGroupFooterSection()) == null || (groupFooterBands2 = groupFooterSection2.getBands()) == null || groupFooterBands2.length <= 0) break block8;
                for (int i = 0; i < groupFooterBands2.length; ++i) {
                    JRBand groupFooterBand = groupFooterBands2[i];
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + JRVerifier.getBreakHeight(groupFooterBand) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() <= this.jasperDesign.getPageHeight()) continue;
                    this.addBrokenRule("The '" + group.getName() + "' group footer section, the page and column headers and footers and the margins do not fit the page height.", (Object)groupFooterBand);
                }
                break block8;
            }
            JRSection groupHeaderSection = group.getGroupHeaderSection();
            if (groupHeaderSection != null && (groupHeaderBands = groupHeaderSection.getBands()) != null && groupHeaderBands.length > 0) {
                for (int i = 0; i < groupHeaderBands.length; ++i) {
                    JRBand groupHeaderBand = groupHeaderBands[i];
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + JRVerifier.getBreakHeight(groupHeaderBand) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() <= this.jasperDesign.getPageHeight()) continue;
                    this.addBrokenRule("The '" + group.getName() + "' group header section, the title, the page and column headers and footers and the margins do not fit the first page height.", (Object)groupHeaderBand);
                }
            }
            if ((groupFooterSection = group.getGroupFooterSection()) != null && (groupFooterBands = groupFooterSection.getBands()) != null && groupFooterBands.length > 0) {
                for (int i = 0; i < groupFooterBands.length; ++i) {
                    JRBand groupFooterBand = groupFooterBands[i];
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + JRVerifier.getBreakHeight(groupFooterBand) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() <= this.jasperDesign.getPageHeight()) continue;
                    this.addBrokenRule("The '" + group.getName() + "' group footer section, the title, the page and column headers and footers and the margins do not fit the first page height.", (Object)groupFooterBand);
                }
            }
        }
    }

    protected boolean toVerifyElementOverlap() {
        return !JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(this.jasperDesign, PROPERTY_ALLOW_ELEMENT_OVERLAP, true);
    }

    protected boolean isAllowedToOverlap(JRElement element) {
        return element.hasProperties() && JRPropertiesUtil.asBoolean(element.getPropertiesMap().getProperty(PROPERTY_ALLOW_ELEMENT_OVERLAP));
    }

    protected void verifyElementOverlap(JRElement element1, JRElement element2) {
        if (element1.getWidth() <= 0 || element1.getHeight() <= 0 || element2.getWidth() <= 0 || element2.getHeight() <= 0) {
            return;
        }
        if (element1.getX() < element2.getX() + element2.getWidth() && element2.getX() < element1.getX() + element1.getWidth() && element1.getY() < element2.getY() + element2.getHeight() && element2.getY() < element1.getY() + element1.getHeight()) {
            StringBuffer message = new StringBuffer();
            message.append("Element ");
            if (element2.getKey() != null) {
                message.append("\"");
                message.append(element2.getKey());
                message.append("\" ");
            }
            message.append("at ");
            message.append(this.getElementPositionText(element2));
            message.append(" overlaps element ");
            if (element1.getKey() != null) {
                message.append("\"");
                message.append(element1.getKey());
                message.append("\" ");
            }
            message.append("at ");
            message.append(this.getElementPositionText(element1));
            this.addBrokenRule(message.toString(), (Object)element2);
        }
    }

    protected String getElementPositionText(JRElement element) {
        return "[x = " + element.getX() + ", y = " + element.getY() + ", width = " + element.getWidth() + ", height = " + element.getHeight() + "]";
    }

    protected void verifyElementsOverlap(JRElement[] elements) {
        if (!this.toVerifyElementOverlap()) {
            return;
        }
        for (int index = 1; index < elements.length; ++index) {
            JRElement element = elements[index];
            if (this.isAllowedToOverlap(element)) continue;
            for (int overlapIndex = 0; overlapIndex < index; ++overlapIndex) {
                if (this.isAllowedToOverlap(elements[overlapIndex])) continue;
                this.verifyElementOverlap(elements[overlapIndex], element);
            }
        }
    }

    private void verifySection(JRSection section) {
        if (section != null) {
            JRPart[] parts;
            JRBand[] bands = section.getBands();
            if (bands != null && bands.length > 0) {
                if (this.sectionType == SectionTypeEnum.PART) {
                    this.addBrokenRule("Part reports cannot contain bands", (Object)section);
                } else {
                    for (int i = 0; i < bands.length; ++i) {
                        this.verifyBand(bands[i]);
                    }
                }
            }
            if ((parts = section.getParts()) != null && parts.length > 0) {
                if (this.sectionType == SectionTypeEnum.BAND) {
                    this.addBrokenRule("Band reports cannot contain parts", (Object)section);
                } else {
                    for (int i = 0; i < parts.length; ++i) {
                        this.verifyPart(parts[i]);
                    }
                }
            }
        }
    }

    private void verifyBand(JRBand band) {
        if (band != null) {
            if (this.sectionType == SectionTypeEnum.PART) {
                this.addBrokenRule("Part reports cannot contain bands", (Object)band);
                return;
            }
            JRElement[] elements = band.getElements();
            if (elements != null && elements.length > 0) {
                for (int index = 0; index < elements.length; ++index) {
                    JRElement element = elements[index];
                    if (element.getY() + element.getHeight() > band.getHeight()) {
                        this.addBrokenRule("Warning : Element bottom reaches outside band area : y=" + element.getY() + " height=" + element.getHeight() + " band-height=" + band.getHeight(), (Object)element);
                    }
                    this.verifyElement(element);
                }
                this.verifyElementsOverlap(elements);
            }
        }
    }

    public void verifyElement(JRElement element) {
        if (element instanceof JRStaticText) {
            this.verifyStaticText((JRStaticText)element);
        } else if (element instanceof JRTextField) {
            this.verifyTextField((JRTextField)element);
        } else if (element instanceof JRImage) {
            this.verifyImage((JRImage)element);
        } else if (element instanceof JRSubreport) {
            this.verifySubreport((JRSubreport)element);
        } else if (element instanceof JRCrosstab) {
            this.verifyCrosstab((JRDesignCrosstab)element);
        } else if (element instanceof JRChart) {
            this.verifyChart((JRChart)element);
        } else if (element instanceof JRFrame) {
            this.verifyFrame((JRFrame)element);
        } else if (element instanceof JRComponentElement) {
            this.verifyComponentElement((JRComponentElement)element);
        } else if (element instanceof JRGenericElement) {
            this.verifyGenericElement((JRGenericElement)element);
        }
    }

    private void verifyStaticText(JRStaticText staticText) {
        this.verifyReportElement(staticText);
    }

    private void verifyTextField(JRTextField textField) {
        this.verifyReportElement(textField);
        this.verifyAnchor(textField);
        this.verifyHyperlink(textField);
    }

    private void verifyAnchor(JRAnchor anchor) {
        if (anchor != null && anchor.getBookmarkLevel() != 0 && anchor.getBookmarkLevel() < 1) {
            this.addBrokenRule("Bookmark level should be 0 or greater than 0", (Object)anchor);
        }
    }

    public void verifyHyperlink(JRHyperlink hyperlink) {
        JRHyperlinkParameter[] parameters;
        if (hyperlink != null && (parameters = hyperlink.getHyperlinkParameters()) != null) {
            for (int i = 0; i < parameters.length; ++i) {
                JRHyperlinkParameter parameter = parameters[i];
                this.verifyHyperlinkParameter(parameter);
            }
        }
    }

    protected void verifyHyperlinkParameter(JRHyperlinkParameter parameter) {
        String name;
        if (parameter != null && ((name = parameter.getName()) == null || name.length() == 0)) {
            this.addBrokenRule("Hyperlink parameter name missing.", (Object)parameter);
        }
    }

    private void verifyImage(JRImage image) {
        this.verifyReportElement(image);
        this.verifyAnchor(image);
        this.verifyHyperlink(image);
    }

    private void verifySubreport(JRSubreport subreport) {
        if (subreport != null) {
            JRSubreportReturnValue[] returnValues;
            this.verifyReportElement(subreport);
            JRSubreportParameter[] parameters = subreport.getParameters();
            if (parameters != null && parameters.length > 0) {
                for (int index = 0; index < parameters.length; ++index) {
                    JRSubreportParameter parameter = parameters[index];
                    if (parameter.getName() != null && parameter.getName().trim().length() != 0) continue;
                    this.addBrokenRule("Subreport parameter name missing.", (Object)parameter);
                }
            }
            if (subreport.getConnectionExpression() != null && subreport.getDataSourceExpression() != null) {
                this.addBrokenRule("Subreport cannot have both connection expresion and data source expression.", (Object)subreport);
            }
            if ((returnValues = subreport.getReturnValues()) != null && returnValues.length > 0) {
                for (int i = 0; i < returnValues.length; ++i) {
                    JRSubreportReturnValue returnValue = returnValues[i];
                    if (returnValue.getSubreportVariable() == null || returnValue.getSubreportVariable().trim().length() == 0) {
                        this.addBrokenRule("Subreport return value variable name missing.", (Object)returnValue);
                    }
                    if (returnValue.getToVariable() == null || returnValue.getToVariable().trim().length() == 0) {
                        this.addBrokenRule("Subreport return value to variable name missing.", (Object)returnValue);
                    }
                    if (this.jasperDesign.getVariablesMap().containsKey(returnValue.getToVariable())) continue;
                    this.addBrokenRule("Subreport return value to variable not found.", (Object)returnValue);
                }
            }
        }
    }

    protected void verifyReturnValue(ReturnValue returnValue) {
        if (returnValue.getFromVariable() == null || returnValue.getFromVariable().trim().length() == 0) {
            this.addBrokenRule("Return value source variable name missing.", (Object)returnValue);
        }
        if (returnValue.getToVariable() == null || returnValue.getToVariable().trim().length() == 0) {
            this.addBrokenRule("Return value destination variable name missing.", (Object)returnValue);
        }
        if (!this.jasperDesign.getVariablesMap().containsKey(returnValue.getToVariable())) {
            this.addBrokenRule("Return value destination variable not found.", (Object)returnValue);
        }
    }

    private void verifyCrosstab(JRDesignCrosstab crosstab) {
        this.verifyReportElement(crosstab);
        this.verifyParameters(crosstab);
        JRCrosstabDataset dataset = crosstab.getDataset();
        if (dataset == null) {
            this.addBrokenRule("Crosstab dataset missing.", (Object)crosstab);
        } else {
            this.verifyElementDataset(dataset);
        }
        if (crosstab.getTitleCell() != null) {
            this.verifyCellContents(crosstab.getTitleCell().getCellContents(), "crosstab title cell");
        }
        this.verifyCellContents(crosstab.getHeaderCell(), "crosstab cell");
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        if (rowGroups == null || rowGroups.length == 0) {
            this.addBrokenRule("Crosstab should have at least one row group.", (Object)crosstab);
        } else {
            for (int i = 0; i < rowGroups.length; ++i) {
                this.verifyCrosstabRowGroup(rowGroups[i]);
            }
        }
        JRCrosstabColumnGroup[] colGroups = crosstab.getColumnGroups();
        if (colGroups == null || colGroups.length == 0) {
            this.addBrokenRule("Crosstab should have at least one column group.", (Object)crosstab);
        } else {
            for (int i = 0; i < colGroups.length; ++i) {
                this.verifyCrosstabColumnGroup(colGroups[i]);
            }
        }
        JRCrosstabMeasure[] measures = crosstab.getMeasures();
        if (measures == null || measures.length == 0) {
            this.addBrokenRule("Crosstab should have at least one measure.", (Object)crosstab);
        } else {
            for (int i = 0; i < measures.length; ++i) {
                this.verifyCrosstabMeasure(measures[i]);
            }
        }
        this.verifyCrosstabCells(crosstab);
        this.verifyCellContents(crosstab.getWhenNoDataCell(), "when no data cell");
        this.verifyExpressions(crosstab);
    }

    private void verifyParameters(JRDesignCrosstab crosstab) {
        JRCrosstabParameter[] parameters = crosstab.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                JRCrosstabParameter parameter = parameters[i];
                String paramName = parameter.getName();
                if (paramName == null || paramName.length() == 0) {
                    this.addBrokenRule("Missing parameter name for crosstab.", (Object)parameter);
                }
                try {
                    Class<?> valueClass = parameter.getValueClass();
                    if (valueClass != null) continue;
                    this.addBrokenRule("Class not set for crosstab parameter " + paramName + ".", (Object)parameter);
                    continue;
                }
                catch (Exception e) {
                    this.addBrokenRule(e, (Object)parameter);
                }
            }
        }
    }

    private void verifyCrosstabRowGroup(JRCrosstabRowGroup group) {
        this.verifyCrosstabGroup(group);
    }

    private void verifyCrosstabColumnGroup(JRCrosstabColumnGroup group) {
        this.verifyCrosstabGroup(group);
        this.verifyCellContents(group.getCrosstabHeader(), group.getName() + " crosstab header");
    }

    private void verifyCrosstabGroup(JRCrosstabGroup group) {
        String groupName = group.getName();
        if (groupName == null || groupName.length() == 0) {
            this.addBrokenRule("Crosstab group name missing.", (Object)group);
        }
        this.verifyCrosstabBucket(group);
        this.verifyCellContents(group.getHeader(), groupName + " header");
        if (group.hasTotal()) {
            this.verifyCellContents(group.getTotalHeader(), groupName + " total header");
        }
    }

    private void verifyCrosstabBucket(JRCrosstabGroup group) {
        JRCrosstabBucket bucket = group.getBucket();
        try {
            Class<?> valueClass = bucket.getValueClass();
            if (valueClass == null) {
                this.addBrokenRule("Class not set for bucket : " + group.getName(), (Object)bucket);
            }
        }
        catch (JRRuntimeException e) {
            this.addBrokenRule(e, (Object)bucket);
        }
        JRExpression expression = bucket.getExpression();
        if (expression == null) {
            this.addBrokenRule("Crosstab bucket expression missing for group " + group.getName() + ".", (Object)bucket);
        }
    }

    private void verifyCrosstabCells(JRDesignCrosstab crosstab) {
        JRCrosstabColumnGroup[] columnGroups;
        JRCrosstabRowGroup[] rowGroups;
        JRCrosstabCell[][] cells = crosstab.getCells();
        JRCrosstabCell baseCell = cells[(rowGroups = crosstab.getRowGroups()).length][(columnGroups = crosstab.getColumnGroups()).length];
        if (baseCell == null || baseCell.getWidth() == null) {
            this.addBrokenRule("Crosstab base cell width not specified.", (Object)crosstab);
        }
        if (baseCell == null || baseCell.getHeight() == null) {
            this.addBrokenRule("Crosstab base cell height not specified.", (Object)crosstab);
        }
        for (int i = rowGroups.length; i >= 0; --i) {
            for (int j = columnGroups.length; j >= 0; --j) {
                JRCrosstabCell rowCell;
                JRCrosstabCell colCell;
                JRCrosstabCell cell = cells[i][j];
                String cellText = this.getCrosstabCellText(rowGroups, columnGroups, i, j);
                if (cell == null) continue;
                JRCellContents contents = cell.getContents();
                if (i < rowGroups.length && (colCell = cells[rowGroups.length][j]) != null && colCell.getContents().getWidth() != contents.getWidth()) {
                    this.addBrokenRule("Crosstab " + cellText + " width should be " + colCell.getContents().getWidth() + ".", (Object)cell);
                }
                if (j < columnGroups.length && (rowCell = cells[i][columnGroups.length]) != null && rowCell.getContents().getHeight() != contents.getHeight()) {
                    this.addBrokenRule("Crosstab " + cellText + " height should be " + rowCell.getContents().getHeight() + ".", (Object)cell);
                }
                this.verifyCellContents(contents, cellText);
            }
        }
    }

    private String getCrosstabCellText(JRCrosstabRowGroup[] rowGroups, JRCrosstabColumnGroup[] columnGroups, int rowIndex, int columnIndex) {
        String text = rowIndex == rowGroups.length ? (columnIndex == columnGroups.length ? "cell" : columnGroups[columnIndex].getName() + " total cell") : (columnIndex == columnGroups.length ? rowGroups[rowIndex].getName() + " total cell" : rowGroups[rowIndex].getName() + "," + columnGroups[columnIndex].getName() + " total cell");
        return text;
    }

    private void verifyCrosstabMeasure(JRCrosstabMeasure measure) {
        JRExpression valueExpression;
        CalculationEnum calculation;
        String measureName = measure.getName();
        if (measureName == null || measureName.trim().length() == 0) {
            this.addBrokenRule("Measure name missing.", (Object)measure);
        }
        if ((calculation = measure.getCalculationValue()) == CalculationEnum.SYSTEM) {
            this.addBrokenRule("Crosstab mesures cannot have system calculation", (Object)measure);
        }
        if ((valueExpression = measure.getValueExpression()) == null) {
            this.addBrokenRule("Missing expression for measure " + measureName, (Object)measure);
        }
        try {
            Class<?> valueClass = measure.getValueClass();
            if (valueClass == null) {
                this.addBrokenRule("Measure value class missing.", (Object)measure);
            }
            if (measure.getPercentageType() != CrosstabPercentageEnum.NONE) {
                Class<?> percentageCalculatorClass = measure.getPercentageCalculatorClass();
                if (percentageCalculatorClass == null) {
                    if (valueClass != null && !JRPercentageCalculatorFactory.hasBuiltInCalculator(valueClass)) {
                        this.addBrokenRule("Percentage calculator class needs to be specified for measure " + measureName + ".", (Object)measure);
                    }
                } else if (!JRPercentageCalculator.class.isAssignableFrom(percentageCalculatorClass)) {
                    this.addBrokenRule("Incompatible percentage calculator class for measure " + measureName + ".", (Object)measure);
                }
            }
        }
        catch (JRRuntimeException e) {
            this.addBrokenRule(e, (Object)measure);
        }
        try {
            Class<?> incrementerFactoryClass = measure.getIncrementerFactoryClass();
            if (incrementerFactoryClass != null && !JRExtendedIncrementerFactory.class.isAssignableFrom(incrementerFactoryClass)) {
                this.addBrokenRule("Crosstab measures need extended incrementers (net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory).", (Object)measure);
            }
        }
        catch (JRRuntimeException e) {
            this.addBrokenRule(e, (Object)measure);
        }
    }

    private void verifyExpressions(JRDesignCrosstab crosstab) {
        this.verifyExpressions(this.expressionCollector.getExpressions(crosstab), crosstab.getParametersMap(), new HashMap<String, JRField>(), crosstab.getVariablesMap());
    }

    private void verifyChart(JRChart chart) {
        JRChartDataset dataset;
        this.verifyReportElement(chart);
        if (chart.getEvaluationTimeValue() == EvaluationTimeEnum.AUTO) {
            this.addBrokenRule("Charts do not support Auto evaluation time.", (Object)chart);
        }
        if ((dataset = chart.getDataset()) == null) {
            this.addBrokenRule("Chart dataset missing.", (Object)chart);
        } else {
            dataset.validate(this);
        }
    }

    private void verifyCellContents(JRCellContents contents, String cellText) {
        JRElement[] elements;
        if (contents != null && (elements = contents.getElements()) != null && elements.length > 0) {
            int cellWidth;
            int topPadding = 0;
            int leftPadding = 0;
            int bottomPadding = 0;
            int rightPadding = 0;
            JRLineBox box = contents.getLineBox();
            if (box != null) {
                topPadding = box.getTopPadding();
                leftPadding = box.getLeftPadding();
                bottomPadding = box.getBottomPadding();
                rightPadding = box.getRightPadding();
            }
            boolean widthCalculated = (cellWidth = contents.getWidth()) != Integer.MIN_VALUE;
            int avlblWidth = cellWidth - leftPadding - rightPadding;
            int cellHeight = contents.getHeight();
            boolean heightCalculated = cellHeight != Integer.MIN_VALUE;
            int avlblHeight = cellHeight - topPadding - bottomPadding;
            for (int i = 0; i < elements.length; ++i) {
                JRElement element = elements[i];
                if (widthCalculated && element.getX() + element.getWidth() > avlblWidth) {
                    this.addBrokenRule("Element reaches outside " + cellText + " width: x=" + element.getX() + ", width=" + element.getWidth() + ", available width=" + avlblWidth + ".", (Object)element);
                }
                if (heightCalculated && element.getY() + element.getHeight() > avlblHeight) {
                    this.addBrokenRule("Element reaches outside " + cellText + " height: y=" + element.getY() + ", height=" + element.getHeight() + ", available height=" + avlblHeight + ".", (Object)element);
                }
                if (element instanceof JRStaticText) {
                    this.verifyStaticText((JRStaticText)element);
                    continue;
                }
                if (element instanceof JRTextField) {
                    JRTextField textField = (JRTextField)element;
                    if (textField.getEvaluationTimeValue() != EvaluationTimeEnum.NOW) {
                        this.addBrokenRule("Elements with delayed evaluation time are not supported inside crosstab cells.", (Object)textField);
                    }
                    this.verifyTextField(textField);
                    continue;
                }
                if (element instanceof JRImage) {
                    JRImage image = (JRImage)element;
                    if (image.getEvaluationTimeValue() != EvaluationTimeEnum.NOW) {
                        this.addBrokenRule("Elements with delayed evaluation time are not supported inside crosstab cells.", (Object)image);
                    }
                    this.verifyImage(image);
                    continue;
                }
                if (element instanceof JRFrame) {
                    this.verifyFrame((JRFrame)element);
                    continue;
                }
                if (element instanceof JRSubreport) {
                    this.verifySubreport((JRSubreport)element);
                    continue;
                }
                if (element instanceof JRCrosstab) {
                    this.addBrokenRule("Crosstabs are not allowed inside crosstab cells.", (Object)element);
                    continue;
                }
                if (!(element instanceof JRChart)) continue;
                this.addBrokenRule("Charts are not allowed inside crosstab cells.", (Object)element);
            }
            this.verifyElementsOverlap(elements);
        }
    }

    public void verifyElementDataset(JRElementDataset dataset) {
        JRDatasetRun datasetRun = dataset.getDatasetRun();
        if (datasetRun != null) {
            ResetTypeEnum resetType;
            IncrementTypeEnum incrementType = dataset.getIncrementTypeValue();
            if (incrementType == IncrementTypeEnum.PAGE || incrementType == IncrementTypeEnum.COLUMN) {
                this.addBrokenRule("Chart datasets with dataset run cannont have Column or Page increment type.", (Object)dataset);
            }
            if ((resetType = dataset.getResetTypeValue()) == ResetTypeEnum.PAGE || resetType == ResetTypeEnum.COLUMN) {
                this.addBrokenRule("Chart datasets with dataset run cannont have Column or Page reset type.", (Object)dataset);
            }
            this.verifyDatasetRun(datasetRun);
        }
    }

    public void verifyDatasetRun(JRDatasetRun datasetRun) {
        List<ReturnValue> returnValues;
        JRDesignDataset dataset = null;
        String datasetName = datasetRun.getDatasetName();
        if (datasetName == null || datasetName.length() == 0) {
            this.addBrokenRule("Dataset name is missing for dataset run.", (Object)datasetRun);
        } else {
            dataset = (JRDesignDataset)this.jasperDesign.getDatasetMap().get(datasetName);
            if (dataset == null) {
                this.addBrokenRule("Unknown dataset name " + datasetName + ".", (Object)datasetRun);
            }
        }
        JRDatasetParameter[] parameters = datasetRun.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int index = 0; index < parameters.length; ++index) {
                JRDatasetParameter parameter = parameters[index];
                String paramName = parameter.getName();
                if (paramName == null || paramName.trim().length() == 0) {
                    this.addBrokenRule("Dataset " + datasetName + " parameter name missing.", (Object)parameter);
                }
                JRParameter datasetParam = null;
                if (dataset == null || (datasetParam = dataset.getParametersMap().get(paramName)) != null) continue;
                this.addBrokenRule("Unknown parameter " + paramName + " in dataset " + datasetName + ".", (Object)parameter);
            }
        }
        JRExpression connectionExpression = datasetRun.getConnectionExpression();
        JRExpression dataSourceExpression = datasetRun.getDataSourceExpression();
        if (connectionExpression != null && dataSourceExpression != null) {
            this.addBrokenRule("Dataset " + datasetName + " cannot have both connection expresion and data source expression.", (Object)datasetRun);
        }
        if ((returnValues = datasetRun.getReturnValues()) != null && !returnValues.isEmpty()) {
            for (ReturnValue returnValue : returnValues) {
                this.verifyReturnValue(returnValue);
            }
        }
    }

    private void verifyDatasets() {
        JRDataset[] datasets = this.jasperDesign.getDatasets();
        if (datasets != null && datasets.length > 0) {
            for (int i = 0; i < datasets.length; ++i) {
                JRDesignDataset dataset = (JRDesignDataset)datasets[i];
                if (dataset.getName() == null || dataset.getName().trim().length() == 0) {
                    this.addBrokenRule("Dataset name is missing.", (Object)dataset);
                }
                this.verifyDataset(dataset);
            }
        }
    }

    private void verifyDataset(JRDesignDataset dataset) {
        this.verifyExpressions(dataset);
        this.verifyParameters(dataset);
        this.verifyQuery(dataset);
        this.verifyFields(dataset);
        this.verifySortFields(dataset);
        this.verifyVariables(dataset);
        this.verifyGroups(dataset);
    }

    private void verifyFrame(JRFrame frame) {
        this.verifyReportElement(frame);
        JRElement[] elements = frame.getElements();
        if (elements != null && elements.length > 0) {
            int topPadding = frame.getLineBox().getTopPadding();
            int leftPadding = frame.getLineBox().getLeftPadding();
            int bottomPadding = frame.getLineBox().getBottomPadding();
            int rightPadding = frame.getLineBox().getRightPadding();
            int avlblWidth = frame.getWidth() - leftPadding - rightPadding;
            int avlblHeight = frame.getHeight() - topPadding - bottomPadding;
            for (int i = 0; i < elements.length; ++i) {
                JRElement element = elements[i];
                if (element.getX() + element.getWidth() > avlblWidth) {
                    this.addBrokenRule("Element reaches outside frame width: x=" + element.getX() + ", width=" + element.getWidth() + ", available width=" + avlblWidth + ".", (Object)element);
                }
                if (element.getY() + element.getHeight() > avlblHeight) {
                    this.addBrokenRule("Element reaches outside frame height: y=" + element.getY() + ", height=" + element.getHeight() + ", available height=" + avlblHeight + ".", (Object)element);
                }
                this.verifyElement(element);
            }
            this.verifyElementsOverlap(elements);
        }
    }

    public void verify(JRCategoryDataset dataset) {
        this.verifyElementDataset(dataset);
        JRCategorySeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRCategorySeries series) {
        this.verifyHyperlink(series.getItemHyperlink());
    }

    public void verify(JRPieDataset dataset) {
        this.verifyElementDataset(dataset);
        JRPieSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
        this.verifyHyperlink(dataset.getOtherSectionHyperlink());
    }

    protected void verify(JRPieSeries series) {
        this.verifyHyperlink(series.getSectionHyperlink());
    }

    public void verify(JRHighLowDataset dataset) {
        this.verifyElementDataset(dataset);
        this.verifyHyperlink(dataset.getItemHyperlink());
    }

    public void verify(JRTimePeriodDataset dataset) {
        this.verifyElementDataset(dataset);
        JRTimePeriodSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRTimePeriodSeries series) {
        this.verifyHyperlink(series.getItemHyperlink());
    }

    public void verify(JRTimeSeriesDataset dataset) {
        this.verifyElementDataset(dataset);
        JRTimeSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRTimeSeries series) {
        this.verifyHyperlink(series.getItemHyperlink());
    }

    public void verify(JRValueDataset dataset) {
    }

    public void verify(JRXyDataset dataset) {
        this.verifyElementDataset(dataset);
        JRXySeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRXySeries series) {
        this.verifyHyperlink(series.getItemHyperlink());
    }

    protected void verify(JRGanttSeries series) {
        this.verifyHyperlink(series.getItemHyperlink());
    }

    public void verify(JRXyzDataset dataset) {
        this.verifyElementDataset(dataset);
        JRXyzSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    public void verify(JRGanttDataset dataset) {
        this.verifyElementDataset(dataset);
        JRGanttSeries[] series = dataset.getSeries();
        if (series != null) {
            for (int i = 0; i < series.length; ++i) {
                this.verify(series[i]);
            }
        }
    }

    protected void verify(JRXyzSeries series) {
        this.verifyHyperlink(series.getItemHyperlink());
    }

    protected void verifyReportElement(JRElement element) {
        if (element.getWidth() < 0) {
            if (this.allowElementNegativeWidth) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Element has negative width: " + element.getWidth()));
                }
            } else {
                this.addBrokenRule("Element cannot have negative width.", (Object)element);
            }
        }
        if (element.getY() < 0 && !this.allowElementNegativeY(element)) {
            this.addBrokenRule("Element negative Y " + element.getY() + " not allowed", (Object)element);
        }
        this.verifyProperyExpressions(element.getPropertyExpressions());
    }

    protected boolean allowElementNegativeY(JRElement element) {
        JRPropertiesMap properties;
        boolean allow = this.allowElementNegativeY;
        if (element.hasProperties() && (properties = element.getPropertiesMap()).containsProperty(PROPERTY_ALLOW_ELEMENT_NEGATIVE_Y)) {
            allow = JRPropertiesUtil.asBoolean(properties.getProperty(PROPERTY_ALLOW_ELEMENT_NEGATIVE_Y));
        }
        return allow;
    }

    protected void verifyProperyExpressions(JRPropertyExpression[] propertyExpressions) {
        if (propertyExpressions != null) {
            for (int i = 0; i < propertyExpressions.length; ++i) {
                this.verifyPropertyExpression(propertyExpressions[i]);
            }
        }
    }

    protected void verifyPropertyExpression(JRPropertyExpression propertyExpression) {
        JRExpression expr;
        String name = propertyExpression.getName();
        if (name == null) {
            this.addBrokenRule("Property name missing.", (Object)propertyExpression);
        }
        if ((expr = propertyExpression.getValueExpression()) == null) {
            this.addBrokenRule("Property value expression missing.", (Object)propertyExpression);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyComponentElement(JRComponentElement element) {
        Component component;
        this.verifyReportElement(element);
        ComponentKey componentKey = element.getComponentKey();
        if (componentKey == null) {
            this.addBrokenRule("No component key set for component element", (Object)element);
        }
        if ((component = element.getComponent()) == null) {
            this.addBrokenRule("No component set for component element", (Object)element);
        }
        if (componentKey != null && component != null) {
            ComponentCompiler compiler = ComponentsEnvironment.getInstance(this.jasperReportsContext).getManager(componentKey).getComponentCompiler(this.jasperReportsContext);
            this.pushCurrentComponentElement(element);
            try {
                compiler.verify(component, this);
            }
            finally {
                this.popCurrentComponentElement();
            }
        }
    }

    public JRComponentElement getCurrentComponentElement() {
        if (this.currentComponentElementStack.isEmpty()) {
            return null;
        }
        return this.currentComponentElementStack.getFirst();
    }

    protected void pushCurrentComponentElement(JRComponentElement element) {
        this.currentComponentElementStack.addFirst(element);
    }

    protected void popCurrentComponentElement() {
        this.currentComponentElementStack.removeFirst();
    }

    protected void verifyGenericElement(JRGenericElement element) {
        JRGenericElementType type;
        this.verifyReportElement(element);
        if (element.getEvaluationTimeValue() == EvaluationTimeEnum.GROUP) {
            String groupName = element.getEvaluationGroupName();
            if (groupName == null) {
                this.addBrokenRule("Evaluation group not set for generic element", (Object)element);
            } else if (!this.jasperDesign.getGroupsMap().containsKey(groupName)) {
                this.addBrokenRule("Generic element evaluation group " + groupName + " not found in report", (Object)element);
            }
        }
        if ((type = element.getGenericType()) == null) {
            this.addBrokenRule("No type set for generic element", (Object)element);
        } else {
            if (type.getNamespace() == null) {
                this.addBrokenRule("No namespace set for generic element type", (Object)type);
            }
            if (type.getName() == null) {
                this.addBrokenRule("No name set for generic element type", (Object)type);
            }
        }
        JRGenericElementParameter[] parameters = element.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            JRGenericElementParameter parameter = parameters[i];
            if (parameter.getName() != null) continue;
            this.addBrokenRule("No name set for generic element parameter", (Object)parameter);
        }
    }

    private static int getBreakHeight(JRBand band) {
        int breakHeight = 0;
        if (band != null) {
            breakHeight = band.getHeight();
            JRElement[] elements = band.getElements();
            if (SplitTypeEnum.IMMEDIATE == band.getSplitTypeValue() && elements != null && elements.length > 0) {
                for (int i = 0; i < elements.length; ++i) {
                    JRElement element = elements[i];
                    int bottom = element.getY() + element.getHeight();
                    breakHeight = bottom < breakHeight ? bottom : breakHeight;
                }
            }
        }
        return breakHeight;
    }

    public void verifyExpression(JRExpression expression, Object parent, String mandatoryMessage) {
        if (expression == null && mandatoryMessage != null) {
            this.addBrokenRule(mandatoryMessage, parent);
        }
    }

    public void verify(MultiAxisData data) {
    }

    protected void verifyPart(JRPart part) {
        PartComponent component;
        ComponentKey componentKey;
        PartEvaluationTime evaluationTime = part.getEvaluationTime();
        if (evaluationTime != null && evaluationTime.getEvaluationTimeType() == PartEvaluationTimeType.GROUP) {
            String evaluationGroup = evaluationTime.getEvaluationGroup();
            if (evaluationGroup == null) {
                this.addBrokenRule("Evaluation group not set for part", (Object)part);
            } else {
                Map<String, JRGroup> groups = this.jasperDesign.getGroupsMap();
                if (!groups.containsKey(evaluationGroup)) {
                    this.addBrokenRule("Part evaluation group \"" + evaluationGroup + "\" not found in report", (Object)part);
                }
            }
        }
        if ((componentKey = part.getComponentKey()) == null) {
            this.addBrokenRule("No component key set for part", (Object)part);
        }
        if ((component = part.getComponent()) == null) {
            this.addBrokenRule("No component set for part", (Object)part);
        }
        if (componentKey != null && component != null) {
            PartComponentManager manager = PartComponentsEnvironment.getInstance(this.jasperReportsContext).getManager(componentKey);
            if (manager == null) {
                this.addBrokenRule("No component manager found for part component \"" + componentKey.getName() + "\"", (Object)part);
            } else {
                PartComponentCompiler compiler = manager.getComponentCompiler(this.jasperReportsContext);
                compiler.verify(component, this);
            }
        }
    }
}

