/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fonts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontFace;
import net.sf.jasperreports.engine.util.JRDataUtils;

public class SimpleFontFamily
implements FontFamily,
JRCloneable {
    private JasperReportsContext jasperReportsContext;
    private String name;
    private SimpleFontFace normalFace;
    private SimpleFontFace boldFace;
    private SimpleFontFace italicFace;
    private SimpleFontFace boldItalicFace;
    private String pdfEncoding;
    private Boolean isPdfEmbedded;
    private String defaultExportFont;
    private Map<String, String> exportFonts;
    private Set<String> locales;
    private boolean isVisible = true;

    public SimpleFontFamily() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public SimpleFontFamily(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    @Override
    public Object clone() {
        try {
            SimpleFontFamily clone = (SimpleFontFamily)super.clone();
            if (this.normalFace != null) {
                clone.setNormalFace((SimpleFontFace)this.normalFace.clone());
            }
            if (this.boldFace != null) {
                clone.setBoldFace((SimpleFontFace)this.boldFace.clone());
            }
            if (this.italicFace != null) {
                clone.setItalicFace((SimpleFontFace)this.italicFace.clone());
            }
            if (this.boldItalicFace != null) {
                clone.setBoldItalicFace((SimpleFontFace)this.boldItalicFace.clone());
            }
            if (this.locales != null) {
                clone.setLocales(new HashSet<String>(this.locales));
            }
            if (this.exportFonts != null) {
                clone.setExportFonts(new HashMap<String, String>(this.exportFonts));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNormal(String normal) {
        if (this.normalFace == null) {
            this.normalFace = new SimpleFontFace(this.jasperReportsContext);
        }
        this.normalFace.setTtf(normal);
    }

    public void setBold(String bold) {
        if (this.boldFace == null) {
            this.boldFace = new SimpleFontFace(this.jasperReportsContext);
        }
        this.boldFace.setTtf(bold);
    }

    public void setItalic(String italic) {
        if (this.italicFace == null) {
            this.italicFace = new SimpleFontFace(this.jasperReportsContext);
        }
        this.italicFace.setTtf(italic);
    }

    public void setBoldItalic(String boldItalic) {
        if (this.boldItalicFace == null) {
            this.boldItalicFace = new SimpleFontFace(this.jasperReportsContext);
        }
        this.boldItalicFace.setTtf(boldItalic);
    }

    @Override
    public FontFace getNormalFace() {
        return this.normalFace;
    }

    public void setNormalFace(SimpleFontFace normalFace) {
        this.normalFace = normalFace;
    }

    @Override
    public FontFace getBoldFace() {
        return this.boldFace;
    }

    public void setBoldFace(SimpleFontFace boldFace) {
        this.boldFace = boldFace;
    }

    @Override
    public FontFace getItalicFace() {
        return this.italicFace;
    }

    public void setItalicFace(SimpleFontFace italicFace) {
        this.italicFace = italicFace;
    }

    @Override
    public FontFace getBoldItalicFace() {
        return this.boldItalicFace;
    }

    public void setBoldItalicFace(SimpleFontFace boldItalicFace) {
        this.boldItalicFace = boldItalicFace;
    }

    @Override
    public String getNormalPdfFont() {
        return this.getNormalFace() == null ? null : this.getNormalFace().getPdf();
    }

    public void setNormalPdfFont(String normalPdfFont) {
        if (this.normalFace == null) {
            this.normalFace = new SimpleFontFace(this.jasperReportsContext);
        }
        this.normalFace.setPdf(normalPdfFont);
    }

    @Override
    public String getBoldPdfFont() {
        return this.getBoldFace() == null ? null : this.getBoldFace().getPdf();
    }

    public void setBoldPdfFont(String boldPdfFont) {
        if (this.boldFace == null) {
            this.boldFace = new SimpleFontFace(this.jasperReportsContext);
        }
        this.boldFace.setPdf(boldPdfFont);
    }

    @Override
    public String getItalicPdfFont() {
        return this.getItalicFace() == null ? null : this.getItalicFace().getPdf();
    }

    public void setItalicPdfFont(String italicPdfFont) {
        if (this.italicFace == null) {
            this.italicFace = new SimpleFontFace(this.jasperReportsContext);
        }
        this.italicFace.setPdf(italicPdfFont);
    }

    @Override
    public String getBoldItalicPdfFont() {
        return this.getBoldItalicFace() == null ? null : this.getBoldItalicFace().getPdf();
    }

    public void setBoldItalicPdfFont(String boldItalicPdfFont) {
        if (this.boldItalicFace == null) {
            this.boldItalicFace = new SimpleFontFace(this.jasperReportsContext);
        }
        this.boldItalicFace.setPdf(boldItalicPdfFont);
    }

    @Override
    public String getPdfEncoding() {
        return this.pdfEncoding;
    }

    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    @Override
    public Boolean isPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        this.isPdfEmbedded = isPdfEmbedded;
    }

    public String getDefaultExportFont() {
        return this.defaultExportFont;
    }

    public void setDefaultExportFont(String defaultExportFont) {
        this.defaultExportFont = defaultExportFont;
    }

    public Map<String, String> getExportFonts() {
        return this.exportFonts;
    }

    public void setExportFonts(Map<String, String> exportFonts) {
        this.exportFonts = exportFonts;
    }

    @Override
    public String getExportFont(String key) {
        String exportFont = this.exportFonts == null ? null : this.exportFonts.get(key);
        return exportFont == null ? this.defaultExportFont : exportFont;
    }

    public Set<String> getLocales() {
        return this.locales;
    }

    public void setLocales(Set<String> locales) {
        this.locales = locales;
    }

    @Override
    public boolean supportsLocale(Locale locale) {
        return this.locales == null || this.locales.isEmpty() || this.locales.contains(JRDataUtils.getLocaleCode(locale));
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }
}

