/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.query.QueryExecuterFactory;
import net.sf.jasperreports.engine.query.QueryExecuterFactoryBundle;

public final class JRQueryExecuterUtils {
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_EXECUTER_FACTORY_NOT_REGISTERED = "util.query.executer.factory.not.registered";
    private JasperReportsContext jasperReportsContext;

    private JRQueryExecuterUtils(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static JRQueryExecuterUtils getDefaultInstance() {
        return new JRQueryExecuterUtils(DefaultJasperReportsContext.getInstance());
    }

    public static JRQueryExecuterUtils getInstance(JasperReportsContext jasperReportsContext) {
        return new JRQueryExecuterUtils(jasperReportsContext);
    }

    public QueryExecuterFactory getExecuterFactory(String language) throws JRException {
        List<QueryExecuterFactoryBundle> oldBundles = this.jasperReportsContext.getExtensions(QueryExecuterFactoryBundle.class);
        for (QueryExecuterFactoryBundle bundle : oldBundles) {
            JRQueryExecuterFactory factory = bundle.getQueryExecuterFactory(language);
            if (factory == null) continue;
            return new WrappingQueryExecuterFactory(factory);
        }
        List<JRQueryExecuterFactoryBundle> bundles = this.jasperReportsContext.getExtensions(JRQueryExecuterFactoryBundle.class);
        for (JRQueryExecuterFactoryBundle bundle : bundles) {
            QueryExecuterFactory factory = bundle.getQueryExecuterFactory(language);
            if (factory == null) continue;
            return factory;
        }
        throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_EXECUTER_FACTORY_NOT_REGISTERED, new Object[]{language});
    }

    public static JRQueryExecuterFactory getQueryExecuterFactory(String language) throws JRException {
        return JRQueryExecuterUtils.getDefaultInstance().getExecuterFactory(language);
    }

    public static class WrappingQueryExecuterFactory
    implements QueryExecuterFactory {
        private JRQueryExecuterFactory factory;

        public WrappingQueryExecuterFactory(JRQueryExecuterFactory factory) {
            this.factory = factory;
        }

        @Override
        public Object[] getBuiltinParameters() {
            return this.factory.getBuiltinParameters();
        }

        @Override
        public JRQueryExecuter createQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) throws JRException {
            return this.factory.createQueryExecuter(dataset, parameters);
        }

        @Override
        public JRQueryExecuter createQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) throws JRException {
            return this.factory.createQueryExecuter(dataset, parameters);
        }

        @Override
        public boolean supportsQueryParameterType(String className) {
            return this.factory.supportsQueryParameterType(className);
        }
    }
}

