/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.collections.map.ReferenceMap;

public class JRSingletonCache<T> {
    private static final Object CONTEXT_KEY_NULL = new Object();
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_NOT_COMPATIBLE = "util.singleton.cache.class.not.compatible";
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_NOT_FOUND = "util.singleton.cache.class.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_INSTANCE_ERROR = "util.singleton.cache.instance.error";
    private final ReferenceMap cache = new ReferenceMap(2, 1);
    private final Class<T> itf;

    public JRSingletonCache(Class<T> itf) {
        this.itf = itf;
    }

    public synchronized T getCachedInstance(String className) throws JRException {
        Map<String, T> contextCache = this.getContextInstanceCache();
        T instance = contextCache.get(className);
        if (instance == null) {
            instance = this.createInstance(className);
            contextCache.put(className, instance);
        }
        return instance;
    }

    protected T createInstance(String className) throws JRException {
        try {
            Class<?> clazz = JRClassLoader.loadClassForName(className);
            if (this.itf != null && !this.itf.isAssignableFrom(clazz)) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_CLASS_NOT_COMPATIBLE, new Object[]{className, this.itf.getName()});
            }
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_CLASS_NOT_FOUND, new Object[]{className}, e);
        }
        catch (InstantiationException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_INSTANCE_ERROR, new Object[]{className}, e);
        }
        catch (IllegalAccessException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_INSTANCE_ERROR, new Object[]{className}, e);
        }
    }

    protected Map<String, T> getContextInstanceCache() {
        Object contextKey = this.getContextKey();
        Map contextCache = (Map)this.cache.get(contextKey);
        if (contextCache == null) {
            contextCache = new ReferenceMap();
            this.cache.put(contextKey, (Object)contextCache);
        }
        return contextCache;
    }

    protected Object getContextKey() {
        Object key = Thread.currentThread().getContextClassLoader();
        if (key == null) {
            key = CONTEXT_KEY_NULL;
        }
        return key;
    }
}

