/*
 * Decompiled with CFR 0.152.
 */
package de.cenote.jasperstarter;

import de.cenote.jasperstarter.types.AskFilter;
import de.cenote.jasperstarter.types.DsType;
import de.cenote.jasperstarter.types.OutputFormat;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import net.sourceforge.argparse4j.annotation.Arg;
import org.apache.commons.lang.LocaleUtils;

public class Config {
    Properties applicationProperties;
    String versionString;
    @Arg(dest="ask")
    AskFilter askFilter;
    @Arg(dest="command")
    String command;
    @Arg(dest="db-driver")
    String dbDriver;
    @Arg(dest="db-host")
    String dbHost;
    @Arg(dest="db-name")
    String dbName;
    @Arg(dest="db-passwd")
    String dbPasswd;
    @Arg(dest="db-port")
    Integer dbPort;
    @Arg(dest="db-sid")
    String dbSid;
    @Arg(dest="db-type")
    DsType dbType;
    @Arg(dest="db-url")
    String dbUrl;
    @Arg(dest="db-user")
    String dbUser;
    @Arg(dest="debug")
    boolean verbose;
    @Arg(dest="input")
    String input;
    @Arg(dest="jdbc-dir")
    File jdbcDir;
    @Arg(dest="data-file")
    File dataFile;
    @Arg(dest="csv-first-row")
    boolean csvFirstRow;
    @Arg(dest="csv-columns")
    String csvColumns;
    @Arg(dest="csv-record-del")
    String csvRecordDel;
    @Arg(dest="csv-field-del")
    String csvFieldDel;
    @Arg(dest="csv-charset")
    String csvCharset;
    @Arg(dest="xml-xpath")
    String xmlXpath;
    @Arg(dest="locale")
    String locale;
    @Arg(dest="output")
    String output;
    @Arg(dest="output-formats")
    List<OutputFormat> outputFormats;
    @Arg(dest="params")
    List<String> params;
    @Arg(dest="printer-name")
    String printerName;
    @Arg(dest="set-report-name")
    String reportName;
    @Arg(dest="resource")
    String resource;
    @Arg(dest="with-print-dialog")
    boolean withPrintDialog;
    @Arg(dest="write-jasper")
    boolean writeJasper;
    @Arg(dest="copies")
    Integer copies;
    @Arg(dest="out-field-del")
    String outFieldDel;
    @Arg(dest="out-charset")
    String outCharset;

    Config() {
        String jasperStarterVersion = "";
        String jasperStarterRevision = "";
        jasperStarterVersion = this.getClass().getPackage().getSpecificationVersion();
        jasperStarterRevision = this.getClass().getPackage().getImplementationVersion();
        String jasperReportsVersion = "";
        try {
            jasperReportsVersion = Package.getPackage("net.sf.jasperreports.engine").getImplementationVersion();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer("JasperStarter ").append(jasperStarterVersion).append(" Rev ").append(jasperStarterRevision).append("\n").append(" - JasperReports: ").append(jasperReportsVersion);
        this.versionString = sb.toString();
    }

    public String getVersionString() {
        return this.versionString;
    }

    public AskFilter getAskFilter() {
        return this.askFilter;
    }

    public boolean hasAskFilter() {
        return this.askFilter != null;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbPasswd() {
        return this.dbPasswd;
    }

    public Integer getDbPort() {
        return this.dbPort;
    }

    public String getDbSid() {
        return this.dbSid;
    }

    public DsType getDbType() {
        return this.dbType;
    }

    public boolean hasDbType() {
        return this.dbType != null;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getInput() {
        return this.input;
    }

    public File getJdbcDir() {
        return this.jdbcDir;
    }

    public boolean hasJdbcDir() {
        return this.jdbcDir != null && !this.jdbcDir.equals("");
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public boolean getCsvFirstRow() {
        return this.csvFirstRow;
    }

    public String[] getCsvColumns() {
        if (this.csvColumns == null) {
            return new String[0];
        }
        return this.csvColumns.split(",");
    }

    public String getCsvRecordDel() {
        return this.csvRecordDel;
    }

    public char getCsvFieldDel() {
        return this.csvFieldDel.charAt(0);
    }

    public String getCsvCharset() {
        return this.csvCharset;
    }

    public Locale getLocale() {
        return LocaleUtils.toLocale((String)this.locale);
    }

    public boolean hasLocale() {
        return this.locale != null && !this.locale.equals("");
    }

    public String getOutput() {
        return this.output;
    }

    public boolean hasOutput() {
        return this.output != null && !this.output.equals("");
    }

    public List<OutputFormat> getOutputFormats() {
        return this.outputFormats;
    }

    public List<String> getParams() {
        return this.params;
    }

    public boolean hasParams() {
        return this.params != null && !this.params.isEmpty();
    }

    public String getPrinterName() {
        return this.printerName;
    }

    public boolean hasPrinterName() {
        return this.printerName != null && !this.printerName.equals("");
    }

    public String getReportName() {
        return this.reportName;
    }

    public boolean hasReportName() {
        return this.reportName != null && !this.reportName.equals("");
    }

    public String getResource() {
        return this.resource;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public boolean isWithPrintDialog() {
        return this.withPrintDialog;
    }

    public boolean isWriteJasper() {
        return this.writeJasper;
    }

    public Integer getCopies() {
        return this.copies;
    }

    public boolean hasCopies() {
        return this.copies != null;
    }

    public String getOutFieldDel() {
        return this.outFieldDel;
    }

    public String getOutCharset() {
        return this.outCharset;
    }
}

