/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.destinations;

import com.lowagie.text.Document;
import com.lowagie.text.Meta;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.destinations.RtfDestination;

public class RtfDestinationInfo
extends RtfDestination {
    private String elementName = "";
    private String text = "";

    public RtfDestinationInfo() {
        super(null);
    }

    public RtfDestinationInfo(RtfParser parser, String elementname) {
        super(parser);
        this.setToDefaults();
        this.elementName = elementname;
    }

    public void setParser(RtfParser parser) {
        this.rtfParser = parser;
        this.setToDefaults();
    }

    public void setElementName(String value) {
        this.elementName = value;
    }

    public boolean handleOpeningSubGroup() {
        return true;
    }

    public boolean closeDestination() {
        return true;
    }

    public boolean handleCloseGroup() {
        if (this.text.length() > 0) {
            Document doc = this.rtfParser.getDocument();
            if (doc != null) {
                if (this.elementName.equals("author")) {
                    doc.addAuthor(this.text);
                }
                if (this.elementName.equals("title")) {
                    doc.addTitle(this.text);
                }
                if (this.elementName.equals("subject")) {
                    doc.addSubject(this.text);
                }
            } else {
                RtfDocument rtfDoc = this.rtfParser.getRtfDocument();
                if (rtfDoc != null) {
                    RtfInfoElement elem;
                    Meta meta;
                    if (this.elementName.equals("author")) {
                        meta = new Meta(this.elementName, this.text);
                        elem = new RtfInfoElement(rtfDoc, meta);
                        rtfDoc.getDocumentHeader().addInfoElement(elem);
                    }
                    if (this.elementName.equals("title")) {
                        meta = new Meta(this.elementName, this.text);
                        elem = new RtfInfoElement(rtfDoc, meta);
                        rtfDoc.getDocumentHeader().addInfoElement(elem);
                    }
                    if (this.elementName.equals("subject")) {
                        meta = new Meta(this.elementName, this.text);
                        elem = new RtfInfoElement(rtfDoc, meta);
                        rtfDoc.getDocumentHeader().addInfoElement(elem);
                    }
                }
            }
            this.setToDefaults();
        }
        return true;
    }

    public boolean handleOpenGroup() {
        return true;
    }

    public boolean handleCharacter(int ch) {
        this.text = this.text + (char)ch;
        return true;
    }

    public boolean handleControlWord(RtfCtrlWordData ctrlWordData) {
        this.elementName = ctrlWordData.ctrlWord;
        return true;
    }

    public void setToDefaults() {
        this.text = "";
    }
}

