/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.parts.subreport;

import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.part.PartComponent;
import net.sf.jasperreports.engine.part.PartComponentCompiler;
import net.sf.jasperreports.parts.subreport.StandardSubreportPartComponent;
import net.sf.jasperreports.parts.subreport.SubreportPartComponent;

public class SubreportPartComponentCompiler
implements PartComponentCompiler {
    @Override
    public void collectExpressions(PartComponent component, JRExpressionCollector collector) {
        SubreportPartComponent subreport = (SubreportPartComponent)component;
        collector.addExpression(subreport.getParametersMapExpression());
        JRSubreportParameter[] parameters = subreport.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int j = 0; j < parameters.length; ++j) {
                collector.addExpression(parameters[j].getExpression());
            }
        }
        collector.addExpression(subreport.getExpression());
    }

    @Override
    public PartComponent toCompiledComponent(PartComponent component, JRBaseObjectFactory baseFactory) {
        SubreportPartComponent subreportComponent = (SubreportPartComponent)component;
        StandardSubreportPartComponent compiledComponent = new StandardSubreportPartComponent(subreportComponent, baseFactory);
        return compiledComponent;
    }

    @Override
    public void verify(PartComponent component, JRVerifier verifier) {
        JRSubreportReturnValue[] returnValues;
        SubreportPartComponent subreportComponent = (SubreportPartComponent)component;
        JRSubreportParameter[] parameters = subreportComponent.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int index = 0; index < parameters.length; ++index) {
                JRSubreportParameter parameter = parameters[index];
                if (parameter.getName() != null && parameter.getName().trim().length() != 0) continue;
                verifier.addBrokenRule("Subreport part parameter name missing.", (Object)parameter);
            }
        }
        if ((returnValues = subreportComponent.getReturnValues()) != null && returnValues.length > 0) {
            for (int i = 0; i < returnValues.length; ++i) {
                JRSubreportReturnValue returnValue = returnValues[i];
                if (returnValue.getSubreportVariable() == null || returnValue.getSubreportVariable().trim().length() == 0) {
                    verifier.addBrokenRule("Subreport part return value variable name missing.", (Object)returnValue);
                }
                if (returnValue.getToVariable() == null || returnValue.getToVariable().trim().length() == 0) {
                    verifier.addBrokenRule("Subreport part return value to variable name missing.", (Object)returnValue);
                }
                if (verifier.getReportDesign().getVariablesMap().containsKey(returnValue.getToVariable())) continue;
                verifier.addBrokenRule("Subreport part return value to variable not found.", (Object)returnValue);
            }
        }
    }
}

