<?php
/**
 * This is the template for generating the model class of a specified table.
 */

/* @var $this yii\web\View */
/* @var $generator yii\gii\generators\model\Generator */
/* @var $tableName string full table name */
/* @var $className string class name */
/* @var $queryClassName string query class name */
/* @var $tableSchema yii\db\TableSchema */
/* @var $labels string[] list of attribute labels (name => label) */
/* @var $rules string[] list of validation rules */
/* @var $relations array list of relations (name => relation declaration) */

echo "<?php\n";
?>

namespace <?= $generator->ns ?>;

use Yii;

/**
 * This is the model class for table "<?= $generator->generateTableName($tableName) ?>".
 *
<?php foreach ($tableSchema->columns as $column): ?>
 * @property <?= "{$column->phpType} \${$column->name}\n" ?>
<?php endforeach; ?>
<?php if (!empty($relations)): ?>
 *
<?php foreach ($relations as $name => $relation): ?>
 * @property <?= $relation[1] . ($relation[2] ? '[]' : '') . ' $' . lcfirst($name) . "\n" ?>
<?php endforeach; ?>
<?php endif; ?>
 */
class <?= $className ?> extends <?= '\\' . ltrim($generator->baseClass, '\\') . "\n" ?>
{

<?php if (!empty($relations)):?>
/**
 * RV: Inician las variables virtuales
 *
 */

    <?php foreach ($relations as $name => $relation):
        if (!$relation[2]):   // RV: Si es una relacion 1 a 1

            $rel = isset(\Yii::$app->params['relations'][$className][$name]['mappings']) ?
                           \Yii::$app->params['relations'][$className][$name]['mappings'] : // El 100% debe estar aquí
                           \Yii::$app->params['relations'][$className . '/' . $name . '-fail'];  // Este es para que muestre cuál $className/$name no está configurada
            foreach ($rel as $local_column => $settings):
                if (!array_key_exists($local_column, $tableSchema->columns)):  // Si el property no existe en la BD, entonces crear una virtual
                    
                    if (is_array($settings)){   // Si los settings es un arreglo en vez de un valor tomar la etiqueta
                        $prop_virtual_labels[lcfirst($name) . "_" . $local_column] = $settings[1] ;
                        $prop_virtuals[lcfirst($name) . "_" . $local_column] = ['relation' => $name, 'rel_column' => $settings[0]] ;
                    } else {
                        $prop_virtuals[lcfirst($name) . "_" . $local_column] = ['relation' => $name, 'rel_column' => $settings] ;
                    };?>
    private $<?= lcfirst($name) . "_" . $local_column ?> ;
                <?php endif; ?>
            <?php endforeach; ?>
        <?php endif; ?>
    <?php endforeach; ?>
<?php endif; ?>

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '<?= $generator->generateTableName($tableName) ?>';
    }
<?php if ($generator->db !== 'db'): ?>

    /**
     * @return \yii\db\Connection the database connection used by this AR class.
     */
    public static function getDb()
    {
        return Yii::$app->get('<?= $generator->db ?>');
    }
<?php endif; ?>

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [<?= "\n            " . implode(",\n            ", $rules) . ",\n            " .
            (isset($prop_virtuals) ? ("[['" . implode("', '", array_keys($prop_virtuals)) . "'], 'safe']") : "") . "\n        " ?>];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
<?php foreach ($labels as $name => $label): ?>
            <?= "'$name' => " . $generator->generateString($label) . ",\n" ?>
<?php endforeach; ?>

<?php if (isset($prop_virtual_labels)): 
    foreach ($prop_virtual_labels as $name => $label): ?>
            <?= "'$name' => " . $generator->generateString($label) . ",\n" ?>
<?php endforeach;
      endif; ?>
        ];
    }
<?php foreach ($relations as $name => $relation): ?>

    /**
     * @return \yii\db\ActiveQuery
     */
    public function get<?= $name ?>()
    {
        <?= $relation[0] . "\n" ?>
    }
<?php endforeach; ?>
<?php if ($queryClassName): ?>
<?php
    $queryClassFullName = ($generator->ns === $generator->queryNs) ? $queryClassName : '\\' . $generator->queryNs . '\\' . $queryClassName;
    echo "\n";
?>
    /**
     * @inheritdoc
     * @return <?= $queryClassFullName ?> the active query used by this AR class.
     */
    public static function find()
    {
        return new <?= $queryClassFullName ?>(get_called_class());
    }
<?php endif; ?>
<?php if (isset($prop_virtuals)): ?>
    <?php foreach ($prop_virtuals as $virtual_name => $virtual_settings): ?>

    public function get<?= ucfirst($virtual_name) ?>()
    {
        $ar = $this->get<?= $virtual_settings['relation'] ?>()->one() ;

        return is_object($ar) ? $ar-><?= lcfirst($virtual_settings['rel_column']) ?> : null ;
    }

    public function set<?= ucfirst($virtual_name) ?>($val)
    {
        $<?= $virtual_name ?> = $val ;
    }

    <?php endforeach; ?>
<?php endif; ?>
    public function beforeValidate() // Asegurar que, si existen los autogenerados, entonces hacerlo antes de la validación, cuando se crea el registro
    {
        if (parent::beforeValidate()) {
            if (! $this->isNewRecord) { return true ; } ; // Si es un update no hay nada mas que hacer

            $labels = $this->attributeLabels() ; // Cuando es un nuevo record, las propiedades todavía no están creadas, por eso se buscan los labels
            echo $labels['fecha_hora'] ;
            if (isset($labels['fecha_hora']) ) {
                $this->fecha_hora = date('y-MM-dd H:mm:ss') ;
            }
            if (isset($labels['user_id'])) {
                if ( Yii::$app->user->isGuest) {
                    $this->user_id = 99999 ;
                } else {
                    $user_reg = app\models\User::findOne(['username' => Yii::$app->user->getId()]);
                    $this->user_id = is_object($user_reg) ? $user_reg->user_id : 88888 ;
                }
            }
            return true;

        } else {
            return false;
        }
    }

}
