<?php

use yii\helpers\Html;
use kartik\grid\GridView;
use yii\widgets\Pjax;

/**
 * @var yii\web\View $this
 * @var yii\data\ActiveDataProvider $dataProvider
 * @var app\models\ClientesSearch $searchModel
 */

$this->title = Yii::t('app', 'Clientes');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="clientes-index">
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?php /* echo Html::a(Yii::t('app', 'Create {modelClass}', [
    'modelClass' => 'Clientes',
]), ['create'], ['class' => 'btn btn-success'])*/  ?>
    </p>

    <?php Pjax::begin(); echo GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            // ['class' => 'yii\grid\SerialColumn'],

            'razon_social',
            'oficina_alta',
            'persona',
            'rfc',
            'estatus',
//            'contacto', 
//            'cuenta_contable', 
//            'dias_credito', 
//            'calle', 
//            'dias_pago', 
//            'numero', 
//            'interior', 
//            'poliza_seguro', 
//            'colonia', 
//            'factor_seguro', 
//            'ciudad', 
//            'telefono', 
//            'radio', 
//            'estados_id', 
//            'paises_id', 
//            'codigo_postal', 
//            'cuenta_pago', 
//            'cuenta_extranjera', 
//            'metodo_pago', 
//            'forma_pago', 
//            'usuario', 
//            'contrasena', 
//            'correo_principal', 
//            'correo_facturas', 
//            'correo_cobranza', 
//            'correo_trafico', 
//            'correo_almacen', 
//            'correo_evidencias', 
//            'destinos', 
//            'tarifas', 
//            'ubicacion', 

            [
                'class' => 'yii\grid\ActionColumn',
                'buttons' => [
                'update' => function ($url, $model) {
                                    return Html::a('<span class="glyphicon glyphicon-pencil"></span>', Yii::$app->urlManager->createUrl(['clientes/update','id' => $model->id]), [
                                                    'title' => Yii::t('yii', 'Edit'),
                                                  ]);}

                ],
            ],
        ],
        'responsive'=>true,
        'hover'=>true,
        'condensed'=>true,
        'floatHeader'=>true,




        'panel' => [
            'heading'=>'<h3 class="panel-title"><i class="glyphicon glyphicon-th-list"></i> '.Html::encode($this->title).' </h3>',
            'type'=>'info',
            'before'=>Html::a('<i class="glyphicon glyphicon-plus"></i> Crear', ['create'], ['class' => 'btn btn-success']),                                                                                                                                                          'after'=>Html::a('<i class="glyphicon glyphicon-repeat"></i> Refrescar', ['index'], ['class' => 'btn btn-info']),
            'showFooter'=>false
        ],
    ]); Pjax::end(); ?>

</div>
