<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\builder\Form;
use kartik\datecontrol\DateControl;
use kartik\builder\TabularForm;
use Yii\helpers\Url;
use yii\bootstrap\Modal;
use yii\widgets\Pjax;


/**
 * @var yii\web\View $this
 * @var app\models\DocumentosUnidades $model
 * @var yii\widgets\ActiveForm $form
 */

?>

 


<div class="documentos-unidades-form">

    <?php 



    $form = ActiveForm::begin(['type'=>ActiveForm::TYPE_HORIZONTAL, 'options'=>['enctype' => 'multipart/form-data']]);
?>
<div class="contenedor1">
<h2></h2>


 <?php     echo Form::widget([
	    'model' => $model,
	    'form' => $form,
	    'columns' => 2,
	    'attributes' => [
    
				

				
				'nombre_documento'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Nombre Documento...', 'maxlength'=>100]], 

				

    
				

				
				'descripcion_documento'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Descripcion Documento...', 'maxlength'=>255]], 

				

    
				

				
				'unidades_unidad'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Selecciona Unidades', 'readonly' => true], 
								'fieldConfig' => [
									'addon' => ['append' => [
													'content'=> Html::button('', [
														        	'value' => Url::to(['unidades/picker-ajax',
														        				'parent_model' => 'DocumentosUnidades', 
														        				'relation' => 'Unidades']),
														        	'class'=> 'glyphicon glyphicon-triangle-top',
														        	'id'=> 'modalUnidadesPickerButton',
														            'onclick' => "
														            		//alert('') ;
														            		$('#modalUnidadesPicker').modal('show')
														            			.find('#modalUnidadesPickerContent')
														            			.load($(this).attr('value') + '&' + '');
														            		",	
																	])
									]],
			    		]], 

				

    
				

				
				'documento'=>['type'=> Form::INPUT_FILE, 'options'=>['placeholder'=>'Ingrese Documento...']], 

				


    ]
    ]);
   ?>
</div>


    	    <?php 		    echo Form::widget([
		    'model' => $model,
		    'form' => $form,
		    'columns' => 2,
		    'attributes' => [    	
			
									'id'=>['type'=> TabularForm::INPUT_HIDDEN, 'label'=> false],

	
		    						'unidades_id'=>['type'=> TabularForm::INPUT_HIDDEN, 'label'=> false],

	
		    		    	]
    		]);
   		?>    
<div class="contenedor1">
    

<?php    echo Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-success']);
    echo "&nbsp;&nbsp;&nbsp; " ;
    echo Html::resetButton('Cancelar', ['class' => 'btn btn-danger']);
    ActiveForm::end(); ?>

</div>


<?php
	Modal::begin([
		'header' => '<h4>Selecciona Unidades</h4>',
		'id' => 'modalUnidadesPicker',
		'size'=> 'modal-lg',
		]);

	echo "<div id='modalUnidadesPickerContent'></div>" ;	
	Modal::end();
	

?>