<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\builder\Form;
use kartik\datecontrol\DateControl;
use kartik\builder\TabularForm;
use Yii\helpers\Url;
use yii\bootstrap\Modal;
use yii\widgets\Pjax;


/**
 * @var yii\web\View $this
 * @var app\models\Clientes $model
 * @var yii\widgets\ActiveForm $form
 */

?>

<div class="clientes-form">

    <?php     $form = ActiveForm::begin(['type'=>ActiveForm::TYPE_HORIZONTAL]);

    echo Form::widget([
	    'model' => $model,
	    'form' => $form,
	    'columns' => 2,
	    'attributes' => [
    
				

				
				'razon_social'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Razon Social...', 'maxlength'=>50]], 


			    
				

				
				'oficina_alta'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Oficina Alta...', 'maxlength'=>10]], 


			    
				

				
				'persona' => ['type' => TabularForm::INPUT_DROPDOWN_LIST, 'items' => ['M' => 'M','F' => 'F',]],  


			    
				

				
				'rfc'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Rfc...', 'maxlength'=>20]], 


			    
				

				
				'estatus' => ['type' => TabularForm::INPUT_DROPDOWN_LIST, 'items' => ['SOL' => 'SOL','ACT' => 'ACT','CAN' => 'CAN',]],  


			    
				

				
				'contacto'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Contacto...', 'maxlength'=>100]], 


			    
				

				
				'cuenta_contable'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Cuenta Contable...', 'maxlength'=>50]], 


			    
				

				
				'dias_credito'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Dias Credito...']], 


			    
				

				
				'calle'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Calle...', 'maxlength'=>100]], 


			    
				

				
				'dias_pago'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Dias Pago...']], 


			    
				

				
				'numero'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Numero...', 'maxlength'=>10]], 


			    
				

				
				'interior'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Interior...', 'maxlength'=>10]], 


			    
				

				
				'poliza_seguro'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Poliza Seguro...', 'maxlength'=>50]], 


			    
				

				
				'colonia'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Colonia...', 'maxlength'=>50]], 


			    
				

				
				'factor_seguro'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Factor Seguro...', 'maxlength'=>20]], 


			    
				

				
				'ciudad'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Ciudad...', 'maxlength'=>50]], 


			    
				

				
				'telefono'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Telefono...', 'maxlength'=>20]], 


			    
				

				
				'radio'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Radio...', 'maxlength'=>20]], 


			    
				

				
				'estados_estado'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Selecciona Estados', 'readonly' => true], 
								'fieldConfig' => [
									'addon' => ['append' => [
													'content'=> Html::button('', [
														        	'value' => Url::to(['estados/picker-ajax','parent_model' => 'Clientes', 'relation' => 'Estados']),
														        	'class'=> 'glyphicon glyphicon-triangle-top',
														        	'id'=> 'modalEstadosPickerButton',
														            'onclick' => "
														            		$('#modalEstadosPicker').modal('show')
														            			.find('#modalEstadosPickerContent')
														            			.load($(this).attr('value'));
														            		",	
																	])
									]],
			    		]], 


			    
				

				
				'paises_pais'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Selecciona Paises', 'readonly' => true], 
								'fieldConfig' => [
									'addon' => ['append' => [
													'content'=> Html::button('', [
														        	'value' => Url::to(['paises/picker-ajax','parent_model' => 'Clientes', 'relation' => 'Paises']),
														        	'class'=> 'glyphicon glyphicon-triangle-top',
														        	'id'=> 'modalPaisesPickerButton',
														            'onclick' => "
														            		$('#modalPaisesPicker').modal('show')
														            			.find('#modalPaisesPickerContent')
														            			.load($(this).attr('value'));
														            		",	
																	])
									]],
			    		]], 


			    
				

				
				'codigo_postal'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Codigo Postal...', 'maxlength'=>5]], 


			    
				

				
				'cuenta_pago'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Cuenta Pago...', 'maxlength'=>50]], 


			    
				

				
				'cuenta_extranjera'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Cuenta Extranjera...', 'maxlength'=>20]], 


			    
				

				
				'metodo_pago'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Metodo Pago...', 'maxlength'=>20]], 


			    
				

				
				'forma_pago'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Forma Pago...', 'maxlength'=>20]], 


			    
				

				
				'usuario'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Usuario...', 'maxlength'=>20]], 


			    
				

				
				'contrasena'=>['type'=> Form::INPUT_PASSWORD, 'options'=>['placeholder'=>'Ingrese Contrasena...', 'maxlength'=>20]], 


			    
				

				
				'correo_principal'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Correo Principal...', 'maxlength'=>50]], 


			    
				

				
				'correo_facturas'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Correo Facturas...', 'maxlength'=>50]], 


			    
				

				
				'correo_cobranza'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Correo Cobranza...', 'maxlength'=>50]], 


			    
				

				
				'correo_trafico'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Correo Trafico...', 'maxlength'=>50]], 


			    
				

				
				'correo_almacen'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Correo Almacen...', 'maxlength'=>50]], 


			    
				

				
				'correo_evidencias'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Correo Evidencias...', 'maxlength'=>50]], 


			    
				

				
				'destinos'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Destinos...', 'maxlength'=>100]], 


			    
				

				
				'tarifas'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Tarifas...', 'maxlength'=>100]], 


			    
				

				
				'ubicacion'=>['type'=> Form::INPUT_TEXT, 'options'=>['placeholder'=>'Ingrese Ubicacion...', 'maxlength'=>100]], 


			
    ]
    ]);

	
    	    ?>  

<?php 		    echo Form::widget([
		    'model' => $model,
		    'form' => $form,
		    'columns' => 2,
		    'attributes' => [    	
			
									'id'=>['type'=> TabularForm::INPUT_HIDDEN, 'label'=> false],

	
		    						'estados_id'=>['type'=> TabularForm::INPUT_HIDDEN, 'label'=> false],

	
		    						'paises_id'=>['type'=> TabularForm::INPUT_HIDDEN, 'label'=> false],

	
		    		    	]
    		]);
   		?>    
    

<?php    echo Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']);
    ActiveForm::end(); ?>

</div>


<?php
	Modal::begin([
		'header' => '<h4>Selecciona Estados</h4>',
		'id' => 'modalEstadosPicker',
		'size'=> 'modal-lg',
		]);

	echo "<div id='modalEstadosPickerContent'></div>" ;	
	Modal::end();
	

	Modal::begin([
		'header' => '<h4>Selecciona Paises</h4>',
		'id' => 'modalPaisesPicker',
		'size'=> 'modal-lg',
		]);

	echo "<div id='modalPaisesPickerContent'></div>" ;	
	Modal::end();
	

?>