/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.krysalis.barcode4j.BarcodeException;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.output.eps.EPSCanvasProvider;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.krysalis.barcode4j.tools.MimeTypes;

public class BarcodeTask
extends Task {
    private String symbol;
    private File configurationFile;
    private int dpi = 300;
    private String format = "image/svg+xml";
    private File output;
    private boolean bw = true;
    private String message;

    public void execute() throws BuildException {
        if (this.message == null || this.message.length() == 0) {
            throw new BuildException("No message");
        }
        if (this.output == null) {
            throw new BuildException("Output file is missing");
        }
        try {
            FileOutputStream out = new FileOutputStream(this.output);
            this.format = MimeTypes.expandFormat(this.format);
            int orientation = 0;
            this.log("Generating " + this.symbol + " in " + this.format + "...");
            BarcodeUtil util = BarcodeUtil.getInstance();
            BarcodeGenerator gen = util.createBarcodeGenerator(this.getConfiguration());
            if ("image/svg+xml".equals(this.format)) {
                SVGCanvasProvider svg = new SVGCanvasProvider(false, orientation);
                gen.generateBarcode(svg, this.message);
                try {
                    TransformerFactory factory = TransformerFactory.newInstance();
                    Transformer trans = factory.newTransformer();
                    DOMSource src = new DOMSource(svg.getDOMFragment());
                    StreamResult res = new StreamResult(out);
                    trans.transform(src, res);
                }
                catch (TransformerException te) {
                    throw new BuildException("XML/XSLT library error", (Throwable)te);
                }
            } else if ("image/x-eps".equals(this.format)) {
                EPSCanvasProvider eps = new EPSCanvasProvider(out, orientation);
                gen.generateBarcode(eps, this.message);
                eps.finish();
            } else {
                BitmapCanvasProvider bitmap = this.bw ? new BitmapCanvasProvider(out, this.format, this.dpi, 12, false, orientation) : new BitmapCanvasProvider(out, this.format, this.dpi, 10, true, orientation);
                gen.generateBarcode(bitmap, this.message);
                bitmap.finish();
            }
            ((OutputStream)out).close();
        }
        catch (IOException ioe) {
            throw new BuildException("Error writing output file: " + ioe.getMessage());
        }
        catch (ConfigurationException ce) {
            throw new BuildException("Configuration problem: " + ce.getMessage(), (Throwable)ce);
        }
        catch (BarcodeException be) {
            throw new BuildException("Error generating the barcode", (Throwable)be);
        }
    }

    private Configuration getConfiguration() {
        if (this.symbol != null) {
            DefaultConfiguration cfg = new DefaultConfiguration("cfg");
            DefaultConfiguration child = new DefaultConfiguration(this.symbol);
            cfg.addChild((Configuration)child);
            return cfg;
        }
        if (this.configurationFile != null) {
            try {
                if (!this.configurationFile.exists() || !this.configurationFile.isFile()) {
                    throw new BuildException("Config file not found: " + this.configurationFile);
                }
                this.log("Using configuration: " + this.configurationFile);
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                return builder.buildFromFile(this.configurationFile);
            }
            catch (Exception e) {
                throw new BuildException("Error reading configuration file: " + e.getMessage());
            }
        }
        return new DefaultConfiguration("cfg");
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setConfigurationFile(File configurationFile) {
        this.configurationFile = configurationFile;
    }

    public void setDpi(int dpi) {
        this.dpi = dpi;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setBw(boolean bw) {
        this.bw = bw;
    }

    public void setMessage(String message) {
        this.message = this.message != null ? this.message + message : message;
    }

    public void addText(String text) {
        this.message = this.message != null ? this.message + text : text;
    }
}

