/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.map.ItemData;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.MarkerDataset;
import net.sf.jasperreports.components.map.StandardItemData;
import net.sf.jasperreports.components.map.StandardMarkerDataset;
import net.sf.jasperreports.components.map.type.MapImageTypeEnum;
import net.sf.jasperreports.components.map.type.MapScaleEnum;
import net.sf.jasperreports.components.map.type.MapTypeEnum;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardMapComponent
implements MapComponent,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LATITUDE_EXPRESSION = "latitudeExpression";
    public static final String PROPERTY_LONGITUDE_EXPRESSION = "longitudeExpression";
    public static final String PROPERTY_ADDRESS_EXPRESSION = "addressExpression";
    public static final String PROPERTY_ZOOM_EXPRESSION = "zoomExpression";
    public static final String PROPERTY_LANGUAGE_EXPRESSION = "languageExpression";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_MAP_TYPE = "mapType";
    public static final String PROPERTY_MAP_SCALE = "mapScale";
    public static final String PROPERTY_IMAGE_TYPE = "imageType";
    public static final String PROPERTY_ON_ERROR_TYPE = "onErrorType";
    public static final String PROPERTY_MARKER_DATA_LIST = "markerDataList";
    public static final String PROPERTY_PATH_STYLE_LIST = "pathStyleList";
    public static final String PROPERTY_PATH_DATA_LIST = "pathDataList";
    public static final String PROPERTY_MARKER_DATASET = "markerDataset";
    public static final String PROPERTY_MARKER_DATA = "markerData";
    private JRExpression latitudeExpression;
    private JRExpression longitudeExpression;
    private JRExpression addressExpression;
    private JRExpression zoomExpression;
    private JRExpression languageExpression;
    private EvaluationTimeEnum evaluationTime = EvaluationTimeEnum.NOW;
    private String evaluationGroup;
    private MapTypeEnum mapType;
    private MapScaleEnum mapScale;
    private MapImageTypeEnum imageType;
    private OnErrorTypeEnum onErrorType;
    private List<ItemData> markerDataList = new ArrayList<ItemData>();
    private List<ItemData> pathStyleList = new ArrayList<ItemData>();
    private List<ItemData> pathDataList = new ArrayList<ItemData>();
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 60002;
    private MarkerDataset markerDataset;
    private ItemData markerData;

    public StandardMapComponent() {
    }

    public StandardMapComponent(MapComponent map, JRBaseObjectFactory objectFactory) {
        List<ItemData> pathList;
        this.latitudeExpression = objectFactory.getExpression(map.getLatitudeExpression());
        this.longitudeExpression = objectFactory.getExpression(map.getLongitudeExpression());
        this.addressExpression = objectFactory.getExpression(map.getAddressExpression());
        this.zoomExpression = objectFactory.getExpression(map.getZoomExpression());
        this.languageExpression = objectFactory.getExpression(map.getLanguageExpression());
        this.evaluationTime = map.getEvaluationTime();
        this.evaluationGroup = map.getEvaluationGroup();
        this.mapType = map.getMapType();
        this.mapScale = map.getMapScale();
        this.imageType = map.getImageType();
        List<ItemData> markerList = map.getMarkerDataList();
        if (markerList != null && markerList.size() > 0) {
            this.markerDataList = new ArrayList<ItemData>();
            for (ItemData markerData : markerList) {
                this.markerDataList.add(new StandardItemData(markerData, objectFactory));
            }
        }
        this.onErrorType = map.getOnErrorType();
        List<ItemData> styleList = map.getPathStyleList();
        if (styleList != null && styleList.size() > 0) {
            this.pathStyleList = new ArrayList<ItemData>();
            for (ItemData pathStyle : styleList) {
                this.pathStyleList.add(new StandardItemData(pathStyle, objectFactory));
            }
        }
        if ((pathList = map.getPathDataList()) != null && pathList.size() > 0) {
            this.pathDataList = new ArrayList<ItemData>();
            for (ItemData pathData : pathList) {
                this.pathDataList.add(new StandardItemData(pathData, objectFactory));
            }
        }
    }

    @Override
    public JRExpression getLatitudeExpression() {
        return this.latitudeExpression;
    }

    public void setLatitudeExpression(JRExpression latitudeExpression) {
        JRExpression old = this.latitudeExpression;
        this.latitudeExpression = latitudeExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_LATITUDE_EXPRESSION, old, this.latitudeExpression);
    }

    @Override
    public JRExpression getLongitudeExpression() {
        return this.longitudeExpression;
    }

    public void setLongitudeExpression(JRExpression longitudeExpression) {
        JRExpression old = this.longitudeExpression;
        this.longitudeExpression = longitudeExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_LONGITUDE_EXPRESSION, old, this.longitudeExpression);
    }

    @Override
    public JRExpression getAddressExpression() {
        return this.addressExpression;
    }

    public void setAddressExpression(JRExpression addressExpression) {
        JRExpression old = this.addressExpression;
        this.addressExpression = addressExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ADDRESS_EXPRESSION, old, this.addressExpression);
    }

    @Override
    public JRExpression getZoomExpression() {
        return this.zoomExpression;
    }

    public void setZoomExpression(JRExpression zoomExpression) {
        JRExpression old = this.zoomExpression;
        this.zoomExpression = zoomExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ZOOM_EXPRESSION, old, this.zoomExpression);
    }

    @Override
    public JRExpression getLanguageExpression() {
        return this.languageExpression;
    }

    public void setLanguageExpression(JRExpression languageExpression) {
        JRExpression old = this.languageExpression;
        this.languageExpression = languageExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_LANGUAGE_EXPRESSION, old, this.languageExpression);
    }

    @Override
    public EvaluationTimeEnum getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTimeValue) {
        EvaluationTimeEnum old = this.evaluationTime;
        this.evaluationTime = evaluationTimeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTime);
    }

    @Override
    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(String evaluationGroup) {
        String old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        StandardMapComponent standardMapComponent = this;
        synchronized (standardMapComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public Object clone() {
        StandardMapComponent clone = null;
        try {
            clone = (StandardMapComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.latitudeExpression = JRCloneUtils.nullSafeClone(this.latitudeExpression);
        clone.longitudeExpression = JRCloneUtils.nullSafeClone(this.longitudeExpression);
        clone.addressExpression = JRCloneUtils.nullSafeClone(this.addressExpression);
        clone.zoomExpression = JRCloneUtils.nullSafeClone(this.zoomExpression);
        clone.languageExpression = JRCloneUtils.nullSafeClone(this.languageExpression);
        clone.markerDataList = JRCloneUtils.cloneList(this.markerDataList);
        clone.pathStyleList = JRCloneUtils.cloneList(this.pathStyleList);
        clone.pathDataList = JRCloneUtils.cloneList(this.pathDataList);
        clone.eventSupport = null;
        return clone;
    }

    @Override
    public MapTypeEnum getMapType() {
        return this.mapType;
    }

    public void setMapType(MapTypeEnum mapType) {
        MapTypeEnum old = this.mapType;
        this.mapType = mapType;
        this.getEventSupport().firePropertyChange(PROPERTY_MAP_TYPE, old, this.mapType);
    }

    @Override
    public MapScaleEnum getMapScale() {
        return this.mapScale;
    }

    public void setMapScale(MapScaleEnum mapScale) {
        MapScaleEnum old = this.mapScale;
        this.mapScale = mapScale;
        this.getEventSupport().firePropertyChange(PROPERTY_MAP_SCALE, old, this.mapScale);
    }

    @Override
    public MapImageTypeEnum getImageType() {
        return this.imageType;
    }

    public void setImageType(MapImageTypeEnum imageType) {
        MapImageTypeEnum old = this.imageType;
        this.imageType = imageType;
        this.getEventSupport().firePropertyChange(PROPERTY_IMAGE_TYPE, old, this.imageType);
    }

    @Override
    public ItemData getMarkerData() {
        return !this.markerDataList.isEmpty() ? this.markerDataList.get(0) : null;
    }

    public void setMarkerData(ItemData markerData) {
        this.addMarkerData(markerData);
    }

    @Override
    public OnErrorTypeEnum getOnErrorType() {
        return this.onErrorType;
    }

    public void setOnErrorType(OnErrorTypeEnum onErrorType) {
        OnErrorTypeEnum old = this.onErrorType;
        this.onErrorType = onErrorType;
        this.getEventSupport().firePropertyChange(PROPERTY_ON_ERROR_TYPE, old, this.onErrorType);
    }

    @Override
    public MarkerDataset getMarkerDataset() {
        return this.markerDataset;
    }

    public void setMarkerDataset(MarkerDataset markerDataset) {
        this.setMarkerData(StandardMarkerDataset.getItemData(markerDataset));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 50502) {
            if (this.markerDataset != null) {
                if (this.PSEUDO_SERIAL_VERSION_UID < 30101) {
                    this.markerData = StandardMarkerDataset.getItemData(this.markerDataset);
                } else {
                    this.markerDataList = new ArrayList<ItemData>();
                    this.markerDataList.add(StandardMarkerDataset.getItemData(this.markerDataset));
                }
            }
            this.markerDataset = null;
            if (this.markerData != null) {
                this.markerDataList = new ArrayList<ItemData>();
                this.markerDataList.add(this.markerData);
            }
            this.markerData = null;
        }
    }

    @Override
    public List<ItemData> getPathStyleList() {
        return this.pathStyleList;
    }

    public void addPathStyle(ItemData pathStyle) {
        this.pathStyleList.add(pathStyle);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PATH_STYLE_LIST, pathStyle, this.pathStyleList.size() - 1);
    }

    public void addPathStyle(int index, ItemData pathStyle) {
        if (index >= 0 && index < this.pathStyleList.size()) {
            this.pathStyleList.add(index, pathStyle);
        } else {
            this.pathStyleList.add(pathStyle);
            index = this.pathStyleList.size() - 1;
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PATH_STYLE_LIST, this.pathStyleList, index);
    }

    public ItemData removePathStyle(ItemData pathStyle) {
        int idx;
        if (pathStyle != null && (idx = this.pathStyleList.indexOf(pathStyle)) >= 0) {
            this.pathStyleList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PATH_STYLE_LIST, pathStyle, idx);
        }
        return pathStyle;
    }

    @Override
    public List<ItemData> getMarkerDataList() {
        return this.markerDataList;
    }

    public void addMarkerData(ItemData markerData) {
        this.markerDataList.add(markerData);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MARKER_DATA_LIST, markerData, this.markerDataList.size() - 1);
    }

    public void addMarkerData(int index, ItemData markerData) {
        if (index >= 0 && index < this.markerDataList.size()) {
            this.markerDataList.add(index, markerData);
        } else {
            this.markerDataList.add(markerData);
            index = this.markerDataList.size() - 1;
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MARKER_DATA_LIST, this.markerDataList, index);
    }

    public ItemData removeMarkerData(ItemData markerData) {
        int idx;
        if (markerData != null && (idx = this.markerDataList.indexOf(markerData)) >= 0) {
            this.markerDataList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_MARKER_DATA_LIST, markerData, idx);
        }
        return markerData;
    }

    @Override
    public List<ItemData> getPathDataList() {
        return this.pathDataList;
    }

    public void addPathData(ItemData pathData) {
        this.pathDataList.add(pathData);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PATH_DATA_LIST, pathData, this.pathDataList.size() - 1);
    }

    public void addPathData(int index, ItemData pathData) {
        if (index >= 0 && index < this.pathDataList.size()) {
            this.pathDataList.add(index, pathData);
        } else {
            this.pathDataList.add(pathData);
            index = this.pathDataList.size() - 1;
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PATH_DATA_LIST, this.pathDataList, index);
    }

    public ItemData removePathData(ItemData pathData) {
        int idx;
        if (pathData != null && (idx = this.pathDataList.indexOf(pathData)) >= 0) {
            this.pathDataList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PATH_DATA_LIST, pathData, idx);
        }
        return pathData;
    }
}

