/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.data.DataFileConnection;
import net.sf.jasperreports.data.DataFileService;
import net.sf.jasperreports.data.http.HttpDataConnection;
import net.sf.jasperreports.data.http.HttpDataLocation;
import net.sf.jasperreports.data.http.HttpLocationParameter;
import net.sf.jasperreports.data.http.RequestMethod;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.util.SecretsUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public class HttpDataService
implements DataFileService {
    private static final Log log = LogFactory.getLog(HttpDataService.class);
    public static final String EXCEPTION_MESSAGE_KEY_NO_HTTP_URL_SET = "data.http.no.http.url.set";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_REQUEST_METHOD = "data.http.unknown.request.method";
    public static final String PARAMETER_URL = "HTTP_DATA_URL";
    public static final String PARAMETER_USERNAME = "HTTP_DATA_USERNAME";
    public static final String PARAMETER_PASSWORD = "HTTP_DATA_PASSWORD";
    public static final String PARAMETER_PREFIX_URL_PARAMETER = "HTTP_DATA_URL_PARAMETER_";
    public static final String PARAMETER_PREFIX_POST_PARAMETER = "HTTP_DATA_POST_PARAMETER_";
    private final JasperReportsContext context;
    private final HttpDataLocation dataLocation;

    public HttpDataService(JasperReportsContext context, HttpDataLocation dataLocation) {
        this.context = context;
        this.dataLocation = dataLocation;
    }

    @Override
    public DataFileConnection getDataFileConnection(Map<String, Object> parameters) throws JRException {
        CloseableHttpClient httpClient = this.createHttpClient(parameters);
        HttpRequestBase request = this.createRequest(parameters);
        return new HttpDataConnection(httpClient, request);
    }

    protected CloseableHttpClient createHttpClient(Map<String, Object> parameters) {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager();
        clientBuilder.setConnectionManager((HttpClientConnectionManager)connManager);
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").build();
        clientBuilder.setDefaultRequestConfig(requestConfig);
        HttpClientContext clientContext = HttpClientContext.create();
        this.setAuthentication(parameters, clientContext);
        CloseableHttpClient client = clientBuilder.build();
        return client;
    }

    protected void setAuthentication(Map<String, Object> parameters, HttpClientContext clientContext) {
        String username = this.getUsername(parameters);
        if (username != null) {
            String password = this.getPassword(parameters);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(username, password));
            clientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }

    protected String getUsername(Map<String, Object> parameters) {
        String username = (String)parameters.get(PARAMETER_USERNAME);
        if (username == null) {
            username = this.dataLocation.getUsername();
        }
        return username;
    }

    protected String getPassword(Map<String, Object> parameters) {
        String password = (String)parameters.get(PARAMETER_PASSWORD);
        if (password == null) {
            password = this.dataLocation.getPassword();
        }
        if (password != null) {
            SecretsUtil secrets = SecretsUtil.getInstance(this.context);
            password = secrets.getSecret("net.sf.jasperreports.data.adapter", password);
        }
        return password;
    }

    protected HttpRequestBase createRequest(Map<String, Object> parameters) {
        HttpPost request;
        List<NameValuePair> postParameters = this.collectPostParameters(parameters);
        URI requestURI = this.getRequestURI(parameters);
        RequestMethod method = this.dataLocation.getMethod();
        if (method == null) {
            method = postParameters.isEmpty() ? RequestMethod.GET : RequestMethod.POST;
        }
        switch (method) {
            case GET: {
                if (!postParameters.isEmpty()) {
                    log.warn((Object)("Ignoring POST parameters for GET request to " + this.dataLocation.getUrl()));
                }
                request = this.createGetRequest(requestURI);
                break;
            }
            case POST: {
                request = this.createPostRequest(requestURI, postParameters);
                break;
            }
            case PUT: {
                request = this.createPutRequest(requestURI, postParameters);
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_REQUEST_METHOD, new Object[]{method});
            }
        }
        return request;
    }

    protected HttpGet createGetRequest(URI requestURI) {
        HttpGet httpGet = new HttpGet(requestURI);
        return httpGet;
    }

    protected HttpPost createPostRequest(URI requestURI, List<NameValuePair> postParameters) {
        HttpPost httpPost = new HttpPost(requestURI);
        HttpEntity entity = this.createRequestEntity(postParameters);
        httpPost.setEntity(entity);
        return httpPost;
    }

    protected HttpPut createPutRequest(URI requestURI, List<NameValuePair> postParameters) {
        HttpPut httpPost = new HttpPut(requestURI);
        HttpEntity entity = this.createRequestEntity(postParameters);
        httpPost.setEntity(entity);
        return httpPost;
    }

    protected HttpEntity createRequestEntity(List<NameValuePair> postParameters) {
        UrlEncodedFormEntity formEntity;
        try {
            formEntity = new UrlEncodedFormEntity(postParameters, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JRRuntimeException(e);
        }
        return formEntity;
    }

    protected List<NameValuePair> collectUrlParameters(Map<String, Object> reportParameters) {
        return this.collectParameters(this.dataLocation.getUrlParameters(), reportParameters, PARAMETER_PREFIX_URL_PARAMETER);
    }

    protected List<NameValuePair> collectPostParameters(Map<String, Object> reportParameters) {
        return this.collectParameters(this.dataLocation.getPostParameters(), reportParameters, PARAMETER_PREFIX_POST_PARAMETER);
    }

    protected List<NameValuePair> collectParameters(List<HttpLocationParameter> staticParameters, Map<String, Object> reportParameters, String reportParameterPrefix) {
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        if (staticParameters != null && !staticParameters.isEmpty()) {
            for (HttpLocationParameter httpLocationParameter : staticParameters) {
                String name = httpLocationParameter.getName();
                String paramValue = httpLocationParameter.getValue();
                if (paramValue == null) continue;
                String reportParameterName = reportParameterPrefix + httpLocationParameter.getName();
                if (!reportParameters.containsKey(reportParameterName)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding parameter " + name + " with value " + paramValue));
                    }
                    postParameters.add((NameValuePair)new BasicNameValuePair(name, paramValue));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("static parameter " + httpLocationParameter.getName() + " overridden by the report"));
            }
        }
        for (Map.Entry entry : reportParameters.entrySet()) {
            String paramName = (String)entry.getKey();
            Object value = entry.getValue();
            if (!paramName.startsWith(reportParameterPrefix) || value == null) continue;
            String name = paramName.substring(reportParameterPrefix.length(), paramName.length());
            String paramValue = this.toHttpParameterValue(value);
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding parameter " + name + " with value " + paramValue));
            }
            postParameters.add((NameValuePair)new BasicNameValuePair(name, paramValue));
        }
        return postParameters;
    }

    protected URI getRequestURI(Map<String, Object> parameters) {
        String url = this.getURL(parameters);
        if (url == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_HTTP_URL_SET, (Object[])null);
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            List<NameValuePair> urlParameters = this.collectUrlParameters(parameters);
            if (!urlParameters.isEmpty()) {
                uriBuilder.addParameters(urlParameters);
            }
            URI uri = uriBuilder.build();
            if (log.isDebugEnabled()) {
                log.debug((Object)("request URI " + uri));
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected String getURL(Map<String, Object> parameters) {
        String url = (String)parameters.get(PARAMETER_URL);
        if (url == null) {
            url = this.dataLocation.getUrl();
        }
        return url;
    }

    protected String toHttpParameterValue(Object value) {
        return String.valueOf(value);
    }
}

