/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.Deduplicable;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseParagraph;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class JRBaseStyle
implements JRStyle,
Serializable,
JRChangeEventsSupport,
Deduplicable {
    public static final String EXCEPTION_MESSAGE_KEY_CIRCULAR_DEPENDENCY = "engine.style.circular.dependency";
    private static final long serialVersionUID = 10001L;
    public static final String PROPERTY_BACKCOLOR = "backcolor";
    public static final String PROPERTY_BLANK_WHEN_NULL = "isBlankWhenNull";
    public static final String PROPERTY_BOLD = "isBold";
    public static final String PROPERTY_FILL = "fill";
    public static final String PROPERTY_FONT_NAME = "fontName";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_FORECOLOR = "forecolor";
    public static final String PROPERTY_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String PROPERTY_HORIZONTAL_TEXT_ALIGNMENT = "horizontalTextAlignment";
    public static final String PROPERTY_HORIZONTAL_IMAGE_ALIGNMENT = "horizontalImageAlignment";
    public static final String PROPERTY_ITALIC = "isItalic";
    public static final String PROPERTY_LINE_SPACING = "lineSpacing";
    public static final String PROPERTY_MODE = "mode";
    public static final String PROPERTY_PATTERN = "pattern";
    public static final String PROPERTY_PDF_EMBEDDED = "isPdfEmbedded";
    public static final String PROPERTY_PDF_ENCODING = "pdfEncoding";
    public static final String PROPERTY_PDF_FONT_NAME = "pdfFontName";
    public static final String PROPERTY_RADIUS = "radius";
    public static final String PROPERTY_ROTATION = "rotation";
    public static final String PROPERTY_SCALE_IMAGE = "scaleImage";
    public static final String PROPERTY_STRIKE_THROUGH = "isStrikeThrough";
    public static final String PROPERTY_MARKUP = "markup";
    public static final String PROPERTY_UNDERLINE = "isUnderline";
    public static final String PROPERTY_VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String PROPERTY_VERTICAL_TEXT_ALIGNMENT = "verticalTextAlignment";
    public static final String PROPERTY_VERTICAL_IMAGE_ALIGNMENT = "verticalImageAlignment";
    protected JRDefaultStyleProvider defaultStyleProvider;
    protected JRStyle parentStyle;
    protected String parentStyleNameReference;
    protected String name;
    protected boolean isDefault;
    protected Byte positionType;
    protected Byte stretchType;
    protected ModeEnum modeValue;
    protected Color forecolor;
    protected Color backcolor;
    protected JRPen linePen;
    protected FillEnum fillValue;
    protected Integer radius;
    protected ScaleImageEnum scaleImageValue;
    protected HorizontalTextAlignEnum horizontalTextAlign;
    protected VerticalTextAlignEnum verticalTextAlign;
    protected HorizontalImageAlignEnum horizontalImageAlign;
    protected VerticalImageAlignEnum verticalImageAlign;
    protected JRLineBox lineBox;
    protected JRParagraph paragraph;
    protected String fontName;
    protected Boolean isBold;
    protected Boolean isItalic;
    protected Boolean isUnderline;
    protected Boolean isStrikeThrough;
    protected Float fontsize;
    protected String pdfFontName;
    protected String pdfEncoding;
    protected Boolean isPdfEmbedded;
    protected RotationEnum rotationValue;
    protected String markup;
    protected String pattern;
    protected Boolean isBlankWhenNull;
    protected JRConditionalStyle[] conditionalStyles;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 60002;
    private Byte mode;
    private Byte horizontalAlignment;
    private Byte verticalAlignment;
    private HorizontalAlignEnum horizontalAlignmentValue;
    private VerticalAlignEnum verticalAlignmentValue;
    private Byte rotation;
    private Byte lineSpacing;
    private LineSpacingEnum lineSpacingValue;
    private Byte pen;
    private Byte border;
    private Byte topBorder;
    private Byte leftBorder;
    private Byte bottomBorder;
    private Byte rightBorder;
    private Color borderColor;
    private Color topBorderColor;
    private Color leftBorderColor;
    private Color bottomBorderColor;
    private Color rightBorderColor;
    private Integer padding;
    private Integer topPadding;
    private Integer leftPadding;
    private Integer bottomPadding;
    private Integer rightPadding;
    private Boolean isStyledText;
    private Byte scaleImage;
    private Byte fill;
    private Integer fontSize;

    public JRBaseStyle() {
        this.linePen = new JRBasePen(this);
        this.lineBox = new JRBaseLineBox(this);
        this.paragraph = new JRBaseParagraph(this);
    }

    public JRBaseStyle(String name) {
        this.name = name;
        this.linePen = new JRBasePen(this);
        this.lineBox = new JRBaseLineBox(this);
        this.paragraph = new JRBaseParagraph(this);
    }

    public JRBaseStyle(JRStyle style, JRAbstractObjectFactory factory) {
        this.name = style.getName();
        factory.setStyle(new JRStyleSetter(){

            @Override
            public void setStyle(JRStyle aStyle) {
                JRBaseStyle.this.setParentStyle(aStyle);
            }

            @Override
            public void setStyleNameReference(String name) {
                JRBaseStyle.this.parentStyleNameReference = name;
            }
        }, style);
        this.isDefault = style.isDefault();
        this.modeValue = style.getOwnModeValue();
        this.forecolor = style.getOwnForecolor();
        this.backcolor = style.getOwnBackcolor();
        this.linePen = style.getLinePen().clone(this);
        this.fillValue = style.getOwnFillValue();
        this.radius = style.getOwnRadius();
        this.scaleImageValue = style.getOwnScaleImageValue();
        this.horizontalTextAlign = style.getOwnHorizontalTextAlign();
        this.verticalTextAlign = style.getOwnVerticalTextAlign();
        this.horizontalImageAlign = style.getOwnHorizontalImageAlign();
        this.verticalImageAlign = style.getOwnVerticalImageAlign();
        this.lineBox = style.getLineBox().clone(this);
        this.paragraph = style.getParagraph().clone(this);
        this.rotationValue = style.getOwnRotationValue();
        this.markup = style.getOwnMarkup();
        this.pattern = style.getOwnPattern();
        this.fontName = style.getOwnFontName();
        this.isBold = style.isOwnBold();
        this.isItalic = style.isOwnItalic();
        this.isUnderline = style.isOwnUnderline();
        this.isStrikeThrough = style.isOwnStrikeThrough();
        this.fontsize = style.getOwnFontsize();
        this.pdfFontName = style.getOwnPdfFontName();
        this.pdfEncoding = style.getOwnPdfEncoding();
        this.isPdfEmbedded = style.isOwnPdfEmbedded();
        this.isBlankWhenNull = style.isOwnBlankWhenNull();
        JRConditionalStyle[] condStyles = style.getConditionalStyles();
        if (condStyles != null && condStyles.length > 0) {
            this.conditionalStyles = new JRConditionalStyle[condStyles.length];
            for (int i = 0; i < condStyles.length; ++i) {
                this.conditionalStyles[i] = factory.getConditionalStyle(condStyles[i], this);
            }
        }
    }

    protected void setParentStyle(JRStyle parentStyle) {
        this.parentStyle = parentStyle;
        this.checkCircularParent();
    }

    protected void checkCircularParent() {
        for (JRStyle ancestor = this.parentStyle; ancestor != null; ancestor = ancestor.getStyle()) {
            if (ancestor != this) continue;
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CIRCULAR_DEPENDENCY, new Object[]{this.getName()});
        }
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    @Override
    public JRStyle getStyle() {
        return this.parentStyle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void rename(String newName) {
        this.name = newName;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    @Override
    public Color getOwnForecolor() {
        return this.forecolor;
    }

    @Override
    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    @Override
    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    @Override
    public JRPen getLinePen() {
        return this.linePen;
    }

    @Override
    public FillEnum getFillValue() {
        return JRStyleResolver.getFillValue(this);
    }

    @Override
    public FillEnum getOwnFillValue() {
        return this.fillValue;
    }

    @Override
    public Integer getRadius() {
        return JRStyleResolver.getRadius(this);
    }

    @Override
    public Integer getOwnRadius() {
        return this.radius;
    }

    @Override
    public ScaleImageEnum getScaleImageValue() {
        return JRStyleResolver.getScaleImageValue(this);
    }

    @Override
    public ScaleImageEnum getOwnScaleImageValue() {
        return this.scaleImageValue;
    }

    @Override
    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return HorizontalAlignEnum.getHorizontalAlignEnum(this.getHorizontalTextAlign());
    }

    @Override
    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return HorizontalAlignEnum.getHorizontalAlignEnum(this.getOwnHorizontalTextAlign());
    }

    @Override
    public VerticalAlignEnum getVerticalAlignmentValue() {
        return VerticalAlignEnum.getVerticalAlignEnum(this.getVerticalTextAlign());
    }

    @Override
    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return VerticalAlignEnum.getVerticalAlignEnum(this.getOwnVerticalTextAlign());
    }

    @Override
    public HorizontalTextAlignEnum getHorizontalTextAlign() {
        return JRStyleResolver.getHorizontalTextAlign(this);
    }

    @Override
    public HorizontalTextAlignEnum getOwnHorizontalTextAlign() {
        return this.horizontalTextAlign;
    }

    @Override
    public VerticalTextAlignEnum getVerticalTextAlign() {
        return JRStyleResolver.getVerticalTextAlign(this);
    }

    @Override
    public VerticalTextAlignEnum getOwnVerticalTextAlign() {
        return this.verticalTextAlign;
    }

    @Override
    public HorizontalImageAlignEnum getHorizontalImageAlign() {
        return JRStyleResolver.getHorizontalImageAlign(this);
    }

    @Override
    public HorizontalImageAlignEnum getOwnHorizontalImageAlign() {
        return this.horizontalImageAlign;
    }

    @Override
    public VerticalImageAlignEnum getVerticalImageAlign() {
        return JRStyleResolver.getVerticalImageAlign(this);
    }

    @Override
    public VerticalImageAlignEnum getOwnVerticalImageAlign() {
        return this.verticalImageAlign;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public JRParagraph getParagraph() {
        return this.paragraph;
    }

    @Override
    public RotationEnum getRotationValue() {
        return JRStyleResolver.getRotationValue(this);
    }

    @Override
    public RotationEnum getOwnRotationValue() {
        return this.rotationValue;
    }

    @Override
    public void setRotation(RotationEnum rotationValue) {
        RotationEnum old = this.rotationValue;
        this.rotationValue = rotationValue;
        this.getEventSupport().firePropertyChange(PROPERTY_ROTATION, old, this.rotationValue);
    }

    @Override
    public LineSpacingEnum getLineSpacingValue() {
        return this.getParagraph().getLineSpacing();
    }

    @Override
    public LineSpacingEnum getOwnLineSpacingValue() {
        return this.getParagraph().getOwnLineSpacing();
    }

    @Override
    public String getMarkup() {
        return JRStyleResolver.getMarkup(this);
    }

    @Override
    public String getOwnMarkup() {
        return this.markup;
    }

    @Override
    public Boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    @Override
    public Boolean isOwnBlankWhenNull() {
        return this.isBlankWhenNull;
    }

    @Override
    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return this.fontName;
    }

    @Override
    public Boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return this.isBold;
    }

    @Override
    public Boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    @Override
    public Boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    @Override
    public Boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    @Override
    public Float getFontsize() {
        return JRStyleResolver.getFontsize(this);
    }

    @Override
    public Float getOwnFontsize() {
        return this.fontsize;
    }

    @Override
    public Integer getFontSize() {
        Float fontSize = this.getFontsize();
        return fontSize == null ? null : Integer.valueOf(fontSize.intValue());
    }

    @Override
    public Integer getOwnFontSize() {
        return this.fontsize == null ? null : Integer.valueOf(this.fontsize.intValue());
    }

    @Override
    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    @Override
    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    @Override
    public Boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    @Override
    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    @Override
    public String getOwnPattern() {
        return this.pattern;
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getModeValue(this);
    }

    @Override
    public ModeEnum getOwnModeValue() {
        return this.modeValue;
    }

    @Override
    public void setForecolor(Color forecolor) {
        Color old = this.forecolor;
        this.forecolor = forecolor;
        this.getEventSupport().firePropertyChange(PROPERTY_FORECOLOR, old, this.forecolor);
    }

    @Override
    public void setBackcolor(Color backcolor) {
        Color old = this.backcolor;
        this.backcolor = backcolor;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKCOLOR, old, this.backcolor);
    }

    @Override
    public void setMode(ModeEnum modeValue) {
        ModeEnum old = this.modeValue;
        this.modeValue = modeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_MODE, old, this.modeValue);
    }

    @Override
    public void setFill(FillEnum fillValue) {
        FillEnum old = this.fillValue;
        this.fillValue = fillValue;
        this.getEventSupport().firePropertyChange(PROPERTY_FILL, old, this.fillValue);
    }

    @Override
    public void setRadius(int radius) {
        this.setRadius((Integer)radius);
    }

    @Override
    public void setRadius(Integer radius) {
        Integer old = this.radius;
        this.radius = radius;
        this.getEventSupport().firePropertyChange(PROPERTY_RADIUS, old, this.radius);
    }

    @Override
    public void setScaleImage(ScaleImageEnum scaleImageValue) {
        ScaleImageEnum old = this.scaleImageValue;
        this.scaleImageValue = scaleImageValue;
        this.getEventSupport().firePropertyChange(PROPERTY_SCALE_IMAGE, old, this.scaleImageValue);
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignmentValue) {
        this.setHorizontalTextAlign(HorizontalAlignEnum.getHorizontalTextAlignEnum(horizontalAlignmentValue));
        this.setHorizontalImageAlign(HorizontalAlignEnum.getHorizontalImageAlignEnum(horizontalAlignmentValue));
    }

    @Override
    public void setVerticalAlignment(VerticalAlignEnum verticalAlignmentValue) {
        this.setVerticalTextAlign(VerticalAlignEnum.getVerticalTextAlignEnum(verticalAlignmentValue));
        this.setVerticalImageAlign(VerticalAlignEnum.getVerticalImageAlignEnum(verticalAlignmentValue));
    }

    @Override
    public void setHorizontalImageAlign(HorizontalImageAlignEnum horizontalImageAlign) {
        HorizontalImageAlignEnum old = this.horizontalImageAlign;
        this.horizontalImageAlign = horizontalImageAlign;
        this.getEventSupport().firePropertyChange(PROPERTY_HORIZONTAL_IMAGE_ALIGNMENT, old, this.horizontalImageAlign);
    }

    @Override
    public void setVerticalImageAlign(VerticalImageAlignEnum verticalImageAlign) {
        VerticalImageAlignEnum old = this.verticalImageAlign;
        this.verticalImageAlign = verticalImageAlign;
        this.getEventSupport().firePropertyChange(PROPERTY_VERTICAL_IMAGE_ALIGNMENT, old, this.verticalImageAlign);
    }

    @Override
    public void setHorizontalTextAlign(HorizontalTextAlignEnum horizontalTextAlign) {
        HorizontalTextAlignEnum old = this.horizontalTextAlign;
        this.horizontalTextAlign = horizontalTextAlign;
        this.getEventSupport().firePropertyChange(PROPERTY_HORIZONTAL_TEXT_ALIGNMENT, old, this.horizontalTextAlign);
    }

    @Override
    public void setVerticalTextAlign(VerticalTextAlignEnum verticalTextAlign) {
        VerticalTextAlignEnum old = this.verticalTextAlign;
        this.verticalTextAlign = verticalTextAlign;
        this.getEventSupport().firePropertyChange(PROPERTY_VERTICAL_TEXT_ALIGNMENT, old, this.verticalTextAlign);
    }

    @Override
    public void setFontName(String fontName) {
        String old = this.fontName;
        this.fontName = fontName;
        this.getEventSupport().firePropertyChange(PROPERTY_FONT_NAME, old, this.fontName);
    }

    @Override
    public void setBold(boolean bold) {
        this.setBold(bold ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBold(Boolean bold) {
        Boolean old = this.isBold;
        this.isBold = bold;
        this.getEventSupport().firePropertyChange(PROPERTY_BOLD, old, this.isBold);
    }

    @Override
    public void setItalic(boolean italic) {
        this.setItalic(italic ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setItalic(Boolean italic) {
        Boolean old = this.isItalic;
        this.isItalic = italic;
        this.getEventSupport().firePropertyChange(PROPERTY_ITALIC, old, this.isItalic);
    }

    @Override
    public void setPdfEmbedded(boolean pdfEmbedded) {
        this.setPdfEmbedded(pdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setPdfEmbedded(Boolean pdfEmbedded) {
        Boolean old = this.isPdfEmbedded;
        this.isPdfEmbedded = pdfEmbedded;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_EMBEDDED, old, this.isPdfEmbedded);
    }

    @Override
    public void setStrikeThrough(boolean strikeThrough) {
        this.setStrikeThrough(strikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setStrikeThrough(Boolean strikeThrough) {
        Boolean old = this.isStrikeThrough;
        this.isStrikeThrough = strikeThrough;
        this.getEventSupport().firePropertyChange(PROPERTY_STRIKE_THROUGH, old, this.isStrikeThrough);
    }

    @Override
    public void setMarkup(String markup) {
        String old = this.markup;
        this.markup = markup;
        this.getEventSupport().firePropertyChange(PROPERTY_MARKUP, old, this.markup);
    }

    @Override
    public void setBlankWhenNull(boolean isBlankWhenNull) {
        this.setBlankWhenNull(isBlankWhenNull ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBlankWhenNull(Boolean isBlankWhenNull) {
        Boolean old = this.isBlankWhenNull;
        this.isBlankWhenNull = isBlankWhenNull;
        this.getEventSupport().firePropertyChange(PROPERTY_BLANK_WHEN_NULL, old, this.isBlankWhenNull);
    }

    @Override
    public void setUnderline(boolean underline) {
        this.setUnderline(underline ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setUnderline(Boolean underline) {
        Boolean old = this.isUnderline;
        this.isUnderline = underline;
        this.getEventSupport().firePropertyChange(PROPERTY_UNDERLINE, old, this.isUnderline);
    }

    @Override
    public void setLineSpacing(LineSpacingEnum lineSpacing) {
        this.getParagraph().setLineSpacing(lineSpacing);
    }

    @Override
    public void setPattern(String pattern) {
        String old = this.pattern;
        this.pattern = pattern;
        this.getEventSupport().firePropertyChange(PROPERTY_PATTERN, old, this.pattern);
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
        String old = this.pdfEncoding;
        this.pdfEncoding = pdfEncoding;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_ENCODING, old, this.pdfEncoding);
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
        String old = this.pdfFontName;
        this.pdfFontName = pdfFontName;
        this.getEventSupport().firePropertyChange(PROPERTY_PDF_FONT_NAME, old, this.pdfFontName);
    }

    @Override
    public void setFontSize(Float fontSize) {
        Float old = this.fontsize;
        this.fontsize = fontSize;
        this.getEventSupport().firePropertyChange(PROPERTY_FONT_SIZE, old, this.fontsize);
    }

    @Override
    public void setFontSize(int fontSize) {
        this.setFontSize(Float.valueOf(fontSize));
    }

    @Override
    public void setFontSize(Integer fontSize) {
        this.setFontSize(fontSize == null ? null : Float.valueOf(fontSize.floatValue()));
    }

    @Override
    public JRConditionalStyle[] getConditionalStyles() {
        return this.conditionalStyles;
    }

    @Override
    public String getStyleNameReference() {
        return this.parentStyleNameReference;
    }

    @Override
    public Float getDefaultLineWidth() {
        return null;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseStyle jRBaseStyle = this;
        synchronized (jRBaseStyle) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.modeValue = ModeEnum.getByValue(this.mode);
            this.horizontalAlignmentValue = HorizontalAlignEnum.getByValue(this.horizontalAlignment);
            this.verticalAlignmentValue = VerticalAlignEnum.getByValue(this.verticalAlignment);
            this.rotationValue = RotationEnum.getByValue(this.rotation);
            this.lineSpacingValue = LineSpacingEnum.getByValue(this.lineSpacing);
            this.scaleImageValue = ScaleImageEnum.getByValue(this.scaleImage);
            this.fillValue = FillEnum.getByValue(this.fill);
            this.mode = null;
            this.horizontalAlignment = null;
            this.verticalAlignment = null;
            this.rotation = null;
            this.lineSpacing = null;
            this.scaleImage = null;
            this.fill = null;
        }
        if (this.linePen == null) {
            this.linePen = new JRBasePen(this);
            JRPenUtil.setLinePenFromPen(this.pen, this.linePen);
            this.pen = null;
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.isStyledText != null) {
            this.markup = this.isStyledText != false ? "styled" : "none";
            this.isStyledText = null;
        }
        if (this.paragraph == null) {
            this.paragraph = new JRBaseParagraph(this);
            this.paragraph.setLineSpacing(this.lineSpacingValue);
            this.lineSpacingValue = null;
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 50502) {
            this.fontsize = this.fontSize == null ? null : Float.valueOf(this.fontSize.floatValue());
            this.fontSize = null;
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 60002) {
            this.horizontalTextAlign = HorizontalAlignEnum.getHorizontalTextAlignEnum(this.horizontalAlignmentValue);
            this.verticalTextAlign = VerticalAlignEnum.getVerticalTextAlignEnum(this.verticalAlignmentValue);
            this.horizontalImageAlign = HorizontalAlignEnum.getHorizontalImageAlignEnum(this.horizontalAlignmentValue);
            this.verticalImageAlign = VerticalAlignEnum.getVerticalImageAlignEnum(this.verticalAlignmentValue);
            this.horizontalAlignmentValue = null;
            this.verticalAlignmentValue = null;
        }
    }

    @Override
    public Object clone() {
        JRBaseStyle clone = null;
        try {
            clone = (JRBaseStyle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.lineBox = this.lineBox == null ? null : this.lineBox.clone(clone);
        clone.linePen = this.linePen == null ? null : this.linePen.clone(clone);
        clone.paragraph = this.paragraph == null ? null : this.paragraph.clone(clone);
        clone.conditionalStyles = (JRConditionalStyle[])JRCloneUtils.cloneArray((JRCloneable[])this.conditionalStyles);
        clone.eventSupport = null;
        return clone;
    }

    @Override
    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        hash.addIdentity(this.parentStyle);
        this.addStyleHash(hash);
        hash.addIdentical(this.conditionalStyles);
        return hash.getHashCode();
    }

    protected void addStyleHash(ObjectUtils.HashCode hash) {
        hash.add(this.name);
        hash.add(this.isDefault);
        hash.add(this.modeValue);
        hash.add(this.forecolor);
        hash.add(this.backcolor);
        hash.addIdentical(this.linePen);
        hash.add(this.fillValue);
        hash.add(this.radius);
        hash.add(this.scaleImageValue);
        hash.add(this.horizontalTextAlign);
        hash.add(this.verticalTextAlign);
        hash.add(this.horizontalImageAlign);
        hash.add(this.verticalImageAlign);
        hash.addIdentical(this.lineBox);
        hash.addIdentical(this.paragraph);
        hash.add(this.fontName);
        hash.add(this.isBold);
        hash.add(this.isItalic);
        hash.add(this.isUnderline);
        hash.add(this.isStrikeThrough);
        hash.add(this.fontsize);
        hash.add(this.pdfFontName);
        hash.add(this.pdfEncoding);
        hash.add(this.isPdfEmbedded);
        hash.add(this.rotationValue);
        hash.add(this.markup);
        hash.add(this.pattern);
        hash.add(this.isBlankWhenNull);
    }

    @Override
    public boolean isIdentical(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRBaseStyle)) {
            return false;
        }
        JRBaseStyle style = (JRBaseStyle)object;
        return ObjectUtils.equalsIdentity(this.parentStyle, style.parentStyle) && this.identicalStyle(style) && ObjectUtils.identical(this.conditionalStyles, style.conditionalStyles);
    }

    protected boolean identicalStyle(JRBaseStyle style) {
        return ObjectUtils.equals(this.name, style.name) && ObjectUtils.equals(this.isDefault, style.isDefault) && ObjectUtils.equals(this.modeValue, style.modeValue) && ObjectUtils.equals(this.forecolor, style.forecolor) && ObjectUtils.equals(this.backcolor, style.backcolor) && ObjectUtils.identical(this.linePen, style.linePen) && ObjectUtils.equals(this.fillValue, style.fillValue) && ObjectUtils.equals(this.radius, style.radius) && ObjectUtils.equals(this.scaleImageValue, style.scaleImageValue) && ObjectUtils.equals(this.horizontalTextAlign, style.horizontalTextAlign) && ObjectUtils.equals(this.verticalTextAlign, style.verticalTextAlign) && ObjectUtils.equals(this.horizontalImageAlign, style.horizontalImageAlign) && ObjectUtils.equals(this.verticalImageAlign, style.verticalImageAlign) && ObjectUtils.identical(this.lineBox, style.lineBox) && ObjectUtils.identical(this.paragraph, style.paragraph) && ObjectUtils.equals(this.fontName, style.fontName) && ObjectUtils.equals(this.isBold, style.isBold) && ObjectUtils.equals(this.isItalic, style.isItalic) && ObjectUtils.equals(this.isUnderline, style.isUnderline) && ObjectUtils.equals(this.isStrikeThrough, style.isStrikeThrough) && ObjectUtils.equals(this.fontsize, style.fontsize) && ObjectUtils.equals(this.pdfFontName, style.pdfFontName) && ObjectUtils.equals(this.pdfEncoding, style.pdfEncoding) && ObjectUtils.equals(this.isPdfEmbedded, style.isPdfEmbedded) && ObjectUtils.equals(this.rotationValue, style.rotationValue) && ObjectUtils.equals(this.markup, style.markup) && ObjectUtils.equals(this.pattern, style.pattern) && ObjectUtils.equals(this.isBlankWhenNull, style.isBlankWhenNull);
    }
}

