/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.TextDataSourceAttributes;
import net.sf.jasperreports.engine.util.FormatUtils;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRDateLocaleConverter;
import net.sf.jasperreports.engine.util.JRFloatLocaleConverter;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConverter;

public abstract class JRAbstractTextDataSource
implements JRDataSource {
    public static final String EXCEPTION_MESSAGE_KEY_CANNOT_CONVERT_FIELD_TYPE = "data.common.cannot.convert.field.type";
    public static final String EXCEPTION_MESSAGE_KEY_CANNOT_MODIFY_PROPERTIES_AFTER_START = "data.common.cannot.modify.properties.after.start";
    public static final String EXCEPTION_MESSAGE_KEY_NODE_NOT_AVAILABLE = "data.common.xml.node.not.available";
    public static final String EXCEPTION_MESSAGE_KEY_NULL_DOCUMENT = "data.common.xml.null.document";
    public static final String EXCEPTION_MESSAGE_KEY_NULL_SELECT_EXPRESSION = "data.common.xml.null.select.expression";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_COLUMN_NAME = "data.common.unknown.column.name";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_NUMBER_TYPE = "data.common.unknown.number.type";
    private LocaleConvertUtilsBean convertBean;
    private TextDataSourceAttributes textAttributes = new TextDataSourceAttributes();

    protected JRAbstractTextDataSource() {
    }

    protected Object convertStringValue(String text, Class<?> valueClass) {
        Object value = null;
        if (String.class.equals(valueClass)) {
            value = text;
        } else if (Number.class.isAssignableFrom(valueClass)) {
            value = this.getConvertBean().convert(text.trim(), valueClass, this.textAttributes.getLocale(), this.textAttributes.getNumberPattern());
        } else if (Date.class.isAssignableFrom(valueClass)) {
            value = this.getConvertBean().convert(text.trim(), valueClass, this.textAttributes.getLocale(), this.textAttributes.getDatePattern());
        } else if (Boolean.class.equals(valueClass)) {
            value = Boolean.valueOf(text);
        }
        return value;
    }

    protected Object convertNumber(Number number, Class<?> valueClass) throws JRException {
        Number value = null;
        if (valueClass.equals(Byte.class)) {
            value = new Byte(number.byteValue());
        } else if (valueClass.equals(Short.class)) {
            value = new Short(number.shortValue());
        } else if (valueClass.equals(Integer.class)) {
            value = number.intValue();
        } else if (valueClass.equals(Long.class)) {
            value = new Long(number.longValue());
        } else if (valueClass.equals(Float.class)) {
            value = new Float(number.floatValue());
        } else if (valueClass.equals(Double.class)) {
            value = new Double(number.doubleValue());
        } else if (valueClass.equals(BigInteger.class)) {
            value = BigInteger.valueOf(number.longValue());
        } else if (valueClass.equals(BigDecimal.class)) {
            value = new BigDecimal(Double.toString(number.doubleValue()));
        } else {
            throw new JRException(EXCEPTION_MESSAGE_KEY_UNKNOWN_NUMBER_TYPE, new Object[]{valueClass.getName()});
        }
        return value;
    }

    protected Number getFormattedNumber(NumberFormat numberFormat, String fieldValue, Class<?> valueClass) throws ParseException {
        return FormatUtils.getFormattedNumber(numberFormat, fieldValue, valueClass);
    }

    protected Date getFormattedDate(DateFormat dateFormat, String fieldValue, Class<?> valueClass) throws ParseException {
        return FormatUtils.getFormattedDate(dateFormat, fieldValue, valueClass);
    }

    protected LocaleConvertUtilsBean getConvertBean() {
        if (this.convertBean == null) {
            this.convertBean = new LocaleConvertUtilsBean();
            Locale locale = this.textAttributes.getLocale();
            if (locale != null) {
                this.convertBean.setDefaultLocale(locale);
                this.convertBean.deregister();
            }
            this.convertBean.register((LocaleConverter)new JRDateLocaleConverter(this.textAttributes.getTimeZone()), Date.class, locale);
            JRFloatLocaleConverter floatConverter = new JRFloatLocaleConverter(locale == null ? Locale.getDefault() : locale);
            this.convertBean.register((LocaleConverter)floatConverter, Float.class, locale);
            this.convertBean.register((LocaleConverter)floatConverter, Float.TYPE, locale);
        }
        return this.convertBean;
    }

    public void setTextAttributes(JRAbstractTextDataSource textDataSource) {
        this.setTextAttributes(textDataSource.getTextAttributes());
    }

    public TextDataSourceAttributes getTextAttributes() {
        return this.textAttributes;
    }

    public void setTextAttributes(TextDataSourceAttributes attributes) {
        this.textAttributes = JRCloneUtils.nullSafeClone(attributes);
    }

    public Locale getLocale() {
        return this.textAttributes.getLocale();
    }

    public void setLocale(Locale locale) {
        this.textAttributes.setLocale(locale);
        this.convertBean = null;
    }

    public void setLocale(String locale) {
        this.textAttributes.setLocale(locale);
        this.convertBean = null;
    }

    public String getDatePattern() {
        return this.textAttributes.getDatePattern();
    }

    public void setDatePattern(String datePattern) {
        this.textAttributes.setDatePattern(datePattern);
        this.convertBean = null;
    }

    public String getNumberPattern() {
        return this.textAttributes.getNumberPattern();
    }

    public void setNumberPattern(String numberPattern) {
        this.textAttributes.setNumberPattern(numberPattern);
        this.convertBean = null;
    }

    public TimeZone getTimeZone() {
        return this.textAttributes.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.textAttributes.setTimeZone(timeZone);
        this.convertBean = null;
    }

    public void setTimeZone(String timeZoneId) {
        this.textAttributes.setTimeZone(timeZoneId);
        this.convertBean = null;
    }
}

