/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.ImageMapRenderable;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.export.AbstractHtmlExporter;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.DefaultHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.export.ElementGridCell;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.Grid;
import net.sf.jasperreports.engine.export.GridRow;
import net.sf.jasperreports.engine.export.HtmlFont;
import net.sf.jasperreports.engine.export.HtmlFontUtil;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHtmlExporterConfiguration;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRHtmlExporterHelper;
import net.sf.jasperreports.engine.export.JRHtmlExporterNature;
import net.sf.jasperreports.engine.export.JRHtmlReportConfiguration;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.HtmlExporterOutput;
import net.sf.jasperreports.export.HtmlReportConfiguration;
import net.sf.jasperreports.export.parameters.ParametersHtmlExporterOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRHtmlExporter
extends AbstractHtmlExporter<JRHtmlReportConfiguration, JRHtmlExporterConfiguration> {
    private static final Log log = LogFactory.getLog(JRHtmlExporter.class);
    protected static final String HTML_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.html.";
    public static final String PROPERTY_IGNORE_HYPERLINK = "net.sf.jasperreports.export.html.ignore.hyperlink";
    public static final String HTML_EXPORTER_KEY = "net.sf.jasperreports.html";
    public static final String PROPERTY_HTML_CLASS = "net.sf.jasperreports.export.html.class";
    public static final String PROPERTY_HTML_ID = "net.sf.jasperreports.export.html.id";
    public static final String PROPERTY_ACCESSIBLE = "net.sf.jasperreports.export.html.accessible";
    protected Writer writer;
    protected Map<String, String> rendererToImagePathMap;
    protected Map<Pair<String, Rectangle>, String> imageMaps;
    protected Map<String, HtmlFont> fontsToProcess;
    protected int reportIndex;
    protected int pageIndex;
    protected StringProvider emptyCellStringProvider;
    private LinkedList<Color> backcolorStack = new LinkedList();
    private Color backcolor;
    protected JRHyperlinkTargetProducerFactory targetProducerFactory;
    protected boolean hyperlinkStarted;
    protected int thDepth;
    protected ExporterNature nature;

    public JRHtmlExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRHtmlExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<JRHtmlExporterConfiguration> getConfigurationInterface() {
        return JRHtmlExporterConfiguration.class;
    }

    @Override
    protected Class<JRHtmlReportConfiguration> getItemConfigurationInterface() {
        return JRHtmlReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersHtmlExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    protected void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
        super.setJasperReportsContext(jasperReportsContext);
        this.targetProducerFactory = new DefaultHyperlinkTargetProducerFactory(jasperReportsContext);
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        this.writer = ((HtmlExporterOutput)this.getExporterOutput()).getWriter();
        try {
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new JRException("export.common.output.writer.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        finally {
            ((HtmlExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
        this.rendererToImagePathMap = new HashMap<String, String>();
        this.imageMaps = new HashMap<Pair<String, Rectangle>, String>();
        this.fontsToProcess = new HashMap<String, HtmlFont>();
        this.emptyCellStringProvider = ((JRHtmlExporterConfiguration)this.getCurrentConfiguration()).isUsingImagesToAlign() != false ? new StringProvider(){

            @Override
            public String getStringForCollapsedTD(int width, int height) {
                HtmlResourceHandler imageHandler = JRHtmlExporter.this.getImageHandler() == null ? ((HtmlExporterOutput)JRHtmlExporter.this.getExporterOutput()).getImageHandler() : JRHtmlExporter.this.getImageHandler();
                String pxUri = imageHandler == null ? null : imageHandler.getResourcePath("px");
                return "><img alt=\"\" src=\"" + pxUri + "\" style=\"width: " + JRHtmlExporter.this.toSizeUnit(width) + "; height: " + JRHtmlExporter.this.toSizeUnit(height) + ";\"/>";
            }

            @Override
            public String getStringForEmptyTD() {
                HtmlResourceHandler imageHandler = JRHtmlExporter.this.getImageHandler() == null ? ((HtmlExporterOutput)JRHtmlExporter.this.getExporterOutput()).getImageHandler() : JRHtmlExporter.this.getImageHandler();
                String pxUri = imageHandler == null ? null : imageHandler.getResourcePath("px");
                return "<img alt=\"\" src=\"" + pxUri + "\" border=\"0\"/>";
            }

            @Override
            public String getReportTableStyle() {
                return null;
            }
        } : new StringProvider(){

            @Override
            public String getStringForCollapsedTD(int width, int height) {
                return " style=\"width: " + JRHtmlExporter.this.toSizeUnit(width) + "; height: " + JRHtmlExporter.this.toSizeUnit(height) + ";\">";
            }

            @Override
            public String getStringForEmptyTD() {
                return "";
            }

            @Override
            public String getReportTableStyle() {
                return "empty-cells: show";
            }
        };
    }

    @Override
    protected void initReport() {
        super.initReport();
        JRHtmlReportConfiguration configuration = (JRHtmlReportConfiguration)this.getCurrentItemConfiguration();
        this.nature = new JRHtmlExporterNature(this.jasperReportsContext, this.filter, configuration.isFramesAsNestedTables() == false, configuration.isIgnorePageMargins());
    }

    protected void exportReportToWriter() throws JRException, IOException {
        JRHtmlExporterConfiguration configuration = (JRHtmlExporterConfiguration)this.getCurrentConfiguration();
        if (configuration.isUsingImagesToAlign().booleanValue()) {
            this.loadPxImage();
        }
        String htmlHeader = configuration.getHtmlHeader();
        String betweenPagesHtml = configuration.getBetweenPagesHtml();
        String htmlFooter = configuration.getHtmlFooter();
        boolean flushOutput = configuration.isFlushOutput();
        if (htmlHeader == null) {
            String encoding = ((HtmlExporterOutput)this.getExporterOutput()).getEncoding();
            this.writer.write("<html>\n");
            this.writer.write("<head>\n");
            this.writer.write("  <title></title>\n");
            this.writer.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\"/>\n");
            this.writer.write("  <style type=\"text/css\">\n");
            this.writer.write("    a {text-decoration: none}\n");
            this.writer.write("  </style>\n");
            this.writer.write("</head>\n");
            this.writer.write("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.writer.write("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.writer.write("\n");
        } else {
            this.writer.write(htmlHeader);
        }
        List<ExporterInputItem> items = this.exporterInput.getItems();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                JRPrintPage page = null;
                this.pageIndex = startPageIndex;
                while (this.pageIndex <= endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new ExportInterruptedException();
                    }
                    page = pages.get(this.pageIndex);
                    this.writer.write("<a name=\"JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (this.pageIndex + 1) + "\"></a>\n");
                    this.exportPage(page);
                    if (this.reportIndex < items.size() - 1 || this.pageIndex < endPageIndex) {
                        if (betweenPagesHtml == null) {
                            this.writer.write("<br/>\n<br/>\n");
                        } else {
                            this.writer.write(betweenPagesHtml);
                        }
                    }
                    this.writer.write("\n");
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        if (this.fontsToProcess != null && this.fontsToProcess.size() > 0) {
            HtmlResourceHandler fontHandler = ((HtmlExporterOutput)this.getExporterOutput()).getFontHandler() == null ? this.getFontHandler() : ((HtmlExporterOutput)this.getExporterOutput()).getFontHandler();
            for (HtmlFont htmlFont : this.fontsToProcess.values()) {
                this.writer.write("<link class=\"jrWebFont\" rel=\"stylesheet\" href=\"" + fontHandler.getResourcePath(htmlFont.getId()) + "\">\n");
            }
        }
        this.writer.write("<![if IE]>\n");
        this.writer.write("<script>\n");
        this.writer.write("var links = document.querySelectorAll('link.jrWebFont');\n");
        this.writer.write("setTimeout(function(){ if (links) { for (var i = 0; i < links.length; i++) { links.item(i).href = links.item(i).href; } } }, 0);\n");
        this.writer.write("</script>\n");
        this.writer.write("<![endif]>\n");
        if (htmlFooter == null) {
            this.writer.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.writer.write("</table>\n");
            this.writer.write("</body>\n");
            this.writer.write("</html>\n");
        } else {
            this.writer.write(htmlFooter);
        }
        if (flushOutput) {
            this.writer.flush();
        }
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        List<JRPrintElement> elements = null;
        JRHtmlReportConfiguration configuration = (JRHtmlReportConfiguration)this.getCurrentItemConfiguration();
        if (configuration.isAccessibleHtml().booleanValue()) {
            JRBasePrintFrame frame = new JRBasePrintFrame(this.jasperPrint.getDefaultStyleProvider());
            new JRHtmlExporterHelper(this.jasperPrint).createNestedFrames(page.getElements().listIterator(), frame);
            elements = frame.getElements();
        } else {
            elements = page.getElements();
        }
        PrintPageFormat pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
        JRGridLayout layout = new JRGridLayout(this.nature, elements, (int)pageFormat.getPageWidth(), (int)pageFormat.getPageHeight(), configuration.getOffsetX() == null ? 0 : configuration.getOffsetX(), configuration.getOffsetY() == null ? 0 : configuration.getOffsetY(), null);
        this.exportGrid(layout, configuration.isWhitePageBackground());
        JRExportProgressMonitor progressMonitor = configuration.getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportGrid(JRGridLayout gridLayout, boolean whitePageBackground) throws IOException, JRException {
        CutsInfo xCuts = gridLayout.getXCuts();
        Grid grid = gridLayout.getGrid();
        String tableStyle = "width: " + this.toSizeUnit(gridLayout.getWidth()) + "; border-collapse: collapse";
        String additionalTableStyle = this.emptyCellStringProvider.getReportTableStyle();
        if (additionalTableStyle != null) {
            tableStyle = tableStyle + "; " + additionalTableStyle;
        }
        this.writer.write("<table style=\"" + tableStyle + "\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"");
        if (whitePageBackground) {
            this.writer.write(" bgcolor=\"white\"");
        }
        this.writer.write(">\n");
        if (whitePageBackground) {
            this.setBackcolor(Color.white);
        }
        this.writer.write("<tr>\n");
        int width = 0;
        for (int i = 1; i < xCuts.size(); ++i) {
            width = xCuts.getCutOffset(i) - xCuts.getCutOffset(i - 1);
            this.writer.write("  <td" + this.emptyCellStringProvider.getStringForCollapsedTD(width, 1) + "</td>\n");
        }
        this.writer.write("</tr>\n");
        boolean isRemoveEmptySpaceBetweenRows = ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isRemoveEmptySpaceBetweenRows();
        CutsInfo yCuts = gridLayout.getYCuts();
        this.thDepth = 0;
        int rowCount = grid.getRowCount();
        for (int y = 0; y < rowCount; ++y) {
            Cut yCut = yCuts.getCut(y);
            if (!yCut.isCutSpanned() && isRemoveEmptySpaceBetweenRows) continue;
            GridRow gridRow = grid.getRow(y);
            int rowHeight = JRGridLayout.getRowHeight(gridRow);
            boolean hasEmptyCell = this.hasEmptyCell(gridRow);
            this.writer.write("<tr valign=\"top\"");
            if (!hasEmptyCell) {
                this.writer.write(" style=\"height:" + this.toSizeUnit(rowHeight) + "\"");
            }
            this.writer.write(">\n");
            int rowSize = gridRow.size();
            for (int x = 0; x < rowSize; ++x) {
                JRExporterGridCell gridCell = gridRow.get(x);
                if (gridCell.getType() == 1) {
                    this.writeEmptyCell(gridCell, rowHeight);
                } else {
                    JRPrintElement element = gridCell.getElement();
                    String thTag = null;
                    if (element != null && element.hasProperties()) {
                        thTag = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.pdf.tag.th");
                    }
                    if (thTag != null && ("start".equals(thTag) || "full".equals(thTag))) {
                        ++this.thDepth;
                    }
                    if (element instanceof JRPrintLine) {
                        this.exportLine((JRPrintLine)element, gridCell);
                    } else if (element instanceof JRPrintRectangle) {
                        this.exportRectangle((JRPrintRectangle)element, gridCell);
                    } else if (element instanceof JRPrintEllipse) {
                        this.exportRectangle((JRPrintEllipse)element, gridCell);
                    } else if (element instanceof JRPrintImage) {
                        this.exportImage((JRPrintImage)element, gridCell);
                    } else if (element instanceof JRPrintText) {
                        this.exportText((JRPrintText)element, gridCell);
                    } else if (element instanceof JRPrintFrame) {
                        this.exportFrame((JRPrintFrame)element, gridCell);
                    } else if (element instanceof JRGenericPrintElement) {
                        this.exportGenericElement((JRGenericPrintElement)element, gridCell, rowHeight);
                    }
                    if (thTag != null && ("end".equals(thTag) || "full".equals(thTag))) {
                        --this.thDepth;
                    }
                }
                x += gridCell.getColSpan() - 1;
            }
            this.writer.write("</tr>\n");
        }
        if (whitePageBackground) {
            this.restoreBackcolor();
        }
        this.writer.write("</table>\n");
    }

    private boolean hasEmptyCell(GridRow gridRow) {
        if (gridRow.get(0).getType() == 1) {
            return true;
        }
        boolean hasEmptyCell = false;
        int rowSize = gridRow.size();
        for (int x = 1; x < rowSize; ++x) {
            if (gridRow.get(x).getType() != 1) continue;
            hasEmptyCell = true;
            break;
        }
        return hasEmptyCell;
    }

    protected void writeEmptyCell(JRExporterGridCell cell, int rowHeight) throws IOException {
        String cellTag = this.getCellTag(cell);
        this.writer.write("  <" + cellTag);
        if (cell.getColSpan() > 1) {
            this.writer.write(" colspan=\"" + cell.getColSpan() + "\"");
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.appendBackcolorStyle(cell, styleBuffer);
        this.appendBorderStyle(cell.getBox(), styleBuffer);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(this.emptyCellStringProvider.getStringForCollapsedTD(cell.getWidth(), rowHeight));
        this.writer.write("</" + cellTag + ">\n");
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell) throws IOException {
        this.writeCellStart(gridCell);
        StringBuffer styleBuffer = new StringBuffer();
        this.appendBackcolorStyle(gridCell, styleBuffer);
        String side = null;
        float ratio = line.getWidth() / line.getHeight();
        side = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? "top" : "bottom") : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? "left" : "right");
        this.appendPen(styleBuffer, line.getLinePen(), side);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD());
        this.writeCellEnd(gridCell);
    }

    protected void writeCellStart(JRExporterGridCell gridCell) throws IOException {
        JRPrintElement element;
        this.writer.write("  <" + this.getCellTag(gridCell));
        if (gridCell.getColSpan() > 1) {
            this.writer.write(" colspan=\"" + gridCell.getColSpan() + "\"");
        }
        if (gridCell.getRowSpan() > 1) {
            this.writer.write(" rowspan=\"" + gridCell.getRowSpan() + "\"");
        }
        if ((element = gridCell.getElement()) != null) {
            String clazz;
            String id = this.getPropertiesUtil().getProperty(element, PROPERTY_HTML_ID);
            if (id != null) {
                this.writer.write(" id=\"" + id + "\"");
            }
            if ((clazz = this.getPropertiesUtil().getProperty(element, PROPERTY_HTML_CLASS)) != null) {
                this.writer.write(" class=\"" + clazz + "\"");
            }
        }
    }

    protected void writeCellEnd(JRExporterGridCell gridCell) throws IOException {
        this.writer.write("</" + this.getCellTag(gridCell) + ">\n");
    }

    protected String getCellTag(JRExporterGridCell gridCell) {
        boolean accessibleHtml = ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isAccessibleHtml();
        if (accessibleHtml) {
            if (this.thDepth > 0) {
                return "th";
            }
            String cellContentsType = gridCell.getProperty("net.sf.jasperreports.crosstab.cell.type");
            if ("CrosstabHeader".equals(cellContentsType) || "ColumnHeader".equals(cellContentsType) || "RowHeader".equals(cellContentsType)) {
                return "th";
            }
        }
        return "td";
    }

    protected void exportRectangle(JRPrintGraphicElement element, JRExporterGridCell gridCell) throws IOException {
        this.writeCellStart(gridCell);
        StringBuffer styleBuffer = new StringBuffer();
        this.appendBackcolorStyle(gridCell, styleBuffer);
        this.appendPen(styleBuffer, element.getLinePen(), null);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD());
        this.writeCellEnd(gridCell);
    }

    protected void exportStyledText(JRPrintText printText, JRStyledText styledText, String tooltip) throws IOException {
        Locale locale = this.getTextLocale(printText);
        LineSpacingEnum lineSpacing = printText.getParagraph().getLineSpacing();
        Float lineSpacingSize = printText.getParagraph().getLineSpacingSize();
        float lineSpacingFactor = printText.getLineSpacingFactor();
        Color backcolor = printText.getBackcolor();
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        boolean first = true;
        boolean startedSpan = false;
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            if (first && runLimit < styledText.length() && tooltip != null) {
                startedSpan = true;
                this.writer.write("<span title=\"");
                this.writer.write(JRStringUtil.xmlEncode(tooltip));
                this.writer.write("\">");
                tooltip = null;
            }
            first = false;
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), tooltip, locale, lineSpacing, lineSpacingSize, lineSpacingFactor, backcolor);
            iterator.setIndex(runLimit);
        }
        if (startedSpan) {
            this.writer.write("</span>");
        }
    }

    protected void exportStyledTextRun(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, String tooltip, Locale locale, LineSpacingEnum lineSpacing, Float lineSpacingSize, float lineSpacingFactor, Color backcolor) throws IOException {
        Color runBackcolor;
        String fontFamilyAttr;
        boolean isBold = TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT));
        boolean isItalic = TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE));
        String fontFamily = fontFamilyAttr = (String)attributes.get(TextAttribute.FAMILY);
        FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(fontFamilyAttr, locale);
        if (fontInfo != null) {
            FontFamily family = fontInfo.getFontFamily();
            String exportFont = family.getExportFont(this.getExporterKey());
            if (exportFont == null) {
                HtmlFont htmlFont;
                HtmlResourceHandler resourceHandler;
                HtmlResourceHandler fontHandler = ((HtmlExporterOutput)this.getExporterOutput()).getFontHandler() == null ? this.getFontHandler() : ((HtmlExporterOutput)this.getExporterOutput()).getFontHandler();
                HtmlResourceHandler htmlResourceHandler = resourceHandler = ((HtmlExporterOutput)this.getExporterOutput()).getResourceHandler() == null ? this.getResourceHandler() : ((HtmlExporterOutput)this.getExporterOutput()).getResourceHandler();
                if (fontHandler != null && resourceHandler != null && (htmlFont = HtmlFont.getInstance(locale, fontInfo, isBold, isItalic)) != null) {
                    if (!this.fontsToProcess.containsKey(htmlFont.getId())) {
                        this.fontsToProcess.put(htmlFont.getId(), htmlFont);
                        HtmlFontUtil.handleFont(resourceHandler, htmlFont);
                    }
                    fontFamily = htmlFont.getId();
                }
            } else {
                fontFamily = exportFont;
            }
        }
        boolean localHyperlink = false;
        JRPrintHyperlink hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK);
        if (!this.hyperlinkStarted && hyperlink != null) {
            this.startHyperlink(hyperlink);
            localHyperlink = true;
        }
        this.writer.write("<span style=\"font-family: ");
        this.writer.write(fontFamily);
        this.writer.write("; ");
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        if (!this.hyperlinkStarted || !Color.black.equals(forecolor)) {
            this.writer.write("color: ");
            this.writer.write(JRColorUtil.getCssColor(forecolor));
            this.writer.write("; ");
        }
        if ((runBackcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null && !runBackcolor.equals(backcolor)) {
            this.writer.write("background-color: ");
            this.writer.write(JRColorUtil.getCssColor(runBackcolor));
            this.writer.write("; ");
        }
        this.writer.write("font-size: ");
        this.writer.write(this.toSizeUnit(((Float)attributes.get(TextAttribute.SIZE)).floatValue()));
        this.writer.write(";");
        switch (lineSpacing) {
            default: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 1; *line-height: normal;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case ONE_AND_HALF: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 1.5;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case DOUBLE: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 2.0;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case PROPORTIONAL: {
                if (lineSpacingSize == null) break;
                this.writer.write(" line-height: " + lineSpacingSize.floatValue() + ";");
                break;
            }
            case AT_LEAST: 
            case FIXED: {
                if (lineSpacingSize == null) break;
                this.writer.write(" line-height: " + lineSpacingSize.floatValue() + "px;");
            }
        }
        if (isBold) {
            this.writer.write(" font-weight: bold;");
        }
        if (isItalic) {
            this.writer.write(" font-style: italic;");
        }
        if (TextAttribute.UNDERLINE_ON.equals(attributes.get(TextAttribute.UNDERLINE))) {
            this.writer.write(" text-decoration: underline;");
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(attributes.get(TextAttribute.STRIKETHROUGH))) {
            this.writer.write(" text-decoration: line-through;");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: super;");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: sub;");
        }
        this.writer.write("\"");
        if (tooltip != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(tooltip));
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(JRStringUtil.htmlEncode(text));
        this.writer.write("</span>");
        if (localHyperlink) {
            this.endHyperlink();
        }
    }

    protected void exportText(JRPrintText text, JRExporterGridCell gridCell) throws IOException {
        boolean isWrapBreakWord;
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        this.writeCellStart(gridCell);
        if (text.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.writer.write(" dir=\"rtl\"");
        }
        StringBuffer styleBuffer = new StringBuffer();
        String verticalAlignment = "top";
        switch (text.getVerticalTextAlign()) {
            case BOTTOM: {
                verticalAlignment = "bottom";
                break;
            }
            case MIDDLE: {
                verticalAlignment = "middle";
                break;
            }
            default: {
                verticalAlignment = "top";
            }
        }
        if (!verticalAlignment.equals("top")) {
            styleBuffer.append(" vertical-align: ");
            styleBuffer.append(verticalAlignment);
            styleBuffer.append(";");
        }
        this.appendBackcolorStyle(gridCell, styleBuffer);
        this.appendBorderStyle(gridCell.getBox(), styleBuffer);
        this.appendPaddingStyle(text.getLineBox(), styleBuffer);
        String horizontalAlignment = "left";
        if (textLength > 0) {
            switch (text.getHorizontalTextAlign()) {
                case RIGHT: {
                    horizontalAlignment = "right";
                    break;
                }
                case CENTER: {
                    horizontalAlignment = "center";
                    break;
                }
                case JUSTIFIED: {
                    horizontalAlignment = "justify";
                    break;
                }
                default: {
                    horizontalAlignment = "left";
                }
            }
            if (text.getRunDirectionValue() == RunDirectionEnum.LTR && !horizontalAlignment.equals("left") || text.getRunDirectionValue() == RunDirectionEnum.RTL && !horizontalAlignment.equals("right")) {
                styleBuffer.append("text-align: ");
                styleBuffer.append(horizontalAlignment);
                styleBuffer.append(";");
            }
        }
        if (isWrapBreakWord = ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isWrapBreakWord().booleanValue()) {
            styleBuffer.append("width: " + this.toSizeUnit(gridCell.getWidth()) + "; ");
            styleBuffer.append("word-wrap: break-word; ");
        }
        if (text.getLineBreakOffsets() != null) {
            styleBuffer.append("white-space: nowrap; ");
        }
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write("<p style=\"overflow: hidden; ");
        this.writer.write("text-indent: " + text.getParagraph().getFirstLineIndent() + "px; ");
        this.writer.write("\">");
        if (text.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(text.getAnchorName());
            this.writer.write("\"/>");
        }
        this.startHyperlink(text);
        if (textLength > 0) {
            this.exportStyledText(text, styledText, text.getHyperlinkTooltip());
        } else {
            this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD());
        }
        this.endHyperlink();
        this.writer.write("</p>");
        this.writeCellEnd(gridCell);
    }

    protected boolean startHyperlink(JRPrintHyperlink link) throws IOException {
        String href = this.getHyperlinkURL(link);
        if (href != null) {
            this.writer.write("<a href=\"");
            this.writer.write(href);
            this.writer.write("\"");
            String target = this.getHyperlinkTarget(link);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
            if (link.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(link.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write(">");
        }
        this.hyperlinkStarted = href != null;
        return this.hyperlinkStarted;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target;
        block10: {
            JRHyperlinkTargetProducer producer;
            block9: {
                target = null;
                producer = this.targetProducerFactory.getHyperlinkTargetProducer(link.getLinkTarget());
                if (producer != null) break block9;
                switch (link.getHyperlinkTargetValue()) {
                    case BLANK: {
                        target = "_blank";
                        break;
                    }
                    case PARENT: {
                        target = "_parent";
                        break;
                    }
                    case TOP: {
                        target = "_top";
                        break;
                    }
                    case CUSTOM: {
                        List<JRPrintHyperlinkParameter> parameters;
                        boolean paramFound = false;
                        List<JRPrintHyperlinkParameter> list = parameters = link.getHyperlinkParameters() == null ? null : link.getHyperlinkParameters().getParameters();
                        if (parameters != null) {
                            for (JRPrintHyperlinkParameter parameter : parameters) {
                                if (!link.getLinkTarget().equals(parameter.getName())) continue;
                                target = parameter.getValue() == null ? null : parameter.getValue().toString();
                                paramFound = true;
                                break;
                            }
                        }
                        if (!paramFound) {
                            target = link.getLinkTarget();
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block10;
            }
            target = producer.getHyperlinkTarget(link);
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block14: {
                href = null;
                Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(PROPERTY_IGNORE_HYPERLINK, link);
                if (ignoreHyperlink == null) {
                    ignoreHyperlink = this.getPropertiesUtil().getBooleanProperty(this.jasperPrint, PROPERTY_IGNORE_HYPERLINK, false);
                }
                if (ignoreHyperlink.booleanValue()) break block13;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block14;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + "JR_PAGE_ANCHOR_" + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected void endHyperlink() throws IOException {
        if (this.hyperlinkStarted) {
            this.writer.write("</a>");
        }
        this.hyperlinkStarted = false;
    }

    protected boolean appendBorderStyle(JRLineBox box, StringBuffer styleBuffer) {
        boolean addedToStyle = false;
        if (box != null) {
            LineStyleEnum tps = box.getTopPen().getLineStyleValue();
            LineStyleEnum lps = box.getLeftPen().getLineStyleValue();
            LineStyleEnum bps = box.getBottomPen().getLineStyleValue();
            LineStyleEnum rps = box.getRightPen().getLineStyleValue();
            float tpw = box.getTopPen().getLineWidth().floatValue();
            float lpw = box.getLeftPen().getLineWidth().floatValue();
            float bpw = box.getBottomPen().getLineWidth().floatValue();
            float rpw = box.getRightPen().getLineWidth().floatValue();
            if (0.0f < tpw && tpw < 1.0f) {
                tpw = 1.0f;
            }
            if (0.0f < lpw && lpw < 1.0f) {
                lpw = 1.0f;
            }
            if (0.0f < bpw && bpw < 1.0f) {
                bpw = 1.0f;
            }
            if (0.0f < rpw && rpw < 1.0f) {
                rpw = 1.0f;
            }
            Color tpc = box.getTopPen().getLineColor();
            if (tps == lps && tps == bps && tps == rps && tpw == lpw && tpw == bpw && tpw == rpw && tpc.equals(box.getLeftPen().getLineColor()) && tpc.equals(box.getBottomPen().getLineColor()) && tpc.equals(box.getRightPen().getLineColor())) {
                addedToStyle |= this.appendPen(styleBuffer, box.getTopPen(), null);
            } else {
                addedToStyle |= this.appendPen(styleBuffer, box.getTopPen(), "top");
                addedToStyle |= this.appendPen(styleBuffer, box.getLeftPen(), "left");
                addedToStyle |= this.appendPen(styleBuffer, box.getBottomPen(), "bottom");
                addedToStyle |= this.appendPen(styleBuffer, box.getRightPen(), "right");
            }
        }
        return addedToStyle;
    }

    protected boolean appendPaddingStyle(JRLineBox box, StringBuffer styleBuffer) {
        boolean addedToStyle = false;
        if (box != null) {
            Integer tp = box.getTopPadding();
            Integer lp = box.getLeftPadding();
            Integer bp = box.getBottomPadding();
            Integer rp = box.getRightPadding();
            if (tp == lp && tp == bp && tp == rp) {
                addedToStyle |= this.appendPadding(styleBuffer, tp, null);
            } else {
                addedToStyle |= this.appendPadding(styleBuffer, box.getTopPadding(), "top");
                addedToStyle |= this.appendPadding(styleBuffer, box.getLeftPadding(), "left");
                addedToStyle |= this.appendPadding(styleBuffer, box.getBottomPadding(), "bottom");
                addedToStyle |= this.appendPadding(styleBuffer, box.getRightPadding(), "right");
            }
        }
        return addedToStyle;
    }

    protected Color appendBackcolorStyle(JRExporterGridCell gridCell, StringBuffer styleBuffer) {
        Color cellBackcolor = gridCell.getCellBackcolor();
        if (cellBackcolor != null && (this.backcolor == null || cellBackcolor.getRGB() != this.backcolor.getRGB())) {
            styleBuffer.append("background-color: ");
            styleBuffer.append(JRColorUtil.getCssColor(cellBackcolor));
            styleBuffer.append("; ");
            return cellBackcolor;
        }
        return null;
    }

    protected void exportImage(JRPrintImage image, JRExporterGridCell gridCell) throws JRException, IOException {
        Renderable renderer;
        this.writeCellStart(gridCell);
        StringBuffer styleBuffer = new StringBuffer();
        String horizontalAlignment = "left";
        switch (image.getHorizontalImageAlign()) {
            case RIGHT: {
                horizontalAlignment = "right";
                break;
            }
            case CENTER: {
                horizontalAlignment = "center";
                break;
            }
            default: {
                horizontalAlignment = "left";
            }
        }
        if (!horizontalAlignment.equals("left")) {
            styleBuffer.append("text-align: ");
            styleBuffer.append(horizontalAlignment);
            styleBuffer.append(";");
        }
        String verticalAlignment = "top";
        switch (image.getVerticalImageAlign()) {
            case BOTTOM: {
                verticalAlignment = "bottom";
                break;
            }
            case MIDDLE: {
                verticalAlignment = "middle";
                break;
            }
            default: {
                verticalAlignment = "top";
            }
        }
        if (!verticalAlignment.equals("top")) {
            styleBuffer.append(" vertical-align: ");
            styleBuffer.append(verticalAlignment);
            styleBuffer.append(";");
        }
        this.appendBackcolorStyle(gridCell, styleBuffer);
        boolean addedToStyle = this.appendBorderStyle(gridCell.getBox(), styleBuffer);
        if (!addedToStyle) {
            this.appendPen(styleBuffer, image.getLinePen(), null);
        }
        this.appendPaddingStyle(image.getLineBox(), styleBuffer);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (image.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(image.getAnchorName());
            this.writer.write("\"/>");
        }
        Renderable originalRenderer = renderer = image.getRenderable();
        boolean imageMapRenderer = renderer != null && renderer instanceof ImageMapRenderable && ((ImageMapRenderable)renderer).hasImageAreaHyperlinks();
        boolean hasHyperlinks = false;
        boolean isUsingImagesToAlign = ((JRHtmlExporterConfiguration)this.getCurrentConfiguration()).isUsingImagesToAlign();
        if (renderer != null || isUsingImagesToAlign) {
            int imageHeight;
            HtmlResourceHandler imageHandler;
            if (imageMapRenderer) {
                hasHyperlinks = true;
                this.hyperlinkStarted = false;
            } else {
                hasHyperlinks = this.startHyperlink(image);
            }
            this.writer.write("<img");
            String imagePath = null;
            String imageMapName = null;
            List<JRPrintImageAreaHyperlink> imageMapAreas = null;
            ScaleImageEnum scaleImage = image.getScaleImageValue();
            if (renderer != null) {
                if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                    imagePath = this.rendererToImagePathMap.get(renderer.getId());
                } else {
                    if (image.isLazy()) {
                        imagePath = ((JRImageRenderer)renderer).getImageLocation();
                    } else {
                        HtmlResourceHandler htmlResourceHandler = imageHandler = this.getImageHandler() == null ? ((HtmlExporterOutput)this.getExporterOutput()).getImageHandler() : this.getImageHandler();
                        if (imageHandler != null) {
                            JRPrintElementIndex imageIndex = this.getElementIndex(gridCell);
                            String imageName = JRHtmlExporter.getImageName(imageIndex);
                            if (renderer.getTypeValue() == RenderableTypeEnum.SVG) {
                                renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                            }
                            byte[] imageData = renderer.getImageData(this.jasperReportsContext);
                            if (imageHandler != null) {
                                imageHandler.handleResource(imageName, imageData);
                                imagePath = imageHandler.getResourcePath(imageName);
                            }
                        }
                    }
                    this.rendererToImagePathMap.put(renderer.getId(), imagePath);
                }
                if (imageMapRenderer) {
                    Rectangle renderingArea = new Rectangle(image.getWidth(), image.getHeight());
                    if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                        imageMapName = this.imageMaps.get(new Pair<String, Rectangle>(renderer.getId(), renderingArea));
                    }
                    if (imageMapName == null) {
                        imageMapName = "map_" + this.getElementIndex(gridCell).toString();
                        imageMapAreas = ((ImageMapRenderable)originalRenderer).getImageAreaHyperlinks(renderingArea);
                        if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                            this.imageMaps.put(new Pair<String, Rectangle>(renderer.getId(), renderingArea), imageMapName);
                        }
                    }
                }
            } else {
                imageHandler = ((HtmlExporterOutput)this.getExporterOutput()).getImageHandler();
                imagePath = imageHandler == null ? null : imageHandler.getResourcePath("px");
                scaleImage = ScaleImageEnum.FILL_FRAME;
            }
            this.writer.write(" src=\"");
            if (imagePath != null) {
                this.writer.write(imagePath);
            }
            this.writer.write("\"");
            int imageWidth = image.getWidth() - image.getLineBox().getLeftPadding() - image.getLineBox().getRightPadding();
            if (imageWidth < 0) {
                imageWidth = 0;
            }
            if ((imageHeight = image.getHeight() - image.getLineBox().getTopPadding() - image.getLineBox().getBottomPadding()) < 0) {
                imageHeight = 0;
            }
            switch (scaleImage) {
                case FILL_FRAME: {
                    this.writer.write(" style=\"width: ");
                    this.writer.write(this.toSizeUnit(imageWidth));
                    this.writer.write("; height: ");
                    this.writer.write(this.toSizeUnit(imageHeight));
                    this.writer.write("\"");
                    break;
                }
                default: {
                    double normalWidth = imageWidth;
                    double normalHeight = imageHeight;
                    if (!image.isLazy()) {
                        Dimension2D dimension;
                        Renderable tmpRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(renderer, image.getOnErrorTypeValue());
                        Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension(this.jasperReportsContext);
                        if (tmpRenderer == renderer && dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                    }
                    if (imageHeight <= 0) break;
                    double ratio = normalWidth / normalHeight;
                    if (ratio > (double)imageWidth / (double)imageHeight) {
                        this.writer.write(" style=\"width: ");
                        this.writer.write(this.toSizeUnit(imageWidth));
                        this.writer.write("\"");
                        break;
                    }
                    this.writer.write(" style=\"height: ");
                    this.writer.write(this.toSizeUnit(imageHeight));
                    this.writer.write("\"");
                }
            }
            if (imageMapName != null) {
                this.writer.write(" usemap=\"#" + imageMapName + "\"");
            }
            this.writer.write(" alt=\"\"");
            if (hasHyperlinks) {
                this.writer.write(" border=\"0\"");
            }
            if (image.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(image.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write("/>");
            this.endHyperlink();
            if (imageMapAreas != null) {
                this.writer.write("\n");
                this.writeImageMap(imageMapName, image, imageMapAreas);
            }
        }
        this.writeCellEnd(gridCell);
    }

    protected JRPrintElementIndex getElementIndex(JRExporterGridCell gridCell) {
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getElementAddress());
        return imageIndex;
    }

    protected void writeImageMap(String imageMapName, JRPrintImage image, List<JRPrintImageAreaHyperlink> imageMapAreas) throws IOException {
        this.writer.write("<map name=\"" + imageMapName + "\">\n");
        ListIterator<JRPrintImageAreaHyperlink> it = imageMapAreas.listIterator(imageMapAreas.size());
        while (it.hasPrevious()) {
            JRPrintImageAreaHyperlink areaHyperlink = it.previous();
            JRPrintImageArea area = areaHyperlink.getArea();
            this.writer.write("  <area shape=\"" + JRPrintImageArea.getHtmlShape(area.getShape()) + "\"");
            this.writeImageAreaCoordinates(area.getCoordinates());
            this.writeImageAreaHyperlink(areaHyperlink.getHyperlink());
            this.writer.write("/>\n");
        }
        if (image.getHyperlinkTypeValue() != HyperlinkTypeEnum.NONE) {
            this.writer.write("  <area shape=\"default\"");
            this.writeImageAreaCoordinates(new int[]{0, 0, image.getWidth(), image.getHeight()});
            this.writeImageAreaHyperlink(image);
            this.writer.write("/>\n");
        }
        this.writer.write("</map>\n");
    }

    protected void writeImageAreaCoordinates(int[] coords) throws IOException {
        if (coords != null && coords.length > 0) {
            StringBuffer coordsEnum = new StringBuffer(coords.length * 4);
            coordsEnum.append(this.toZoom(coords[0]));
            for (int i = 1; i < coords.length; ++i) {
                coordsEnum.append(',');
                coordsEnum.append(this.toZoom(coords[i]));
            }
            this.writer.write(" coords=\"" + coordsEnum + "\"");
        }
    }

    protected void writeImageAreaHyperlink(JRPrintHyperlink hyperlink) throws IOException {
        String href = this.getHyperlinkURL(hyperlink);
        if (href == null) {
            this.writer.write(" nohref=\"nohref\"");
        } else {
            this.writer.write(" href=\"" + href + "\"");
            String target = this.getHyperlinkTarget(hyperlink);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
        }
        if (hyperlink.getHyperlinkTooltip() != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(hyperlink.getHyperlinkTooltip()));
            this.writer.write("\"");
        }
    }

    protected void loadPxImage() throws JRException {
        HtmlResourceHandler imageHandler;
        Renderable pxRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getRenderable("net/sf/jasperreports/engine/images/pixel.GIF");
        String imageName = "px";
        String imagePath = null;
        HtmlResourceHandler htmlResourceHandler = imageHandler = this.getImageHandler() == null ? ((HtmlExporterOutput)this.getExporterOutput()).getImageHandler() : this.getImageHandler();
        if (imageHandler != null) {
            byte[] imageData = pxRenderer.getImageData(this.jasperReportsContext);
            if (imageHandler != null) {
                imageHandler.handleResource(imageName, imageData);
                imagePath = imageHandler.getResourcePath(imageName);
            }
        }
        this.rendererToImagePathMap.put(pxRenderer.getId(), imagePath);
    }

    private boolean appendPadding(StringBuffer sb, Integer padding, String side) {
        boolean addedToStyle = false;
        if (padding > 0) {
            sb.append("padding");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(this.toSizeUnit(padding));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    private boolean appendPen(StringBuffer sb, JRPen pen, String side) {
        boolean addedToStyle = false;
        float borderWidth = pen.getLineWidth().floatValue();
        if (0.0f < borderWidth && borderWidth < 1.0f) {
            borderWidth = 1.0f;
        }
        String borderStyle = null;
        switch (pen.getLineStyleValue()) {
            case DOUBLE: {
                borderStyle = "double";
                break;
            }
            case DOTTED: {
                borderStyle = "dotted";
                break;
            }
            case DASHED: {
                borderStyle = "dashed";
                break;
            }
            default: {
                borderStyle = "solid";
            }
        }
        if (borderWidth > 0.0f) {
            sb.append("border");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(this.toSizeUnit((int)borderWidth));
            sb.append(" ");
            sb.append(borderStyle);
            sb.append(" ");
            sb.append(JRColorUtil.getCssColor(pen.getLineColor()));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell) throws IOException, JRException {
        this.writeCellStart(gridCell);
        StringBuffer styleBuffer = new StringBuffer();
        Color frameBackcolor = this.appendBackcolorStyle(gridCell, styleBuffer);
        this.appendBorderStyle(gridCell.getBox(), styleBuffer);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">\n");
        if (frameBackcolor != null) {
            this.setBackcolor(frameBackcolor);
        }
        try {
            this.exportGrid(((ElementGridCell)gridCell).getLayout(), false);
        }
        finally {
            if (frameBackcolor != null) {
                this.restoreBackcolor();
            }
        }
        this.writeCellEnd(gridCell);
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = this.backcolorStack.removeLast();
    }

    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int rowHeight) throws IOException {
        GenericElementHtmlHandler handler = (GenericElementHtmlHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), HTML_EXPORTER_KEY);
        if (handler == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No HTML generic element handler for " + element.getGenericType()));
            }
            this.writeEmptyCell(gridCell, rowHeight);
        } else {
            this.writeCellStart(gridCell);
            StringBuffer styleBuffer = new StringBuffer();
            this.appendBackcolorStyle(gridCell, styleBuffer);
            this.appendBorderStyle(gridCell.getBox(), styleBuffer);
            if (styleBuffer.length() > 0) {
                this.writer.write(" style=\"");
                this.writer.write(styleBuffer.toString());
                this.writer.write("\"");
            }
            this.writer.write(">");
            String htmlFragment = handler.getHtmlFragment((JRHtmlExporterContext)this.exporterContext, element);
            if (htmlFragment != null) {
                this.writer.write(htmlFragment);
            }
            this.writeCellEnd(gridCell);
        }
    }

    public Map<JRExporterParameter, Object> getExportParameters() {
        return this.parameters;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return HTML_EXPORTER_PROPERTIES_PREFIX;
    }

    @Override
    public String getExporterKey() {
        return HTML_EXPORTER_KEY;
    }

    public JasperPrint getExportedReport() {
        return this.jasperPrint;
    }

    public String toSizeUnit(float size) {
        Number number = Float.valueOf(this.toZoom(size));
        if ((float)((Number)number).intValue() == ((Number)number).floatValue()) {
            number = ((Number)number).intValue();
        }
        return String.valueOf(number) + ((JRHtmlReportConfiguration)this.getCurrentItemConfiguration()).getSizeUnit().getName();
    }

    public String toSizeUnit(int size) {
        return this.toSizeUnit((float)size);
    }

    public float toZoom(float size) {
        float zoom = 1.0f;
        Float zoomRatio = ((JRHtmlReportConfiguration)this.getCurrentItemConfiguration()).getZoomRatio();
        if (zoomRatio != null && (zoom = zoomRatio.floatValue()) <= 0.0f) {
            throw new JRRuntimeException("export.common.invalid.zoom.ratio", new Object[]{Float.valueOf(zoom)});
        }
        return zoom * size;
    }

    public int toZoom(int size) {
        return (int)this.toZoom((float)size);
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        short[] lineBreakOffsets;
        JRStyledText styledText = super.getStyledText(textElement, setBackcolor);
        if (styledText != null && (lineBreakOffsets = textElement.getLineBreakOffsets()) != null && lineBreakOffsets.length > 0) {
            styledText = styledText.cloneText();
            styledText.insert("\n", lineBreakOffsets);
        }
        return styledText;
    }

    protected static interface StringProvider {
        public String getStringForCollapsedTD(int var1, int var2);

        public String getStringForEmptyTD();

        public String getReportTableStyle();
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRHtmlExporterContext {
        protected ExporterContext() {
            super(JRHtmlExporter.this);
        }

        @Override
        public String getExportPropertiesPrefix() {
            return JRHtmlExporter.HTML_EXPORTER_PROPERTIES_PREFIX;
        }

        @Override
        public String getHyperlinkURL(JRPrintHyperlink link) {
            return JRHtmlExporter.this.getHyperlinkURL(link);
        }
    }
}

