/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.oasis.CellStyle;
import net.sf.jasperreports.engine.export.oasis.ColumnStyle;
import net.sf.jasperreports.engine.export.oasis.FrameStyle;
import net.sf.jasperreports.engine.export.oasis.GraphicStyle;
import net.sf.jasperreports.engine.export.oasis.ParagraphStyle;
import net.sf.jasperreports.engine.export.oasis.RowStyle;
import net.sf.jasperreports.engine.export.oasis.TableStyle;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class StyleCache {
    private final JasperReportsContext jasperReportsContext;
    private final WriterHelper styleWriter;
    private Set<String> fontFaces = new HashSet<String>();
    private final String exporterKey;
    private Map<String, String> tableStyles = new HashMap<String, String>();
    private int tableStylesCounter;
    private Map<String, String> rowStyles = new HashMap<String, String>();
    private int rowStylesCounter;
    private Map<String, String> columnStyles = new HashMap<String, String>();
    private int columnStylesCounter;
    private Map<String, String> frameStyles = new HashMap<String, String>();
    private int frameStylesCounter;
    private Map<String, String> cellStyles = new HashMap<String, String>();
    private int cellStylesCounter;
    private Map<String, String> graphicStyles = new HashMap<String, String>();
    private int graphicStylesCounter;
    private Map<String, String> paragraphStyles = new HashMap<String, String>();
    private int paragraphStylesCounter;
    private Map<String, String> textSpanStyles = new HashMap<String, String>();
    private int textSpanStylesCounter;

    public StyleCache(JasperReportsContext jasperReportsContext, WriterHelper styleWriter, String exporterKey) {
        this.jasperReportsContext = jasperReportsContext;
        this.styleWriter = styleWriter;
        this.exporterKey = exporterKey;
    }

    public Collection<String> getFontFaces() {
        return this.fontFaces;
    }

    public String getTableStyle(int width, int pageFormatIndex, boolean isFrame, boolean isPageBreak) throws IOException {
        TableStyle tableStyle = new TableStyle(this.styleWriter, width, pageFormatIndex, isFrame, isPageBreak);
        String tableStyleId = tableStyle.getId();
        String tableStyleName = this.tableStyles.get(tableStyleId);
        if (tableStyleName == null) {
            tableStyleName = "TBL" + this.tableStylesCounter++;
            this.tableStyles.put(tableStyleId, tableStyleName);
            tableStyle.write(tableStyleName);
        }
        return tableStyleName;
    }

    public String getRowStyle(int rowHeight) throws IOException {
        RowStyle rowStyle = new RowStyle(this.styleWriter, rowHeight);
        String rowStyleId = rowStyle.getId();
        String rowStyleName = this.rowStyles.get(rowStyleId);
        if (rowStyleName == null) {
            rowStyleName = "TR" + this.rowStylesCounter++;
            this.rowStyles.put(rowStyleId, rowStyleName);
            rowStyle.write(rowStyleName);
        }
        return rowStyleName;
    }

    public String getColumnStyle(int columnWidth) throws IOException {
        ColumnStyle columnStyle = new ColumnStyle(this.styleWriter, columnWidth);
        String columnStyleId = columnStyle.getId();
        String columnStyleName = this.columnStyles.get(columnStyleId);
        if (columnStyleName == null) {
            columnStyleName = "TC" + this.columnStylesCounter++;
            this.columnStyles.put(columnStyleId, columnStyleName);
            columnStyle.write(columnStyleName);
        }
        return columnStyleName;
    }

    public String getFrameStyle(JRPrintText text) throws IOException {
        FrameStyle frameStyle = new FrameStyle(this.styleWriter, text);
        frameStyle.setBox(text.getLineBox());
        String frameStyleId = frameStyle.getId();
        String frameStyleName = this.frameStyles.get(frameStyleId);
        if (frameStyleName == null) {
            frameStyleName = "F" + this.frameStylesCounter++;
            this.frameStyles.put(frameStyleId, frameStyleName);
            frameStyle.write(frameStyleName);
        }
        return frameStyleName;
    }

    public String getFrameStyle(JRPrintElement element) throws IOException {
        FrameStyle frameStyle = new FrameStyle(this.styleWriter, element);
        String frameStyleId = frameStyle.getId();
        String frameStyleName = this.frameStyles.get(frameStyleId);
        if (frameStyleName == null) {
            frameStyleName = "F" + this.frameStylesCounter++;
            this.frameStyles.put(frameStyleId, frameStyleName);
            frameStyle.write(frameStyleName);
        }
        return frameStyleName;
    }

    public String getGraphicStyle(JRPrintGraphicElement element) {
        GraphicStyle graphicStyle = new GraphicStyle(this.styleWriter, element);
        String graphicStyleId = graphicStyle.getId();
        String graphicStyleName = this.cellStyles.get(graphicStyleId);
        if (graphicStyleName == null) {
            graphicStyleName = "G" + this.graphicStylesCounter++;
            this.graphicStyles.put(graphicStyleId, graphicStyleName);
            graphicStyle.write(graphicStyleName);
        }
        return graphicStyleName;
    }

    public String getCellStyle(JRExporterGridCell gridCell) {
        return this.getCellStyle(gridCell, false, true);
    }

    public String getCellStyle(JRExporterGridCell gridCell, boolean shrinkToFit, boolean wrapText) {
        CellStyle cellStyle = new CellStyle(this.styleWriter, gridCell, shrinkToFit, wrapText);
        String cellStyleId = cellStyle.getId();
        String cellStyleName = this.cellStyles.get(cellStyleId);
        if (cellStyleName == null) {
            cellStyleName = "C" + this.cellStylesCounter++;
            this.cellStyles.put(cellStyleId, cellStyleName);
            cellStyle.write(cellStyleName);
        }
        return cellStyleName;
    }

    public String getParagraphStyle(JRPrintText text, boolean isIgnoreTextFormatting) {
        ParagraphStyle paragraphStyle = new ParagraphStyle(this.styleWriter, text, isIgnoreTextFormatting);
        String paragraphStyleId = paragraphStyle.getId();
        String paragraphStyleName = this.paragraphStyles.get(paragraphStyleId);
        if (paragraphStyleName == null) {
            paragraphStyleName = "P" + this.paragraphStylesCounter++;
            this.paragraphStyles.put(paragraphStyleId, paragraphStyleName);
            paragraphStyle.write(paragraphStyleName);
        }
        return paragraphStyleName;
    }

    public String getTextSpanStyle(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale, boolean isIgnoreTextFormatting) {
        String textSpanStyleId;
        String textSpanStyleName;
        FontFamily family;
        String exportFont;
        String fontFamilyAttr;
        if (isIgnoreTextFormatting) {
            String textSpanStyleName2 = this.textSpanStyles.get("");
            if (textSpanStyleName2 == null) {
                textSpanStyleName2 = "T" + this.textSpanStylesCounter++;
                this.textSpanStyles.put("", textSpanStyleName2);
                this.styleWriter.write("<style:style style:name=\"" + textSpanStyleName2 + "\"");
                this.styleWriter.write(" style:family=\"text\">\n");
                this.styleWriter.write("<style:text-properties>\n");
                this.styleWriter.write("</style:text-properties>\n");
                this.styleWriter.write("</style:style>\n");
            }
            return textSpanStyleName2;
        }
        String fontFamily = fontFamilyAttr = (String)attributes.get(TextAttribute.FAMILY);
        FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(fontFamilyAttr, locale);
        if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.exporterKey)) != null) {
            fontFamily = exportFont;
        }
        this.fontFaces.add(fontFamily);
        StringBuffer textSpanStyleIdBuffer = new StringBuffer();
        textSpanStyleIdBuffer.append(fontFamily);
        String forecolorHexa = null;
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        if (!Color.black.equals(forecolor)) {
            forecolorHexa = JRColorUtil.getColorHexa(forecolor);
            textSpanStyleIdBuffer.append(forecolorHexa);
        }
        String backcolorHexa = null;
        Color runBackcolor = (Color)attributes.get(TextAttribute.BACKGROUND);
        if (runBackcolor != null) {
            backcolorHexa = JRColorUtil.getColorHexa(runBackcolor);
            textSpanStyleIdBuffer.append(backcolorHexa);
        }
        String size = String.valueOf(attributes.get(TextAttribute.SIZE));
        textSpanStyleIdBuffer.append(size);
        String weight = null;
        if (TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT))) {
            weight = "bold";
            textSpanStyleIdBuffer.append(weight);
        }
        String posture = null;
        if (TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE))) {
            posture = "italic";
            textSpanStyleIdBuffer.append(posture);
        }
        String underline = null;
        if (TextAttribute.UNDERLINE_ON.equals(attributes.get(TextAttribute.UNDERLINE))) {
            underline = "single";
            textSpanStyleIdBuffer.append(underline);
        }
        String strikeThrough = null;
        if (TextAttribute.STRIKETHROUGH_ON.equals(attributes.get(TextAttribute.STRIKETHROUGH))) {
            strikeThrough = "single";
            textSpanStyleIdBuffer.append(strikeThrough);
        }
        if ((textSpanStyleName = this.textSpanStyles.get(textSpanStyleId = textSpanStyleIdBuffer.toString())) == null) {
            textSpanStyleName = "T" + this.textSpanStylesCounter++;
            this.textSpanStyles.put(textSpanStyleId, textSpanStyleName);
            this.styleWriter.write("<style:style style:name=\"" + textSpanStyleName + "\"");
            this.styleWriter.write(" style:family=\"text\">\n");
            this.styleWriter.write("<style:text-properties");
            if (forecolorHexa != null) {
                this.styleWriter.write(" fo:color=\"#" + forecolorHexa + "\"");
            }
            this.styleWriter.write(" style:font-name=\"" + fontFamily + "\"");
            this.styleWriter.write(" fo:font-size=\"" + size + "pt\"");
            this.styleWriter.write(" style:font-size-asian=\"" + size + "pt\"");
            this.styleWriter.write(" style:font-size-complex=\"" + size + "pt\"");
            if (posture != null) {
                this.styleWriter.write(" fo:font-style=\"" + posture + "\"");
            }
            if (weight != null) {
                this.styleWriter.write(" fo:font-weight=\"" + weight + "\"");
            }
            if (backcolorHexa != null) {
                this.styleWriter.write(" fo:background-color=\"#" + backcolorHexa + "\"");
            }
            if (underline != null) {
                this.styleWriter.write(" style:text-underline-type=\"" + underline + "\"");
            }
            if (strikeThrough != null) {
                this.styleWriter.write(" style:text-line-through-type=\"" + strikeThrough + "\"");
            }
            this.styleWriter.write(">\n");
            this.styleWriter.write("</style:text-properties>\n");
            this.styleWriter.write("</style:style>\n");
        }
        return textSpanStyleName;
    }
}

