/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.TypeTextValueHandler;
import net.sf.jasperreports.engine.export.ooxml.XlsxStyleHelper;

public class XlsxCellHelper
extends BaseHelper {
    private XlsxStyleHelper styleHelper;
    private final TypeTextValueHandler textValueHandler = new TypeTextValueHandler();

    public XlsxCellHelper(JasperReportsContext jasperReportsContext, Writer writer, XlsxStyleHelper styleHelper) {
        super(jasperReportsContext, writer);
        this.styleHelper = styleHelper;
    }

    public void exportHeader(JRExporterGridCell gridCell, int rowIndex, int colIndex) {
        this.exportHeader(gridCell, rowIndex, colIndex, null, null, null, true, false, false, false, false);
    }

    public void exportHeader(JRExporterGridCell gridCell, int rowIndex, int colIndex, TextValue textValue, String pattern, Locale locale, boolean isWrapText, boolean isHidden, boolean isLocked, boolean isShrinkToFit, boolean isIgnoreTextFormatting) {
        try {
            if (textValue != null) {
                textValue.handle(this.textValueHandler);
            } else {
                this.textValueHandler.handle((StringTextValue)null);
            }
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        this.write("  <c r=\"" + XlsxCellHelper.getColumIndexLetter(colIndex) + (rowIndex + 1) + "\" s=\"" + this.styleHelper.getCellStyle(gridCell, pattern, locale, isWrapText, isHidden, isLocked, isShrinkToFit, isIgnoreTextFormatting) + "\"");
        String type = this.textValueHandler.getType();
        if (type != null) {
            this.write(" t=\"" + type + "\"");
        }
        this.write(">");
    }

    public void exportFooter() {
        this.write("</c>");
    }

    public static String getColumIndexLetter(int colIndex) {
        int intFirstLetter = colIndex / 676 + 64;
        int intSecondLetter = colIndex % 676 / 26 + 64;
        int intThirdLetter = colIndex % 26 + 65;
        int firstLetter = intFirstLetter > 64 ? (int)intFirstLetter : 32;
        int secondLetter = intSecondLetter > 64 ? (int)intSecondLetter : 32;
        char thirdLetter = (char)intThirdLetter;
        return ("" + (char)firstLetter + (char)secondLetter + thirdLetter).trim();
    }
}

