/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRSubreportRunResult;
import net.sf.jasperreports.engine.fill.JRSubreportRunnable;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractThreadSubreportRunner
extends JRSubreportRunnable
implements JRSubreportRunner {
    private static final Log log = LogFactory.getLog(AbstractThreadSubreportRunner.class);
    public static final String EXCEPTION_MESSAGE_KEY_THREAD_REPORT_RUNNER_WAIT_ERROR = "fill.thread.report.runner.wait.error";
    public static final String EXCEPTION_MESSAGE_KEY_THREAD_SUBREPORT_RUNNER_WAIT_ERROR = "fill.thread.subreport.runner.wait.error";
    protected final JRBaseFiller subreportFiller;

    public AbstractThreadSubreportRunner(JRFillSubreport fillSubreport, JRBaseFiller subreportFiller) {
        super(fillSubreport);
        this.subreportFiller = subreportFiller;
    }

    @Override
    public JRSubreportRunResult start() {
        this.doStart();
        return this.waitResult();
    }

    protected abstract void doStart();

    @Override
    public JRSubreportRunResult resume() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": notifying to continue"));
        }
        this.subreportFiller.notifyAll();
        return this.waitResult();
    }

    protected JRSubreportRunResult waitResult() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": waiting for fill result"));
        }
        try {
            this.subreportFiller.wait();
        }
        catch (InterruptedException e) {
            if (this.subreportFiller.fillContext.isCanceled()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": exception"), (Throwable)e);
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)("Fill " + this.subreportFiller.fillerId + ": exception"), (Throwable)e);
            }
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_THREAD_REPORT_RUNNER_WAIT_ERROR, null, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": notified of fill result"));
        }
        return this.runResult();
    }

    @Override
    public void cancel() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": notifying to continue on cancel"));
        }
        this.subreportFiller.notifyAll();
        if (this.isRunning()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": still running, waiting"));
            }
            try {
                this.subreportFiller.wait();
            }
            catch (InterruptedException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Fill " + this.subreportFiller.fillerId + ": exception"), (Throwable)e);
                }
                throw new JRException(EXCEPTION_MESSAGE_KEY_THREAD_SUBREPORT_RUNNER_WAIT_ERROR, null, e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": wait ended"));
            }
        }
    }

    @Override
    public void suspend() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": notifying on suspend"));
        }
        this.subreportFiller.notifyAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": waiting to continue"));
        }
        try {
            this.subreportFiller.wait();
        }
        catch (InterruptedException e) {
            if (this.subreportFiller.fillContext.isCanceled() || this.subreportFiller.isDeliberatelyInterrupted()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": exception"), (Throwable)e);
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)("Fill " + this.subreportFiller.fillerId + ": exception"), (Throwable)e);
            }
            throw new JRException(EXCEPTION_MESSAGE_KEY_THREAD_SUBREPORT_RUNNER_WAIT_ERROR, null, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": notified to continue"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.subreportFiller.fillerId + ": notifying of completion"));
        }
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            this.subreportFiller.notifyAll();
        }
    }
}

