/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.repo.ReportResource;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;

public final class RepositoryUtil {
    public static final String EXCEPTION_MESSAGE_KEY_BYTE_DATA_LOADING_ERROR = "repo.byte.data.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_BYTE_DATA_NOT_FOUND = "repo.byte.data.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_INPUT_STREAM_NOT_FOUND = "repo.input.stream.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_NOT_FOUND = "repo.report.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_RESOURCET_NOT_FOUND = "repo.resource.not.found";
    private AtomicReference<List<RepositoryService>> repositoryServices = new AtomicReference();
    private JasperReportsContext jasperReportsContext;

    private RepositoryUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static RepositoryUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new RepositoryUtil(jasperReportsContext);
    }

    private List<RepositoryService> getServices() {
        List<RepositoryService> cachedServices = this.repositoryServices.get();
        if (cachedServices != null) {
            return cachedServices;
        }
        List<RepositoryService> services = this.jasperReportsContext.getExtensions(RepositoryService.class);
        if (this.repositoryServices.compareAndSet(null, services)) {
            return services;
        }
        return this.repositoryServices.get();
    }

    public JasperReport getReport(ReportContext reportContext, String location) throws JRException {
        JasperReport jasperReport = null;
        JasperDesignCache cache = JasperDesignCache.getInstance(this.jasperReportsContext, reportContext);
        if (cache != null) {
            jasperReport = cache.getJasperReport(location);
        }
        if (jasperReport == null) {
            ReportResource resource = this.getResourceFromLocation(location, ReportResource.class);
            if (resource == null) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_REPORT_NOT_FOUND, new Object[]{location});
            }
            jasperReport = resource.getReport();
            if (cache != null) {
                cache.set(location, jasperReport);
            }
        }
        return jasperReport;
    }

    public <K extends Resource> K getResourceFromLocation(String location, Class<K> resourceType) throws JRException {
        K resource = null;
        List<RepositoryService> services = this.getServices();
        if (services != null) {
            RepositoryService service;
            Iterator<RepositoryService> i$ = services.iterator();
            while (i$.hasNext() && (resource = (K)(service = i$.next()).getResource(location, resourceType)) == null) {
            }
        }
        if (resource == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_RESOURCET_NOT_FOUND, new Object[]{location});
        }
        return resource;
    }

    public InputStream getInputStreamFromLocation(String location) throws JRException {
        InputStream is = this.findInputStream(location);
        if (is == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_INPUT_STREAM_NOT_FOUND, new Object[]{location});
        }
        return is;
    }

    private InputStream findInputStream(String location) throws JRException {
        InputStreamResource inputStreamResource;
        block1: {
            RepositoryService service;
            inputStreamResource = null;
            List<RepositoryService> services = this.getServices();
            if (services == null) break block1;
            Iterator<RepositoryService> i$ = services.iterator();
            while (i$.hasNext() && (inputStreamResource = (service = i$.next()).getResource(location, InputStreamResource.class)) == null) {
            }
        }
        return inputStreamResource == null ? null : inputStreamResource.getInputStream();
    }

    public byte[] getBytesFromLocation(String location) throws JRException {
        InputStream is = this.findInputStream(location);
        if (is == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_BYTE_DATA_NOT_FOUND, new Object[]{location});
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_BYTE_DATA_LOADING_ERROR, new Object[]{location}, e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return baos.toByteArray();
    }
}

