<?php

use yii\helpers\Html;
use kartik\grid\GridView;
use yii\widgets\Pjax;
use Yii\helpers\Url;
use yii\helpers\Inflector;
use yii\helpers\StringHelper;

/**
 * @var yii\web\View $this
 * @var yii\data\ActiveDataProvider $dataProvider
 * @var app\models\DocumentosUnidadesSearch $searchModel
 */

$this->title = Yii::t('app', 'Documentos Unidades');
$this->params['breadcrumbs'][] = $this->title;
$this->params['parent_model'] = $parent_model ;
$this->params['relation'] = $relation ;
?>
<div class="documentos-unidades-index-ajax-picker">
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?php /* echo Html::a(Yii::t('app', 'Create {modelClass}', [
    'modelClass' => 'Documentos Unidades',
]), ['create'], ['class' => 'btn btn-success'])*/  ?>
    </p>

    <?php // Pjax::begin(['id' => 'documentos-unidades-picker-ajax-gv-pjax', 'timeout' => false, 'enablePushState' => false]);
    

    $relations = \Yii::$app->params['relations'][$parent_model][$relation]['mappings'] ;

    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'id' => 'documentos-unidades-' . $relation . '-picker-ajax-gv',
        'filterModel' => $searchModel,
       'pjax' => true,
       'columns' => [
            // ['class' => 'yii\grid\SerialColumn'],
            [
                'header'=>'Selecciona',
                'value'=> function($data)
                  {
                        $parent_model = $this->params['parent_model'];
                        $parent_model_lower = strtolower($parent_model);

                        
                        $relation = $this->params['relation'];
                        $relations = \Yii::$app->params['relations'][$parent_model][$relation]['mappings'] ;
                        $virtual_prefijo = str_replace("-", "_", Inflector::camel2id(StringHelper::basename($relation))) ;
                        foreach($relations as $attribute => $settings) {
                            $local_attribute = is_array($settings) ? $settings[0] : $settings ;   
                            $val = $data->$local_attribute ;   
                            $assigments[] = "\$('input#" . $parent_model_lower . "-" . "$attribute').attr('value', '$val');" ;

                            $virtual = $virtual_prefijo . "_" . $attribute ;
                            $assigments[] = "\$('input#" . $parent_model_lower . "-" . "$virtual').attr('value', '$val');" ;
                        
                        };
                        $mappings = implode("\n", $assigments) ;
                       return  Html::a( 'Selecciona',
                                        Url::to("#"),
                                      ['onclick'=>"
                                           ${mappings}
                                          $(\"#modal${relation}Picker\").modal('hide');
                                          return false",
                                      ]

                                );      
                  },
                'format' => 'raw'
            ],

            'nombre_documento',
            'descripcion_documento',
            'unidades_id',
            'documento',

        ],
        'responsive'=>true,
        'hover'=>true,
        'condensed'=>true,
        'floatHeader'=>false,




        'panel' => [
            'heading'=>'<h3 class="panel-title"><i class="glyphicon glyphicon-th-list"></i> '.Html::encode($this->title).' </h3>',
            'type'=>'info',
           // 'before'=>Html::a('<i class="glyphicon glyphicon-plus"></i> Crear', ['create'], ['class' => 'btn btn-success']),
           // 'after'=>Html::a('<i class="glyphicon glyphicon-repeat"></i> Refrescar', ['index'], ['class' => 'btn btn-info']),
            'showFooter'=>false
        ],
    ]); /*Pjax::end();*/ ?>

</div>
